/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;

public class Token {
    public int tok;
    public Object value;
    public int intValue = Integer.MAX_VALUE;
    static final int nada = 0;
    public static final int identifier = 1;
    static final int integer = 2;
    static final int decimal = 3;
    static final int string = 4;
    static final int seqcode = 5;
    static final int list = 6;
    public static final int point3f = 7;
    public static final int point4f = 8;
    static final int keyword = 9;
    static final int truefalse = 10;
    static final String[] astrType = new String[]{"nada", "identifier", "integer", "decimal", "string", "seqcode", "list", "point", "plane", "keyword"};
    static final int command = 256;
    static final int expressionCommand = 512;
    static final int embeddedExpression = 1024;
    static final int specialstring = 2048;
    static final int negnums = 4096;
    static final int noeval = 8192;
    static final int flowCommand = 16384;
    private static final int numberOrExpression = 5120;
    static final int implicitExpression = 37888;
    static final int setparam = 65536;
    static final int colorparam = 131072;
    static final int misc = 262144;
    static final int expression = 524288;
    static final int predefinedset = 0x180000;
    static final int atomproperty = 0x280000;
    static final int mathproperty = 0x680000;
    static final int mathop = 0x880000;
    static final int mathfunc = 0x1080000;
    static final int comparator = 0x2080000;
    static final int settable = 0x4000000;
    static final int varArgCount = 16;
    static final int maxArg1 = 17;
    static final int maxArg2 = 18;
    static final int maxArg3 = 19;
    static final int maxArg4 = 20;
    static final int onDefault1 = 33;
    static final int backbone = 0x180100;
    static final int background = 196865;
    static final int cartoon = 259;
    static final int center = 772;
    static final int connect = 136455;
    static final int define = 590601;
    static final int dots = 1290;
    static final int echo = 67851;
    static final int exit = 268;
    static final int hbond = 590093;
    static final int help = 2318;
    static final int monitor = 591122;
    static final int pause = 264467;
    static final int quit = 277;
    static final int refresh = 278;
    static final int reset = 280;
    static final int restrict = 793;
    static final int ribbon = 282;
    static final int rotate = 5403;
    static final int save = 284;
    static final int select = 798;
    static final int set = 169247;
    static final int show = 288;
    static final int slab = 5409;
    static final int spacefill = 4387;
    static final int ssbond = 65828;
    static final int stereo = 135462;
    static final int strands = 65831;
    static final int trace = 297;
    static final int translate = 4394;
    static final int wireframe = 300;
    static final int write = 301;
    static final int zap = 302;
    static final int zoom = 5423;
    static final int zoomTo = 5424;
    static final int initialize = 305;
    static final int depth = 5426;
    static final int star = 307;
    static final int delay = 316;
    static final int loop = 317;
    static final int move = 4414;
    static final int spin = 70976;
    static final int animation = 323;
    static final int frame = 324;
    static final int trajectory = 334;
    static final int hide = 847;
    static final int font = 336;
    static final int hover = 2385;
    static final int vibration = 4434;
    static final int vector = 4435;
    static final int meshRibbon = 340;
    static final int halo = 341;
    static final int rocket = 342;
    static final int geosurface = 1367;
    static final int moveto = 5464;
    static final int bondorder = 4441;
    static final int console = 346;
    static final int pmesh = 347;
    static final int polyhedra = 132444;
    static final int centerAt = 349;
    static final int isosurface = 136542;
    static final int draw = 136543;
    static final int dipole = 5473;
    static final int configuration = 354;
    static final int mo = 135523;
    static final int lcaocartoon = 136548;
    static final int message = 2405;
    static final int translateSelected = 4454;
    static final int calculate = 1383;
    static final int restore = 360;
    static final int selectionHalo = 65897;
    static final int history = 65898;
    static final int display = 66411;
    static final int subset = 1573740;
    static final int axes = 65901;
    public static final int unitcell = 1638767;
    static final int frank = 65904;
    static final int navigate = 5489;
    static final int gotocmd = 370;
    static final int invertSelected = 5491;
    static final int rotateSelected = 5492;
    static final int quaternion = 373;
    static final int ramachandran = 374;
    static final int sync = 375;
    static final int print = 38264;
    static final int returncmd = 38265;
    static final int var = 111994;
    static final int function = 17326337;
    static final int ifcmd = 54530;
    static final int elseif = 54531;
    static final int elsecmd = 16644;
    static final int endifcmd = 16645;
    static final int forcmd = 54534;
    static final int whilecmd = 54535;
    static final int breakcmd = 16648;
    static final int continuecmd = 16649;
    static final int end = 24842;
    static final int expressionBegin = 524388;
    static final int expressionEnd = 524389;
    static final int dot = 524289;
    static final int colon = 524290;
    static final int leftbrace = 524291;
    static final int rightbrace = 524292;
    static final int dollarsign = 524293;
    static final int altloc = 524294;
    static final int insertion = 524295;
    public static final int group = 524296;
    public static final int chain = 524297;
    public static final int sequence = 524298;
    static final int coord = 524300;
    static final int none = 524301;
    static final int semicolon = 524302;
    static final int all = 524303;
    static final int off = 524304;
    static final int on = 524305;
    public static final int isaromatic = 524306;
    public static final int spec_resid = 524312;
    public static final int spec_name_pattern = 524313;
    public static final int spec_seqcode = 524314;
    public static final int spec_seqcode_range = 524315;
    public static final int spec_chain = 524316;
    public static final int spec_alternate = 524317;
    public static final int spec_model = 524318;
    static final int spec_model2 = 524319;
    public static final int spec_atom = 524320;
    static final int amino = 0x180000;
    public static final int hetero = 0x190001;
    public static final int hydrogen = 1638402;
    static final int selected = 1572867;
    static final int solvent = 1638404;
    static final int sidechain = 1572869;
    public static final int protein = 1572870;
    public static final int nucleic = 1572871;
    public static final int dna = 0x180008;
    public static final int rna = 1572873;
    public static final int purine = 1572874;
    public static final int pyrimidine = 1572875;
    static final int surface = 1572876;
    static final int thismodel = 1572877;
    static final int visible = 0x180011;
    static final int clickable = 1572882;
    public static final int carbohydrate = 1572883;
    static final int hidden = 1572884;
    static final int displayed = 1572885;
    public static final int symmetry = 1572886;
    public static final int specialposition = 1572887;
    static final int leftparen = 0x880000;
    static final int rightparen = 0x880001;
    static final int comma = 0x880008;
    static final int leftsquare = 0x880010;
    static final int rightsquare = 0x880011;
    static final int opOr = 0x880018;
    static final int opXor = 8912921;
    static final int opToggle = 8912922;
    static final int opAnd = 0x880020;
    static final int opNot = 0x880028;
    static final int opGT = 42467376;
    static final int opGE = 42467377;
    static final int opLE = 42467378;
    static final int opLT = 42467379;
    static final int opEQ = 42467380;
    static final int opNE = 42467381;
    static final int minus = 0x880038;
    static final int plus = 8912953;
    static final int divide = 0x880040;
    static final int times = 8912961;
    static final int percent = 8912962;
    static final int unaryMinus = 0x880048;
    static final int propselector = 8912977;
    static final int minmaxmask = 192;
    static final int min = 64;
    static final int max = 128;
    static final int atoms = 6815745;
    public static final int bonds = 6881282;
    static final int color = 74126595;
    static final int ident = 6815748;
    static final int length = 6815749;
    static final int lines = 0x680006;
    static final int size = 6815751;
    static final int type = 0x680008;
    public static final int xyz = 73924617;
    public static final int fracXyz = 73924618;
    public static final int vibXyz = 73924619;
    static final int property = 73990156;
    static final int boundbox = 6886669;
    static final int atompropertyfloat = 0x280020;
    public static final int atomno = 2621441;
    static final int atomID = 0x280002;
    static final int bondcount = 2621443;
    static final int atomIndex = 2621444;
    public static final int cell = 2621445;
    public static final int element = 2621446;
    static final int elemno = 2621447;
    static final int file = 2621704;
    public static final int formalCharge = 69795849;
    static final int groupID = 2621450;
    public static final int model = 2621709;
    public static final int molecule = 2621454;
    public static final int occupancy = 69730319;
    static final int polymerLength = 2621456;
    static final int radius = 2686993;
    static final int resno = 2621458;
    public static final int site = 2621459;
    static final int structure = 2622740;
    static final int symop = 2621461;
    public static final int vanderwaals = 69730326;
    public static final int valence = 69730327;
    public static final int atomX = 69730336;
    public static final int atomY = 69730337;
    public static final int atomZ = 69730338;
    public static final int fracX = 69730339;
    public static final int fracY = 69730340;
    public static final int fracZ = 69730341;
    public static final int partialCharge = 69730342;
    static final int phi = 2621479;
    static final int psi = 0x280028;
    static final int surfacedistance = 2621481;
    public static final int temperature = 69730346;
    public static final int vibX = 69730347;
    public static final int vibY = 69730348;
    public static final int vibZ = 69730349;
    static final int array = 0x1080001;
    static final int getproperty = 17302785;
    static final int load = 17305865;
    static final int substructure = 17301514;
    static final int script = 17301771;
    static final int javascript = 17303820;
    static final int split = 23592968;
    static final int join = 23592969;
    static final int trim = 23592970;
    static final int find = 23592971;
    static final int add = 23592972;
    static final int sub = 23592973;
    static final int mul = 23592974;
    static final int div = 23592975;
    static final int label = 23660815;
    static final int data = 17301778;
    static final int distance = 23592977;
    static final int replace = 23592979;
    static final int point = 17301529;
    static final int angle = 17301537;
    static final int plane = 17303586;
    static final int within = 17301545;
    static final int connected = 17301546;
    static final Point3f pt0 = new Point3f();
    static final int ambient = 65536;
    static final int bondmode = 65537;
    static final int fontsize = 65538;
    static final int picking = 65540;
    static final int specular = 65543;
    static final int specpercent = 65544;
    static final int specpower = 65545;
    static final int specexponent = 65546;
    static final int transparent = 65547;
    static final int defaultColors = 65548;
    static final int scale3d = 65565;
    static final int diffuse = 65567;
    static final int pickingStyle = 65569;
    static final int clipboard = 262146;
    static final int spacegroup = 262147;
    static final int normal = 262148;
    static final int rasmol = 262149;
    static final int axisangle = 262150;
    static final int clear = 262152;
    static final int mep = 262153;
    static final int torsion = 262154;
    static final int shapely = 262158;
    static final int colorRGB = 393236;
    static final int user = 262165;
    static final int fixedtemp = 262166;
    static final int dotted = 262174;
    static final int mode = 262175;
    static final int direction = 262176;
    static final int displacement = 262178;
    static final int rubberband = 262181;
    static final int monomer = 262182;
    static final int opaque = 262184;
    static final int translucent = 262185;
    static final int delete = 262186;
    static final int solid = 262189;
    static final int jmol = 262190;
    static final int absolute = 262191;
    static final int average = 262192;
    static final int nodots = 262193;
    static final int mesh = 262194;
    static final int nomesh = 262195;
    static final int fill = 262196;
    static final int nofill = 262197;
    static final int ionic = 262199;
    static final int resume = 262200;
    static final int play = 262201;
    static final int next = 262202;
    static final int prev = 262203;
    static final int rewind = 262204;
    static final int playrev = 262205;
    static final int range = 262206;
    static final int sasurface = 262208;
    static final int left = 262209;
    static final int right = 262210;
    static final int front = 262211;
    static final int back = 262212;
    static final int top = 262213;
    static final int bottom = 262214;
    public static final int bitset = 262215;
    static final int bondset = 262216;
    static final int last = 262217;
    static final int rotation = 262218;
    static final int translation = 262219;
    static final int residue = 262220;
    static final int url = 262221;
    static final int transform = 262222;
    static final int orientation = 262223;
    static final int state = 262224;
    static final int pdbheader = 262225;
    static final int triangles = 262226;
    static final int notriangles = 262227;
    static final int frontonly = 262228;
    static final int notfrontonly = 262229;
    static final int frontlit = 262230;
    static final int backlit = 262231;
    static final int fullylit = 262232;
    static final int shape = 262233;
    static final int polymer = 262234;
    static final Token tokenOn = new Token(524305, 1, "on");
    static final Token tokenOff = new Token(524304, 0, "off");
    static final Token tokenAll = new Token(524303, "all");
    static final Token tokenAnd = new Token(0x880020, "and");
    static final Token tokenOr = new Token(0x880018, "or");
    static final Token tokenComma = new Token(0x880008, ",");
    static final Token tokenPlus = new Token(8912953, "+");
    static final Token tokenMinus = new Token(0x880038, "-");
    static final Token tokenTimes = new Token(8912961, "*");
    static final Token tokenDivide = new Token(0x880040, "/");
    static final Token tokenLeftParen = new Token(0x880000, "(");
    static final Token tokenRightParen = new Token(0x880001, ")");
    static final Token tokenArraySelector = new Token(0x880010, "[");
    static final Token tokenExpressionBegin = new Token(524388, "expressionBegin");
    static final Token tokenExpressionEnd = new Token(524389, "expressionEnd");
    static final Token tokenCoordinateBegin = new Token(524291, "{");
    static final Token tokenCoordinateEnd = new Token(524292, "}");
    static final Token tokenSet = new Token(169247, 61, "");
    static final Token tokenSetArray = new Token(169247, 91, "");
    static final Token tokenSetProperty = new Token(169247, 46, "");
    static final Token tokenSetVar = new Token(169247, 61, "var");
    static final Object[] arrayPairs = new Object[]{"backbone", new Token(0x180100, 33), "background", new Token(196865, 16), "cartoon", new Token(259, 33), "cartoons", null, "center", new Token(772, 16), "centre", null, "color", new Token(74126595, 16), "colour", null, "connect", new Token(136455, 16), "data", new Token(17301778, 20), "define", new Token(590601, 16), "@", null, "dots", new Token(1290, 16), "echo", new Token(67851, 17), "exit", new Token(268, 0), "hbond", new Token(590093, 33), "hbonds", null, "help", new Token(2318, 17), "label", new Token(23660815, 33), "labels", null, "load", new Token(17305865, 16), "measure", new Token(591122, 16), "measures", null, "measurement", null, "measurements", null, "monitor", null, "monitors", null, "pause", new Token(264467, 17), "wait", null, "quit", new Token(277, 0), "refresh", new Token(278, 0), "reset", new Token(280, 17), "restore", new Token(360, 19), "restrict", new Token(793, 16), "hide", new Token(847, 16), "ribbon", new Token(282, 33), "ribbons", null, "rotate", new Token(5403, 16), "save", new Token(284, 19), "script", new Token(17301771, 16), "source", null, "javascript", new Token(17303820, 1), "select", new Token(798, 16), "set", new Token(169247, 16), "show", new Token(288, 18), "slab", new Token(5409, 16), "spacefill", new Token(4387, 18), "cpk", null, "ssbond", new Token(65828, 33), "ssbonds", null, "stereo", new Token(135462, 16), "strand", new Token(65831, 33), "strands", null, "trace", new Token(297, 33), "translate", new Token(4394, 2), "wireframe", new Token(300, 33), "write", new Token(301, 16), "zap", new Token(302, 0), "zoom", new Token(5423, 16), "zoomTo", new Token(5424, 16), "initialize", new Token(305, 0), "depth", new Token(5426, 16), "star", new Token(307, 18), "stars", null, "delay", new Token(316, 33), "loop", new Token(317, 33), "move", new Token(4414, 16), "spin", new Token(70976, 16), "frame", new Token(324, 16), "frames", null, "trajectory", new Token(334, 16), "trajectories", null, "animation", new Token(323), "anim", null, "function", new Token(17326337, 16), "functions", null, "end", new Token(24842, 16), "return", new Token(38265, 16), "var", new Token(111994, 16), "centerat", new Token(349, 16), "font", new Token(336, 16), "hover", new Token(2385, 33), "vibration", new Token(4434, 18), "vector", new Token(4435, 18), "vectors", null, "meshribbon", new Token(340, 33), "meshribbons", null, "halo", new Token(341, 18), "halos", null, "rocket", new Token(342, 33), "rockets", null, "moveto", new Token(5464, 16), "navigate", new Token(5489, 16), "navigation", null, "bondorder", new Token(4441, 18), "console", new Token(346, 33), "pmesh", new Token(347, 16), "draw", new Token(136543, 16), "dipole", new Token(5473, 16), "dipoles", null, "polyhedra", new Token(132444, 16), "mo", new Token(135523, 16), "isosurface", new Token(136542, 16), "geosurface", new Token(1367, 16), "getproperty", new Token(17302785, 16), "lcaocartoon", new Token(136548, 16), "lcaocartoons", null, "message", new Token(2405, 1), "if", new Token(54530, 16), "for", new Token(54534, 16), "while", new Token(54535, 16), "break", new Token(16648, 0), "continue", new Token(16649, 0), "else", new Token(16644, 0), "endif", new Token(16645, 0), "elseif", new Token(54531, 16), "goto", new Token(370, 1), "calculate", new Token(1383, 16), "history", new Token(65898, 18), "subset", new Token(1573740, 16), "boundbox", new Token(6886669, 16), "frank", new Token(65904, 33), "unitcell", new Token(1638767, 16), "selectionHalos", new Token(65897, 33), "selectionhalo", null, "translateSelected", new Token(4454, 16), "configuration", new Token(354, 16), "config", null, "conformation", null, "invertSelected", new Token(5491, 16), "rotateSelected", new Token(5492, 16), "quaternion", new Token(373, 16), "quaternions", null, "ramachandran", new Token(374, 0), "rama", null, "synchronize", new Token(375, 18), "sync", null, "print", new Token(38264, 16), "model", new Token(2621709, 16), "models", null, "thisModel", new Token(1572877), "file", new Token(2621704, 1), "axes", new Token(65901, 16), "bondmode", new Token(65537), "bonds", new Token(6881282), "bond", null, "display", new Token(66411, 16), "fontsize", new Token(65538), "picking", new Token(65540), "pickingStyle", new Token(65569), "radius", new Token(2686993), "structure", new Token(2622740, 16), "_structure", null, "transparent", new Token(65547), "cell", new Token(2621445), "clear", new Token(262152), "mep", new Token(262153), "scale3D", new Token(65565), "property", new Token(73990156), "formalCharge", new Token(69795849), "charge", null, "partialCharge", new Token(69730342), "phi", new Token(2621479), "psi", new Token(0x280028), "ambientPercent", new Token(65536), "ambient", null, "diffusePercent", new Token(65567), "diffuse", null, "specular", new Token(65543), "specularPercent", new Token(65544), "specularPower", new Token(65545), "specpower", null, "specularExponent", new Token(65546), "rotation", new Token(262218), "group", new Token(524296), "chain", new Token(524297), "atom", new Token(6815745), "atoms", null, "sequence", new Token(524298), "specialPosition", new Token(1572887), "symmetry", new Token(1572886), "spaceGroup", new Token(262147), "translation", new Token(262219), "residue", new Token(262220), "pdbheader", new Token(262225), "axisangle", new Token(262150), "transform", new Token(262222), "orientation", new Token(262223), "polymer", new Token(262234), "polymers", null, "state", new Token(262224), "shape", new Token(262233), "url", new Token(262221), "(", tokenLeftParen, ")", tokenRightParen, "and", tokenAnd, "&", null, "&&", null, "or", tokenOr, ",", tokenComma, "|", null, "||", null, "not", new Token(0x880028), "!", null, "xor", new Token(8912921), "tog", new Token(8912922), ",|", null, "<", new Token(42467379), "<=", new Token(42467378), ">=", new Token(42467377), ">", new Token(42467376), "=", new Token(42467380), "==", null, "!=", new Token(42467381), "<>", null, "/=", null, "within", new Token(17301545), ".", new Token(524289), "[", new Token(0x880010), "]", new Token(0x880011), "{", new Token(524291), "}", new Token(524292), "$", new Token(524293), "%", new Token(8912962), ":", new Token(524290), ";", new Token(524302), "+", tokenPlus, "-", tokenMinus, "*", tokenTimes, "/", tokenDivide, "molecule", new Token(2621454), "molecules", null, "altloc", new Token(524294), "altlocs", null, "insertion", new Token(524295), "insertions", null, "substructure", new Token(17301514), "connected", new Token(17301546), "atomIndex", new Token(2621444), "atomno", new Token(2621441), "elemno", new Token(2621447), "_e", null, "element", new Token(2621446), "resno", new Token(2621458), "temperature", new Token(69730346), "relativetemperature", null, "bondCount", new Token(2621443), "groupID", new Token(2621450), "_groupID", null, "_g", null, "atomID", new Token(0x280002), "_atomID", null, "_a", null, "occupancy", new Token(69730319), "polymerLength", new Token(2621456), "site", new Token(2621459), "symop", new Token(2621461), "off", tokenOff, "false", null, "on", tokenOn, "true", null, "user", new Token(262165), "clipboard", new Token(262146), "atomx", new Token(69730336), "atomy", new Token(69730337), "atomz", new Token(69730338), "fx", new Token(69730339), "fy", new Token(69730340), "fz", new Token(69730341), "fxyz", new Token(73924618), "vx", new Token(69730347), "vy", new Token(69730348), "vz", new Token(69730349), "vxyz", new Token(73924619), "all", tokenAll, "none", new Token(524301), "null", null, "inherit", null, "normal", new Token(262148), "rasmol", new Token(262149), "torsion", new Token(262154), "coord", new Token(524300), "coords", null, "shapely", new Token(262158), "amino", new Token(0x180000), "hetero", new Token(0x190001), "hydrogen", new Token(1638402), "hydrogens", null, "selected", new Token(1572867), "hidden", new Token(1572884), "displayed", new Token(1572885), "solvent", new Token(1638404), "dotted", new Token(262174), "sidechain", new Token(1572869), "protein", new Token(1572870), "carbohydrate", new Token(1572883), "nucleic", new Token(1572871), "DNA", new Token(0x180008), "RNA", new Token(1572873), "purine", new Token(1572874), "pyrimidine", new Token(1572875), "surface", new Token(1572876), "surfaceDistance", new Token(2621481), "visible", new Token(0x180011), "clickable", new Token(1572882), "mode", new Token(262175), "direction", new Token(262176), "Jmol", new Token(262190), "displacement", new Token(262178), "type", new Token(0x680008), "fixedTemperature", new Token(262166), "rubberband", new Token(262181), "monomer", new Token(262182), "defaultColors", new Token(65548), "opaque", new Token(262184), "translucent", new Token(262185), "delete", new Token(262186), "solid", new Token(262189), "absolute", new Token(262191), "average", new Token(262192), "noDots", new Token(262193), "mesh", new Token(262194), "noMesh", new Token(262195), "fill", new Token(262196), "noFill", new Token(262197), "triangles", new Token(262226), "noTriangles", new Token(262227), "frontOnly", new Token(262228), "notFrontOnly", new Token(262229), "frontlit", new Token(262230), "backlit", new Token(262231), "fullylit", new Token(262232), "vanderWaals", new Token(69730326), "valence", new Token(69730327), "vdw", null, "ionic", new Token(262199), "resume", new Token(262200), "next", new Token(262202), "previous", new Token(262203), "prev", null, "rewind", new Token(262204), "last", new Token(262217), "playRev", new Token(262205), "play", new Token(262201), "range", new Token(262206), "saSurface", new Token(262208), "top", new Token(262213), "bottom", new Token(262214), "left", new Token(262209), "right", new Token(262210), "front", new Token(262211), "back", new Token(262212), "list", new Token(6), "ident", new Token(6815748), "xyz", new Token(73924617), "min", new Token(64), "max", new Token(128), "distance", new Token(23592977), "length", new Token(6815749), "lines", new Token(0x680006), "angle", new Token(17301537), "find", new Token(23592971), "size", new Token(6815751), "array", new Token(0x1080001), "split", new Token(23592968), "join", new Token(23592969), "trim", new Token(23592970), "plane", new Token(17303586), "point", new Token(17301529), "replace", new Token(23592979), "add", new Token(23592972), "sub", new Token(23592973), "mul", new Token(23592974), "div", new Token(23592975), "isaromatic", new Token(524306)};
    private static Hashtable map = new Hashtable();

    Token(int n, int n2, Object object) {
        this.tok = n;
        this.intValue = n2;
        this.value = object;
    }

    public static final Token intToken(int n) {
        return new Token(2, n);
    }

    private Token(int n) {
        this.tok = n;
    }

    private Token(int n, int n2) {
        this.tok = n;
        this.intValue = n2;
    }

    public Token(int n, Object object) {
        this.tok = n;
        this.value = object;
    }

    static final int prec(int n) {
        return n >> 3 & 0xF;
    }

    static Object oValue(Token token) {
        switch (token.tok) {
            case 524305: {
                return Boolean.TRUE;
            }
            case 524304: {
                return Boolean.FALSE;
            }
            case 2: {
                return new Integer(token.intValue);
            }
        }
        return token.value;
    }

    static Object nValue(Token token) {
        int n = 0;
        switch (token.tok) {
            case 2: {
                n = token.intValue;
                break;
            }
            case 3: {
                return token.value;
            }
            case 4: {
                if (((String)token.value).indexOf(".") >= 0) {
                    return new Float(Token.fValue(token));
                }
                n = Token.iValue(token);
            }
        }
        return new Integer(n);
    }

    static boolean bValue(Token token) {
        switch (token.tok) {
            case 524305: {
                return true;
            }
            case 524304: {
                return false;
            }
            case 2: {
                return token.intValue != 0;
            }
            case 3: 
            case 4: 
            case 6: {
                return Token.fValue(token) != 0.0f;
            }
            case 262215: {
                return Token.iValue(token) != 0;
            }
            case 7: 
            case 8: {
                return Math.abs(Token.fValue(token)) > 1.0E-4f;
            }
        }
        return false;
    }

    static int iValue(Token token) {
        switch (token.tok) {
            case 524305: {
                return 1;
            }
            case 524304: {
                return 0;
            }
            case 2: {
                return token.intValue;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return (int)Token.fValue(token);
            }
            case 262215: {
                return BitSetUtil.cardinalityOf((BitSet)Token.bsSelect(token));
            }
        }
        return 0;
    }

    static float fValue(Token token) {
        switch (token.tok) {
            case 524305: {
                return 1.0f;
            }
            case 524304: {
                return 0.0f;
            }
            case 2: {
                return token.intValue;
            }
            case 3: {
                return ((Float)token.value).floatValue();
            }
            case 6: {
                int n = token.intValue;
                String[] stringArray = (String[])token.value;
                if (n == Integer.MAX_VALUE) {
                    return stringArray.length;
                }
            }
            case 4: {
                String string = Token.sValue(token);
                if (string.equalsIgnoreCase("true")) {
                    return 1.0f;
                }
                if (string.equalsIgnoreCase("false") || string.length() == 0) {
                    return 0.0f;
                }
                return Parser.parseFloat((String)string);
            }
            case 262215: {
                return Token.iValue(token);
            }
            case 7: {
                return ((Point3f)token.value).distance(pt0);
            }
            case 8: {
                return Graphics3D.distanceToPlane((Point4f)((Point4f)token.value), (Point3f)pt0);
            }
        }
        return 0.0f;
    }

    static String sValue(Token token) {
        switch (token.tok) {
            case 524305: {
                return "true";
            }
            case 524304: {
                return "false";
            }
            case 2: {
                return "" + token.intValue;
            }
            case 7: {
                return Escape.escape((Tuple3f)((Point3f)token.value));
            }
            case 8: {
                return Escape.escape((Point4f)((Point4f)token.value));
            }
            case 262215: {
                return Escape.escape((BitSet)Token.bsSelect(token), (!(token.value instanceof Bond.BondSet) ? 1 : 0) != 0);
            }
            case 6: {
                String[] stringArray = (String[])token.value;
                int n = token.intValue;
                if (n <= 0) {
                    n = stringArray.length - n;
                }
                if (n != Integer.MAX_VALUE) {
                    return n < 1 || n > stringArray.length ? "" : stringArray[n - 1];
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer.append(stringArray[n]).append("\n");
                }
                return stringBuffer.toString();
            }
            case 4: {
                String string = (String)token.value;
                int n = token.intValue;
                if (n <= 0) {
                    n = string.length() - n;
                }
                if (n == Integer.MAX_VALUE) {
                    return string;
                }
                if (n < 1 || n > string.length()) {
                    return "";
                }
                return "" + string.charAt(n - 1);
            }
        }
        return "" + token.value;
    }

    static int sizeOf(Token token) {
        switch (token.tok) {
            case 524304: 
            case 524305: {
                return -1;
            }
            case 2: {
                return -2;
            }
            case 3: {
                return -4;
            }
            case 7: {
                return -8;
            }
            case 8: {
                return -16;
            }
            case 4: {
                return ((String)token.value).length();
            }
            case 6: {
                return token.intValue == Integer.MAX_VALUE ? ((String[])token.value).length : Token.sizeOf(Token.selectItem(token));
            }
            case 262215: {
                return BitSetUtil.cardinalityOf((BitSet)Token.bsSelect(token));
            }
        }
        return 0;
    }

    static String typeOf(Token token) {
        switch (token.tok) {
            case 524304: 
            case 524305: {
                return "boolean";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "decimal";
            }
            case 7: {
                return "point";
            }
            case 8: {
                return "plane";
            }
            case 4: {
                return "string";
            }
            case 6: {
                return "array";
            }
            case 262215: {
                return "bitset";
            }
        }
        return "?";
    }

    static String[] concatList(Token token, Token token2) {
        int n;
        String[] stringArray = token.tok == 6 ? (String[])token.value : TextFormat.split((String)Token.sValue(token), (String)"\n");
        String[] stringArray2 = token2.tok == 6 ? (String[])token2.value : TextFormat.split((String)Token.sValue(token2), (String)"\n");
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n2++] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n2++] = stringArray2[n];
        }
        return stringArray3;
    }

    static BitSet bsSelect(Token token) {
        token = Token.selectItem(token, Integer.MIN_VALUE);
        return (BitSet)token.value;
    }

    static BitSet bsSelect(Token token, int n) {
        token = Token.selectItem(token);
        token = Token.selectItem(token, 1);
        token = Token.selectItem(token, n);
        return (BitSet)token.value;
    }

    static Token selectItem(Token token) {
        return Token.selectItem(token, Integer.MIN_VALUE);
    }

    static Token selectItem(Token token, int n) {
        if (token.tok != 262215 && token.tok != 6 && token.tok != 4) {
            return token;
        }
        BitSet bitSet = null;
        String[] stringArray = null;
        String string = null;
        int n2 = token.intValue;
        if (n2 == Integer.MAX_VALUE) {
            if (n == Integer.MIN_VALUE) {
                n = token.intValue;
            }
            return new Token(token.tok, n, token.value);
        }
        int n3 = 0;
        int n4 = 0;
        Token token2 = new Token(token.tok, Integer.MAX_VALUE);
        switch (token.tok) {
            case 262215: {
                if (token.value instanceof Bond.BondSet) {
                    token2.value = new Bond.BondSet((BitSet)token.value, ((Bond.BondSet)token.value).getAssociatedAtoms());
                    bitSet = (BitSet)token2.value;
                    n3 = BitSetUtil.cardinalityOf((BitSet)bitSet);
                    break;
                }
                bitSet = BitSetUtil.copy((BitSet)((BitSet)token.value));
                n3 = BitSetUtil.cardinalityOf((BitSet)bitSet);
                token2.value = bitSet;
                break;
            }
            case 6: {
                stringArray = (String[])token.value;
                n3 = stringArray.length;
                break;
            }
            case 4: {
                string = (String)token.value;
                n3 = string.length();
            }
        }
        if (n2 <= 0) {
            n2 = n3 + n2;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n == 0) {
            n = n3;
        } else if (n < 0) {
            n = n3 + n;
        }
        if (n > n3) {
            n = n3;
        } else if (n < n2) {
            n = n2;
        }
        switch (token.tok) {
            case 262215: {
                n3 = BitSetUtil.length((BitSet)bitSet);
                for (int i = 0; i < n3; ++i) {
                    if (!bitSet.get(i) || ++n4 >= n2 && n4 <= n) continue;
                    bitSet.clear(i);
                }
                break;
            }
            case 4: {
                if (n2 < 1 || n2 > n3) {
                    token2.value = "";
                    break;
                }
                token2.value = string.substring(n2 - 1, n);
                break;
            }
            case 6: {
                if (n2 < 1 || n2 > n3 || n > n3) {
                    return new Token(4, "");
                }
                if (n == n2) {
                    return Token.tValue(stringArray[n2 - 1]);
                }
                String[] stringArray2 = new String[n - n2 + 1];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = stringArray[i + n2 - 1];
                }
                token2.value = stringArray2;
            }
        }
        return token2;
    }

    static Token tValue(String string) {
        Object object = Escape.unescapePointOrBitsetAsToken((String)string);
        if (!(object instanceof String)) {
            return (Token)object;
        }
        String string2 = (String)object;
        if (string2.toLowerCase() == "true") {
            return tokenOn;
        }
        if (string2.toLowerCase() == "false") {
            return tokenOff;
        }
        float f = Parser.parseFloat((String)string2);
        if (!Float.isNaN(f)) {
            return f == (float)((int)f) && string2.indexOf(".") < 0 ? Token.intToken((int)f) : new Token(3, new Float(f));
        }
        return new Token(4, object);
    }

    public static void addToken(String string, Token token) {
        map.put(string, token);
    }

    public static Token getTokenFromName(String string) {
        return (Token)map.get(string);
    }

    public static String nameOf(int n) {
        Enumeration enumeration = map.elements();
        while (enumeration.hasMoreElements()) {
            Token token = (Token)enumeration.nextElement();
            if (token.tok != n) continue;
            return "" + token.value;
        }
        return "0x" + Integer.toHexString(n);
    }

    public String toString() {
        return "Token[" + astrType[this.tok <= 9 ? this.tok : 9] + "(0x" + Integer.toHexString(this.tok) + ")" + (this.intValue == Integer.MAX_VALUE ? "" : " intValue=" + this.intValue + "(0x" + Integer.toHexString(this.intValue) + ")") + (this.value == null ? "" : (this.value instanceof String ? " value=\"" + this.value + "\"" : " value=" + this.value)) + "]";
    }

    public static String getCommandSet(String string) {
        String string2;
        String string3 = "";
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        int n = 0;
        String string4 = string == null || string.length() == 0 ? null : string.toLowerCase();
        boolean bl = string4 != null && string4.length() > 1;
        Enumeration enumeration = map.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            Token token = (Token)map.get(string2);
            if ((token.tok & 0x100) == 0 || string4 != null && string2.indexOf(string4) != 0 || !bl && !((String)token.value).equals(string2)) continue;
            hashtable.put(string2, Boolean.TRUE);
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (string2.charAt(string2.length() - 1) == 's' && hashtable.containsKey(string2.substring(0, string2.length() - 1))) continue;
            string3 = string3 + (n++ == 0 ? "" : ";") + string2;
        }
        return string3;
    }

    static {
        Token token = null;
        int n = 0;
        while (n + 1 < arrayPairs.length) {
            String string = (String)arrayPairs[n];
            String string2 = string.toLowerCase();
            Token token2 = (Token)arrayPairs[n + 1];
            if (token2 == null) {
                token2 = token;
            }
            if (token2.value == null) {
                token2.value = string;
            }
            if (map.get(string2) != null) {
                Logger.error((String)("duplicate token definition:" + string2));
            }
            map.put(string2, token2);
            token = token2;
            n += 2;
        }
    }
}

