/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

abstract class TransformManager {
    Viewer viewer;
    static final float twoPI = (float)Math.PI * 2;
    static final float radiansPerDegree = (float)Math.PI / 180;
    static final float degreesPerRadian = 57.29578f;
    protected int perspectiveModel = 11;
    protected float cameraScaleFactor;
    protected float referencePlaneOffset;
    protected float modelCenterOffset;
    protected float modelRadius;
    protected float modelRadiusPixels;
    protected final Point3f navigationCenter = new Point3f();
    protected final Point3f navigationOffset = new Point3f();
    protected final Point3f navigationShiftXY = new Point3f();
    protected final Matrix4f matrixTemp = new Matrix4f();
    protected final Vector3f vectorTemp = new Vector3f();
    boolean checkedForNavigation = false;
    protected boolean haveNotifiedNaN = false;
    float spinX;
    float spinY = 30.0f;
    float spinZ;
    float spinFps = 30.0f;
    boolean isSpinInternal = false;
    boolean isSpinFixed = false;
    boolean isSpinSelected = false;
    protected final Point3f fixedRotationOffset = new Point3f();
    protected final Point3f fixedRotationCenter = new Point3f(0.0f, 0.0f, 0.0f);
    private final Point3f rotationCenterDefault = new Point3f();
    private float rotationRadiusDefault;
    protected final AxisAngle4f fixedRotationAxis = new AxisAngle4f();
    protected final AxisAngle4f internalRotationAxis = new AxisAngle4f();
    private final Point3f internalRotationCenter = new Point3f(0.0f, 0.0f, 0.0f);
    private float internalRotationAngle = 0.0f;
    protected final Matrix3f matrixRotate = new Matrix3f();
    private final Matrix3f matrixTemp3 = new Matrix3f();
    private final Matrix4f matrixTemp4 = new Matrix4f();
    private final AxisAngle4f axisangleT = new AxisAngle4f();
    private final Vector3f vectorT = new Vector3f();
    private final Vector3f vectorT2 = new Vector3f();
    protected final Point3f pointT = new Point3f();
    private final Point3f pointT2 = new Point3f();
    static final int MAXIMUM_ZOOM_PERCENTAGE = 200000;
    static final int MAXIMUM_ZOOM_PERSPECTIVE_DEPTH = 10000;
    private boolean rotateSelected;
    private boolean rotateMolecule;
    Vector3f rotationAxis = new Vector3f();
    float rotationRate = 0.0f;
    protected final Point3f fixedTranslation = new Point3f();
    float xTranslationFraction = 0.5f;
    float yTranslationFraction = 0.5f;
    boolean zoomEnabled = true;
    float zoomPercent = 100.0f;
    float zoomPercentSetting = 100.0f;
    float zoomRatio;
    boolean slabEnabled = false;
    int slabPercentSetting;
    int depthPercentSetting;
    int slabValue;
    int depthValue;
    Point4f slabPlane = null;
    Point4f depthPlane = null;
    Point3f slabRef = new Point3f(0.0f, 0.0f, 0.0f);
    float slabRefDistance;
    protected boolean perspectiveDepth = true;
    protected boolean scale3D = false;
    protected float cameraDepth = Float.NaN;
    protected float cameraDepthSetting = 3.0f;
    protected float visualRange;
    protected float cameraDistance = 1000.0f;
    int width;
    int height;
    int screenPixelCount;
    float scalePixelsPerAngstrom;
    float scaleDefaultPixelsPerAngstrom;
    float scale3DAngstromsPerInch;
    private boolean antialias;
    private boolean useZoomLarge;
    int screenWidth;
    int screenHeight;
    protected final Matrix4f matrixTransform = new Matrix4f();
    protected final Point3f point3fScreenTemp = new Point3f();
    protected final Point3i point3iScreenTemp = new Point3i();
    private final Point3f point3fVibrationTemp = new Point3f();
    boolean axesOrientationRasmol = false;
    protected boolean navigating = false;
    protected boolean isNavigationMode = false;
    protected final Point3f ptTest1 = new Point3f();
    protected final Point3f ptTest2 = new Point3f();
    protected final Point3f ptTest3 = new Point3f();
    protected final AxisAngle4f aaTest1 = new AxisAngle4f();
    protected final AxisAngle4f aaMoveTo = new AxisAngle4f();
    protected final AxisAngle4f aaStep = new AxisAngle4f();
    protected final AxisAngle4f aaTotal = new AxisAngle4f();
    protected final Matrix3f matrixStart = new Matrix3f();
    protected final Matrix3f matrixInverse = new Matrix3f();
    protected final Matrix3f matrixStep = new Matrix3f();
    protected final Matrix3f matrixTest = new Matrix3f();
    protected final Matrix3f matrixEnd = new Matrix3f();
    protected final Vector3f aaStepCenter = new Vector3f();
    protected final Vector3f aaStepNavCenter = new Vector3f();
    protected Point3f ptMoveToCenter;
    protected boolean spinOn;
    private SpinThread spinThread;
    boolean vibrationOn;
    private float vibrationPeriod;
    public int vibrationPeriodMs;
    private float vibrationAmplitude;
    private float vibrationRadians;
    private float vibrationScale;
    private VibrationThread vibrationThread;
    int stereoMode;
    int[] stereoColors;
    float stereoDegrees;
    float stereoRadians = 0.08726646f;
    boolean stereoFrame;
    protected final Matrix3f matrixStereo = new Matrix3f();
    boolean windowCentered;

    protected abstract void calcCameraFactors();

    protected abstract float getPerspectiveFactor(float var1);

    abstract void adjustTemporaryScreenPoint();

    TransformManager() {
    }

    TransformManager(Viewer viewer) {
        this.viewer = viewer;
    }

    TransformManager(Viewer viewer, int n, int n2) {
        this.setViewer(viewer, n, n2);
    }

    private void setViewer(Viewer viewer, int n, int n2) {
        this.viewer = viewer;
        this.setScreenParameters(n, n2, true, false, true, true);
    }

    TransformManager getNavigationManager(Viewer viewer, int n, int n2) {
        String string = "org.jmol.viewer.TransformManager11";
        try {
            Class<?> clazz = Class.forName(string);
            TransformManager transformManager = (TransformManager)clazz.newInstance();
            transformManager.setViewer(viewer, n, n2);
            return transformManager;
        }
        catch (Exception exception) {
            if (!this.checkedForNavigation) {
                Logger.error((String)("Could not instantiate TransformationManager11 navigation manager. Class file is missing " + exception.toString()));
            }
            this.checkedForNavigation = true;
            return this;
        }
    }

    void homePosition() {
        this.setDefaultRotation();
        this.setRotationCenterAndRadiusXYZ(null, true);
        this.matrixRotate.setIdentity();
        this.setZoomEnabled(true);
        this.zoomToPercent(100.0f);
        this.zoomPercent = this.zoomPercentSetting;
        this.slabReset();
        this.scaleFitToScreen(true);
        if (this.viewer.isJmolDataFrame()) {
            this.fixedRotationCenter.set(0.0f, 0.0f, 0.0f);
            this.rotationRadiusDefault = this.viewer.getJmolFrameType(this.viewer.getCurrentModelIndex()).equals("ramachandran") ? 250 : 12;
        }
        if (this.isNavigationMode) {
            this.setNavigationMode(true);
        }
    }

    void clear() {
        this.clearVibration();
        this.clearSpin();
        this.fixedRotationCenter.set(0.0f, 0.0f, 0.0f);
        this.navigating = false;
        this.slabPlane = null;
        this.depthPlane = null;
        this.resetNavigationPoint(true);
    }

    String getState(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (stringBuffer != null) {
            stringBuffer.append("  _setPerspectiveState;\n");
            stringBuffer2.append("function _setPerspectiveState();\n");
        }
        StateManager.appendCmd(stringBuffer2, "set perspectiveModel " + this.perspectiveModel);
        StateManager.appendCmd(stringBuffer2, "set scaleAngstromsPerInch " + this.scale3DAngstromsPerInch);
        StateManager.appendCmd(stringBuffer2, "set perspectiveDepth " + this.perspectiveDepth);
        StateManager.appendCmd(stringBuffer2, "set visualRange " + this.visualRange);
        if (!this.isWindowCentered()) {
            StateManager.appendCmd(stringBuffer2, "set windowCentered false");
        }
        StateManager.appendCmd(stringBuffer2, "set cameraDepth " + this.cameraDepth);
        if (this.isNavigationMode) {
            StateManager.appendCmd(stringBuffer2, "set navigationMode true");
        }
        StateManager.appendCmd(stringBuffer2, this.viewer.getBoundBoxCommand(false));
        StateManager.appendCmd(stringBuffer2, "center " + Escape.escape((Tuple3f)this.fixedRotationCenter));
        StateManager.appendCmd(stringBuffer2, this.getMoveToText(0.0f, false));
        if (!this.isNavigationMode && !this.zoomEnabled) {
            StateManager.appendCmd(stringBuffer2, "zoom off");
        }
        stringBuffer2.append("  slab ").append(this.slabPercentSetting).append(";depth ").append(this.depthPercentSetting).append(this.slabEnabled && !this.isNavigationMode ? ";slab on" : "").append(";\n");
        if (this.slabPlane != null) {
            stringBuffer2.append("  slab plane {").append(this.slabPlane.x).append(" ").append(this.slabPlane.y).append(" ").append(this.slabPlane.z).append(" ").append(this.slabPlane.w).append(" };\n");
        }
        if (this.depthPlane != null) {
            stringBuffer2.append("  depth plane {").append(this.depthPlane.x).append(" ").append(this.depthPlane.y).append(" ").append(this.depthPlane.z).append(" ").append(this.depthPlane.w).append(" };\n");
        }
        if (this.depthPlane != null || this.slabPlane != null) {
            stringBuffer2.append("  slab reference ").append(Escape.escape((Tuple3f)this.slabRef)).append(this.slabEnabled || this.isNavigationMode ? ";slab on" : "").append(";\n");
        }
        stringBuffer2.append(this.getSpinState(true)).append("\n");
        if (this.viewer.modelSetHasVibrationVectors()) {
            StateManager.appendCmd(stringBuffer2, "vibration scale " + this.viewer.getVibrationScale());
            if (this.vibrationOn) {
                StateManager.appendCmd(stringBuffer2, "vibration " + this.vibrationPeriod);
            } else {
                StateManager.appendCmd(stringBuffer2, "vibration period " + this.vibrationPeriod);
            }
        }
        if (this.isNavigationMode) {
            stringBuffer2.append(this.getNavigationState());
        }
        if (stringBuffer != null) {
            stringBuffer2.append("end function;\n\n");
        }
        return stringBuffer2.toString();
    }

    String getSpinState(boolean bl) {
        String string = "  spinX = " + (int)this.spinX + ";spinY = " + (int)this.spinY + ";spinZ = " + (int)this.spinZ + ";spinFps = " + (int)this.spinFps + ";";
        if (this.spinOn) {
            if (bl) {
                string = string + "\n  refreshing = true;refresh;";
            }
            if (this.isSpinSelected) {
                string = string + "\n  select " + Escape.escape((BitSet)this.viewer.getSelectionSet()) + ";\nrotateSelected ";
            }
            if (this.isSpinInternal) {
                Point3f point3f = new Point3f(this.internalRotationCenter);
                point3f.sub((Tuple3f)this.rotationAxis);
                string = string + "\n  spin " + this.rotationRate + " " + Escape.escape((Tuple3f)this.internalRotationCenter) + " " + Escape.escape((Tuple3f)point3f);
            } else {
                string = this.isSpinFixed ? string + "\n  spin axisangle " + Escape.escape((Tuple3f)this.rotationAxis) + " " + this.rotationRate : string + "\n  spin on";
            }
            string = string + ";";
        }
        return string;
    }

    void setRotateSelected(boolean bl) {
        this.rotateSelected = bl;
    }

    void setRotateMolecule(boolean bl) {
        this.rotateMolecule = bl;
    }

    private void setFixedRotationCenter(Point3f point3f) {
        if (point3f == null) {
            return;
        }
        this.fixedRotationCenter.set((Tuple3f)point3f);
    }

    void setRotationPointXY(Point3f point3f) {
        Point3i point3i = this.transformPoint(point3f);
        this.fixedTranslation.set((float)point3i.x, (float)point3i.y, 0.0f);
    }

    float setRotateInternal(Point3f point3f, Vector3f vector3f, float f) {
        this.internalRotationCenter.set((Tuple3f)point3f);
        this.rotationAxis.set((Tuple3f)vector3f);
        float f2 = f * ((float)Math.PI / 180);
        this.rotationRate = f;
        this.internalRotationAxis.set(vector3f, f2);
        return f2;
    }

    float setRotateFixed(Point3f point3f, Vector3f vector3f, float f) {
        this.setFixedRotationCenter(point3f);
        this.rotationAxis.set((Tuple3f)vector3f);
        float f2 = f * ((float)Math.PI / 180);
        this.rotationRate = f;
        this.fixedRotationAxis.set(vector3f, f2);
        return f2;
    }

    void rotateXYBy(int n, int n2) {
        this.rotateXRadians((float)n2 * ((float)Math.PI / 180));
        this.rotateYRadians((float)n * ((float)Math.PI / 180));
    }

    void rotateZBy(int n) {
        this.rotateZRadians((float)Math.PI * (float)n / 180.0f);
    }

    void rotateFront() {
        this.matrixRotate.setIdentity();
    }

    void rotateToX(float f) {
        this.matrixRotate.rotX(f);
    }

    void rotateToY(float f) {
        this.matrixRotate.rotY(f);
    }

    void rotateToZ(float f) {
        this.matrixRotate.rotZ(f);
    }

    void applyRotation(Matrix3f matrix3f, boolean bl) {
        if (this.rotateSelected) {
            this.viewer.rotateSelected(matrix3f, this.matrixRotate, this.rotateMolecule, bl);
        } else {
            this.matrixRotate.mul(matrix3f, this.matrixRotate);
        }
    }

    synchronized void rotateXRadians(float f) {
        this.matrixTemp3.rotX(f);
        this.applyRotation(this.matrixTemp3, false);
    }

    synchronized void rotateYRadians(float f) {
        if (this.axesOrientationRasmol) {
            f = -f;
        }
        this.matrixTemp3.rotY(f);
        this.applyRotation(this.matrixTemp3, false);
    }

    synchronized void rotateZRadians(float f) {
        if (this.axesOrientationRasmol) {
            f = -f;
        }
        this.matrixTemp3.rotZ(f);
        this.applyRotation(this.matrixTemp3, false);
    }

    protected void rotateAxisAngle(Vector3f vector3f, float f) {
        this.axisangleT.set(vector3f, f);
        this.rotateAxisAngle(this.axisangleT);
    }

    synchronized void rotateAxisAngle(AxisAngle4f axisAngle4f) {
        this.matrixTemp3.setIdentity();
        this.matrixTemp3.set(axisAngle4f);
        this.applyRotation(this.matrixTemp3, false);
    }

    void rotateAxisAngleAtCenter(Point3f point3f, Vector3f vector3f, float f, float f2, boolean bl, boolean bl2) {
        if (point3f != null) {
            this.moveRotationCenter(point3f, true);
        }
        this.setSpinOn(false);
        if (f == 0.0f) {
            return;
        }
        if (point3f != null) {
            this.setRotationPointXY(point3f);
        }
        float f3 = this.setRotateFixed(point3f, vector3f, f);
        if (bl) {
            this.isSpinInternal = false;
            this.isSpinFixed = true;
            this.isSpinSelected = bl2;
            this.setSpinOn(true, f2, bl2);
            return;
        }
        if (bl2) {
            this.setRotateSelected(true);
        }
        this.rotateAxisAngleRadiansFixed(f3);
        if (bl2) {
            this.setRotateSelected(false);
        }
    }

    synchronized void rotateAxisAngleRadiansFixed(float f) {
        this.axisangleT.set(this.fixedRotationAxis);
        this.axisangleT.angle = f;
        this.rotateAxisAngle(this.axisangleT);
    }

    void rotateAboutPointsInternal(Point3f point3f, Point3f point3f2, float f, float f2, boolean bl, boolean bl2, boolean bl3) {
        this.setSpinOn(false);
        if (f == 0.0f) {
            return;
        }
        Vector3f vector3f = new Vector3f((Tuple3f)point3f);
        vector3f.sub((Tuple3f)point3f2);
        if (bl) {
            vector3f.scale(-1.0f);
        }
        float f3 = this.setRotateInternal(point3f, vector3f, f);
        if (bl2) {
            this.isSpinInternal = true;
            this.isSpinFixed = false;
            this.isSpinSelected = bl3;
            this.setSpinOn(true, f2, bl3);
            return;
        }
        if (bl3) {
            this.setRotateSelected(true);
        }
        this.rotateAxisAngleRadiansInternal(f3);
        if (bl3) {
            this.setRotateSelected(false);
        }
    }

    synchronized void rotateAxisAngleRadiansInternal(float f) {
        this.internalRotationAngle = f;
        this.vectorT.set(this.internalRotationAxis.x, this.internalRotationAxis.y, this.internalRotationAxis.z);
        this.matrixRotate.transform((Tuple3f)this.vectorT, (Tuple3f)this.vectorT2);
        this.axisangleT.set(this.vectorT2, f);
        this.matrixTemp3.set(this.axisangleT);
        this.applyRotation(this.matrixTemp3, true);
        if (!this.rotateSelected) {
            this.getNewFixedRotationCenter();
        }
    }

    void getNewFixedRotationCenter() {
        this.axisangleT.set(this.internalRotationAxis);
        this.axisangleT.angle = -this.internalRotationAngle;
        this.matrixTemp4.set(this.axisangleT);
        this.vectorT.set((Tuple3f)this.internalRotationCenter);
        this.pointT2.set((Tuple3f)this.fixedRotationCenter);
        this.pointT2.sub((Tuple3f)this.vectorT);
        this.matrixTemp4.transform(this.pointT2, this.pointT);
        this.pointT.add((Tuple3f)this.vectorT);
        this.setRotationCenterAndRadiusXYZ(this.pointT, false);
    }

    void setTranslationFractions() {
        this.xTranslationFraction = this.fixedTranslation.x / (float)this.width;
        this.yTranslationFraction = this.fixedTranslation.y / (float)this.height;
    }

    void translateXYBy(int n, int n2) {
        this.fixedTranslation.x += (float)n;
        this.fixedTranslation.y += (float)n2;
        this.setTranslationFractions();
    }

    void translateToXPercent(float f) {
        this.xTranslationFraction = 0.5f + f / 100.0f;
        this.fixedTranslation.x = (float)this.width * this.xTranslationFraction;
    }

    void translateToYPercent(float f) {
        this.yTranslationFraction = 0.5f + f / 100.0f;
        this.fixedTranslation.y = (float)this.height * this.yTranslationFraction;
    }

    void translateToZPercent(float f) {
        if (!this.isNavigationMode) {
            return;
        }
        this.setNavigationDepthPercent(0.0f, f);
    }

    float getTranslationXPercent() {
        return (this.fixedTranslation.x - (float)(this.width / 2)) * 100.0f / (float)this.width;
    }

    float getTranslationYPercent() {
        return (this.fixedTranslation.y - (float)(this.height / 2)) * 100.0f / (float)this.height;
    }

    float getTranslationZPercent() {
        return 0.0f;
    }

    String getTranslationScript() {
        String string = "";
        float f = this.getTranslationXPercent();
        if ((double)f != 0.0) {
            string = string + "translate x " + f + ";";
        }
        if ((double)(f = this.getTranslationYPercent()) != 0.0) {
            string = string + "translate y " + f + ";";
        }
        return string;
    }

    String getOrientationText() {
        return this.getMoveToText(1.0f, true) + "\nOR\n" + this.getRotateZyzText(true);
    }

    Hashtable getOrientationInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("moveTo", this.getMoveToText(1.0f, false));
        hashtable.put("center", "center " + this.getCenterText());
        hashtable.put("rotateZYZ", this.getRotateZyzText(false));
        hashtable.put("rotateXYZ", this.getRotateXyzText());
        hashtable.put("transXPercent", new Float(this.getTranslationXPercent()));
        hashtable.put("transYPercent", new Float(this.getTranslationYPercent()));
        hashtable.put("zoom", new Float(this.zoomPercent));
        hashtable.put("modelRadius", new Float(this.modelRadius));
        if (this.isNavigationMode) {
            hashtable.put("navigationCenter", "navigate center " + Escape.escape((Tuple3f)this.navigationCenter));
            hashtable.put("navigationOffsetXPercent", new Float(this.getNavigationOffsetPercent('X')));
            hashtable.put("navigationOffsetYPercent", new Float(this.getNavigationOffsetPercent('Y')));
            hashtable.put("navigationDepthPercent", new Float(this.getNavigationDepthPercent()));
        }
        return hashtable;
    }

    void getAxisAngle(AxisAngle4f axisAngle4f) {
        axisAngle4f.set(this.matrixRotate);
    }

    String getTransformText() {
        return this.matrixRotate.toString();
    }

    Matrix3f getMatrixRotate() {
        return this.matrixRotate;
    }

    void setRotation(Matrix3f matrix3f) {
        this.matrixRotate.set(matrix3f);
    }

    void getRotation(Matrix3f matrix3f) {
        matrix3f.set(this.matrixRotate);
    }

    protected void zoomBy(int n) {
        if (n > 20) {
            n = 20;
        } else if (n < -20) {
            n = -20;
        }
        float f = (float)n * this.zoomPercentSetting / 50.0f;
        if (f == 0.0f) {
            f = n > 0 ? 1 : (f < 0.0f ? -1 : 0);
        }
        this.zoomRatio = (f + this.zoomPercentSetting) / this.zoomPercentSetting;
        this.zoomPercentSetting += f;
    }

    float getZoomPercentFloat() {
        return this.zoomPercent;
    }

    void zoomToPercent(float f) {
        this.zoomPercentSetting = f;
        this.zoomRatio = 0.0f;
    }

    void zoomByPercent(float f) {
        float f2 = f * this.zoomPercentSetting / 100.0f;
        if (f2 == 0.0f) {
            f2 = f < 0.0f ? -1.0f : 1.0f;
        }
        this.zoomRatio = (f2 + this.zoomPercentSetting) / this.zoomPercentSetting;
        this.zoomPercentSetting += f2;
    }

    void setZoomEnabled(boolean bl) {
        if (this.zoomEnabled != bl) {
            this.zoomEnabled = bl;
        }
    }

    void setScaleAngstromsPerInch(float f) {
        boolean bl = this.scale3D = f > 0.0f;
        if (this.scale3D) {
            this.scale3DAngstromsPerInch = f;
        }
        this.perspectiveDepth = !this.scale3D;
    }

    void setSlabEnabled(boolean bl) {
        this.slabEnabled = bl;
    }

    void slabReset() {
        this.slabToPercent(100);
        this.depthToPercent(0);
        this.slabInternal(null, false);
        this.slabInternal(null, true);
        this.setSlabEnabled(false);
    }

    int getSlabPercentSetting() {
        return this.slabPercentSetting;
    }

    void slabByPercentagePoints(int n) {
        this.slabPlane = null;
        this.slabPercentSetting += n;
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    void depthByPercentagePoints(int n) {
        this.depthPlane = null;
        this.depthPercentSetting += n;
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
    }

    void slabDepthByPercentagePoints(int n) {
        this.slabPlane = null;
        this.depthPlane = null;
        this.slabPercentSetting += n;
        this.depthPercentSetting += n;
    }

    void slabToPercent(int n) {
        this.slabPercentSetting = n;
        this.slabPlane = null;
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    void depthToPercent(int n) {
        this.depthPercentSetting = n;
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
    }

    Point4f getDepthPlane(boolean bl) {
        if (bl) {
            return this.depthPlane;
        }
        if (!this.slabEnabled) {
            return null;
        }
        this.pointT.set(0.0f, 0.0f, 0.0f);
        this.transformPoint(this.pointT, this.pointT2);
        this.pointT2.z = this.depthValue;
        this.unTransformPoint(this.pointT2, this.pointT);
        return new Point4f(this.pointT.x, this.pointT.y, this.pointT.z, -(this.pointT.x * this.pointT.x + this.pointT.y * this.pointT.y + this.pointT.z * this.pointT.z));
    }

    Point4f getSlabPlane(boolean bl) {
        if (bl) {
            return this.slabPlane;
        }
        if (!this.slabEnabled) {
            return null;
        }
        this.pointT.set(0.0f, 0.0f, 0.0f);
        this.transformPoint(this.pointT, this.pointT2);
        this.pointT2.z = this.slabValue;
        this.unTransformPoint(this.pointT2, this.pointT);
        return new Point4f(this.pointT.x, this.pointT.y, this.pointT.z, -(this.pointT.x * this.pointT.x + this.pointT.y * this.pointT.y + this.pointT.z * this.pointT.z));
    }

    void slabInternal(Point4f point4f, boolean bl) {
        if (bl) {
            this.depthPlane = point4f;
        } else {
            this.slabPlane = point4f;
        }
        this.slabRef = new Point3f(0.0f, 0.0f, 0.0f);
        this.slabRefDistance = Float.NaN;
    }

    void setSlabDepthInternal(boolean bl) {
        Point4f point4f = this.getSlabPlane(false);
        int n = this.slabPercentSetting;
        int n2 = this.depthPercentSetting;
        if (bl) {
            point4f = this.getDepthPlane(false);
            Point4f point4f2 = this.getSlabPlane(true);
            this.slabReset();
            this.slabToPercent(n);
            this.slabInternal(point4f, true);
            this.slabInternal(point4f2, false);
        } else {
            point4f = this.getSlabPlane(false);
            Point4f point4f3 = this.getDepthPlane(true);
            this.slabReset();
            this.depthToPercent(n2);
            this.slabInternal(point4f, false);
            this.slabInternal(point4f3, true);
        }
        this.slabInternalReference(null);
    }

    void slabInternalReference(Point3f point3f) {
        this.slabRef = point3f;
        if (point3f == null) {
            this.slabRef = new Point3f(this.fixedRotationCenter);
            Point3f point3f2 = TransformManager.pointOnPlane(this.slabPlane);
            Point3f point3f3 = TransformManager.pointOnPlane(this.depthPlane);
            float f = Graphics3D.distanceToPlane((Point4f)this.slabPlane, (Point3f)this.slabRef);
            float f2 = Graphics3D.distanceToPlane((Point4f)this.depthPlane, (Point3f)this.slabRef);
            if (this.slabPlane != null && this.depthPlane != null && (f <= 0.0f || f2 >= 0.0f)) {
                point3f3.sub((Tuple3f)point3f2);
                point3f3.scale(2.0f);
                point3f3.add((Tuple3f)point3f2);
                this.slabRef.set((Tuple3f)point3f3);
            } else if (this.slabPlane != null && f <= 0.0f) {
                point3f2.sub((Tuple3f)this.slabRef);
                this.slabRef.set(-this.slabRef.x + 2.0f * point3f2.x, -this.slabRef.y + 2.0f * point3f2.y, -this.slabRef.z + 2.0f * point3f2.z);
            } else if (this.depthPlane != null && f2 >= 0.0f) {
                point3f3.sub((Tuple3f)this.slabRef);
                this.slabRef.set(-this.slabRef.x + 2.0f * point3f3.x, -this.slabRef.y + 2.0f * point3f3.y, -this.slabRef.z + 2.0f * point3f3.z);
            }
        }
        this.slabRefDistance = Float.NaN;
    }

    boolean checkInternalSlab(Point3f point3f) {
        return this.slabPlane != null && this.isSlabbedInternal(point3f, false) || this.depthPlane != null && !this.isSlabbedInternal(point3f, true);
    }

    boolean isSlabbedInternal(Point3f point3f, boolean bl) {
        Point4f point4f;
        if (Float.isNaN(this.slabRefDistance) && (this.slabRefDistance = Graphics3D.distanceToPlane((Point4f)(point4f = this.slabPlane == null ? this.depthPlane : this.slabPlane), (Point3f)this.slabRef)) == 0.0f) {
            this.slabRef.x = (float)((double)this.slabRef.x - 0.12334);
            this.slabRefDistance = Graphics3D.distanceToPlane((Point4f)point4f, (Point3f)this.slabRef);
            if (this.slabRefDistance == 0.0f) {
                this.slabRef.y = (float)((double)this.slabRef.y - 0.12334);
            }
            if ((this.slabRefDistance = Graphics3D.distanceToPlane((Point4f)point4f, (Point3f)this.slabRef)) == 0.0f) {
                this.slabRef.z = (float)((double)this.slabRef.z - 0.12334);
                this.slabRefDistance = Graphics3D.distanceToPlane((Point4f)point4f, (Point3f)this.slabRef);
            }
        }
        float f = Graphics3D.distanceToPlane((Point4f)(bl ? this.depthPlane : this.slabPlane), (Point3f)point3f);
        return this.slabRefDistance < 0.0f && f > 0.0f || this.slabRefDistance > 0.0f && f < 0.0f;
    }

    static Point3f pointOnPlane(Point4f point4f) {
        if (point4f == null) {
            return null;
        }
        Point3f point3f = new Point3f();
        if (point4f.w == 0.0f) {
            return point3f;
        }
        if (point4f.x != 0.0f) {
            point3f.x = 1.0f / point4f.x;
        } else if (point4f.y != 0.0f) {
            point3f.y = 1.0f / point4f.y;
        } else {
            point3f.z = 1.0f / point4f.z;
        }
        return point3f;
    }

    void setPerspectiveDepth(boolean bl) {
        if (this.perspectiveDepth == bl) {
            return;
        }
        this.perspectiveDepth = bl;
        this.scaleFitToScreen(false);
    }

    boolean getPerspectiveDepth() {
        return this.perspectiveDepth;
    }

    void setCameraDepthPercent(float f) {
        float f2;
        this.resetNavigationPoint(true);
        float f3 = f2 = f < 0.0f ? -f / 100.0f : f;
        if (f2 == 0.0f) {
            return;
        }
        this.cameraDepthSetting = f2;
        this.cameraDepth = Float.NaN;
    }

    void setVisualRange(float f) {
        this.visualRange = f;
    }

    Matrix4f getUnscaledTransformMatrix() {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        this.vectorTemp.set((Tuple3f)this.fixedRotationCenter);
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        matrix4f.sub(this.matrixTemp);
        this.matrixTemp.set(this.matrixRotate);
        matrix4f.mul(this.matrixTemp, matrix4f);
        return matrix4f;
    }

    void setScreenParameters(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.screenWidth = n;
        this.screenHeight = n2;
        this.useZoomLarge = bl;
        this.antialias = bl2;
        this.width = bl2 ? n * 2 : n;
        this.height = bl2 ? n2 * 2 : n2;
        this.scaleFitToScreen(false, bl, bl3, bl4);
    }

    void setAntialias(boolean bl) {
        boolean bl2 = this.antialias != bl;
        this.antialias = bl;
        this.width = this.antialias ? this.screenWidth * 2 : this.screenWidth;
        int n = this.height = this.antialias ? this.screenHeight * 2 : this.screenHeight;
        if (bl2) {
            this.scaleFitToScreen(false, this.useZoomLarge, false, false);
        }
    }

    private float defaultScaleToScreen(float f) {
        return (float)this.screenPixelCount / 2.0f / f;
    }

    void scaleFitToScreen(boolean bl) {
        this.scaleFitToScreen(bl, this.viewer.getZoomLarge(), true, true);
    }

    void scaleFitToScreen(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (this.width == 0 || this.height == 0) {
            return;
        }
        this.fixedTranslation.set((float)this.width * (bl ? 0.5f : this.xTranslationFraction), (float)this.height * (bl ? 0.5f : this.yTranslationFraction), 0.0f);
        this.setTranslationFractions();
        if (bl4) {
            this.resetNavigationPoint(bl3);
        }
        int n = this.screenPixelCount = bl2 == this.height > this.width ? this.height : this.width;
        if (this.screenPixelCount > 2) {
            this.screenPixelCount -= 2;
        }
        this.scaleDefaultPixelsPerAngstrom = this.defaultScaleToScreen(this.modelRadius);
        System.out.println("scaleDEfPPA = " + this.scaleDefaultPixelsPerAngstrom);
    }

    short scaleToScreen(int n, int n2) {
        if (n2 == 0 || n < 2) {
            return 0;
        }
        int n3 = (int)this.scaleToPerspective(n, (float)n2 * this.scalePixelsPerAngstrom / 1000.0f);
        return (short)(n3 > 0 ? n3 : 1);
    }

    float scaleToPerspective(int n, float f) {
        return this.perspectiveDepth ? f * this.getPerspectiveFactor(n) : f;
    }

    void setAxesOrientationRasmol(boolean bl) {
        this.axesOrientationRasmol = bl;
    }

    void setNavigationMode(boolean bl) {
        this.isNavigationMode = bl && this.canNavigate();
        this.resetNavigationPoint(true);
    }

    boolean getNavigating() {
        return this.navigating;
    }

    synchronized void finalizeTransformParameters() {
        this.haveNotifiedNaN = false;
        this.fixedRotationOffset.set((Tuple3f)this.fixedTranslation);
        this.calcZoom();
        this.calcCameraFactors();
        this.calcTransformMatrix();
        if (this.isNavigationMode) {
            this.calcNavigationPoint();
        } else {
            this.calcSlabAndDepthValues();
        }
    }

    protected void calcZoom() {
        if (this.zoomPercentSetting < 5.0f) {
            this.zoomPercentSetting = 5.0f;
        }
        if (this.zoomPercentSetting > 200000.0f) {
            this.zoomPercentSetting = 200000.0f;
        }
        this.zoomPercent = this.zoomEnabled || this.isNavigationMode ? this.zoomPercentSetting : 100.0f;
    }

    protected void calcSlabAndDepthValues() {
        this.slabValue = 0;
        this.depthValue = Integer.MAX_VALUE;
        if (!this.slabEnabled) {
            return;
        }
        this.slabValue = (int)((1.0f - (float)this.slabPercentSetting / 50.0f) * this.modelRadiusPixels + this.modelCenterOffset);
        this.depthValue = (int)((1.0f - (float)this.depthPercentSetting / 50.0f) * this.modelRadiusPixels + this.modelCenterOffset);
    }

    protected synchronized void calcTransformMatrix() {
        this.matrixTransform.setIdentity();
        this.vectorTemp.set((Tuple3f)this.fixedRotationCenter);
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        this.matrixTransform.sub(this.matrixTemp);
        this.matrixTemp.set(this.stereoFrame ? this.matrixStereo : this.matrixRotate);
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
        this.matrixTemp.setZero();
        this.matrixTemp.set(this.scalePixelsPerAngstrom);
        if (!this.axesOrientationRasmol) {
            this.matrixTemp.m11 = this.matrixTemp.m22 = -this.scalePixelsPerAngstrom;
        }
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
        this.matrixTransform.m23 += this.modelCenterOffset;
    }

    void transformPoints(int n, Point3f[] point3fArray, Point3i[] point3iArray) {
        int n2 = n;
        while (--n2 >= 0) {
            point3iArray[n2].set((Tuple3i)this.transformPoint(point3fArray[n2]));
        }
    }

    void transformPoint(Point3f point3f, Point3i point3i) {
        point3i.set((Tuple3i)this.transformPoint(point3f));
    }

    synchronized Point3i transformPoint(Point3f point3f) {
        this.matrixTransform(point3f, this.point3fScreenTemp);
        this.adjustTemporaryScreenPoint();
        if (this.slabEnabled && this.checkInternalSlab(point3f)) {
            this.point3iScreenTemp.z = 1;
        }
        return this.point3iScreenTemp;
    }

    Point3i transformPoint(Point3f point3f, Vector3f vector3f) {
        this.point3fVibrationTemp.set((Tuple3f)point3f);
        if (this.vibrationOn && vector3f != null) {
            this.point3fVibrationTemp.scaleAdd(this.vibrationAmplitude, (Tuple3f)vector3f, (Tuple3f)point3f);
        }
        this.matrixTransform(this.point3fVibrationTemp, this.point3fScreenTemp);
        this.adjustTemporaryScreenPoint();
        if (this.slabEnabled && this.checkInternalSlab(point3f)) {
            this.point3iScreenTemp.z = 1;
        }
        return this.point3iScreenTemp;
    }

    void transformPoint(Point3f point3f, Point3f point3f2) {
        this.matrixTransform(point3f, this.point3fScreenTemp);
        this.adjustTemporaryScreenPoint();
        if (this.slabEnabled && this.checkInternalSlab(point3f)) {
            this.point3fScreenTemp.z = 1.0f;
        }
        point3f2.set((Tuple3f)this.point3fScreenTemp);
    }

    void transformVector(Vector3f vector3f, Vector3f vector3f2) {
        this.matrixTransform(vector3f, vector3f2);
    }

    void unTransformPoint(Point3f point3f, Point3f point3f2) {
        this.pointT.set(point3f.x, point3f.y, point3f.z);
        if (this.isNavigationMode) {
            this.pointT.x -= this.navigationOffset.x;
            this.pointT.y -= this.navigationOffset.y;
        } else {
            this.pointT.x -= this.fixedRotationOffset.x;
            this.pointT.y -= this.fixedRotationOffset.y;
        }
        if (this.perspectiveDepth) {
            float f = this.getPerspectiveFactor(this.pointT.z);
            this.pointT.x /= f;
            this.pointT.y /= f;
        }
        if (this.isNavigationMode) {
            this.pointT.x += this.navigationShiftXY.x;
            this.pointT.y += this.navigationShiftXY.y;
        }
        this.matrixUnTransform(this.pointT, point3f2);
    }

    protected void matrixUnTransform(Point3f point3f, Point3f point3f2) {
        this.matrixTemp.invert(this.matrixTransform);
        this.matrixTemp.transform(point3f, point3f2);
    }

    protected void matrixTransform(Point3f point3f, Point3f point3f2) {
        this.matrixTransform.transform(point3f, point3f2);
    }

    protected void matrixTransform(Vector3f vector3f, Vector3f vector3f2) {
        this.matrixTransform.transform(vector3f, vector3f2);
    }

    void move(Vector3f vector3f, float f, Vector3f vector3f2, float f2, float f3, int n) {
        int n2 = this.getSlabPercentSetting();
        float f4 = this.getTranslationXPercent();
        float f5 = this.getTranslationYPercent();
        float f6 = this.getTranslationZPercent();
        long l = System.currentTimeMillis();
        int n3 = 1000 / n;
        int n4 = (int)((float)n * f3);
        if (n4 == 0) {
            n4 = 1;
        }
        float f7 = (float)Math.PI / 180 / (float)n4;
        float f8 = f7 * vector3f.x;
        float f9 = f7 * vector3f.y;
        float f10 = f7 * vector3f.z;
        this.viewer.setInMotion(true);
        float f11 = this.zoomPercent;
        for (int i = 1; i <= n4; ++i) {
            int n5;
            int n6;
            if (vector3f.x != 0.0f) {
                this.rotateXRadians(f8);
            }
            if (vector3f.y != 0.0f) {
                this.rotateYRadians(f9);
            }
            if (vector3f.z != 0.0f) {
                this.rotateZRadians(f10);
            }
            if (f != 0.0f) {
                this.zoomToPercent(f11 + f * (float)i / (float)n4);
            }
            if (vector3f2.x != 0.0f) {
                this.translateToXPercent(f4 + vector3f2.x * (float)i / (float)n4);
            }
            if (vector3f2.y != 0.0f) {
                this.translateToYPercent(f5 + vector3f2.y * (float)i / (float)n4);
            }
            if (vector3f2.z != 0.0f) {
                this.translateToZPercent(f6 + vector3f2.z * (float)i / (float)n4);
            }
            if (f2 != 0.0f) {
                this.slabToPercent((int)((float)n2 + f2 * (float)i / (float)n4));
            }
            if ((n6 = (int)(System.currentTimeMillis() - l)) >= (n5 = i * n3)) continue;
            this.viewer.requestRepaintAndWait();
            if (!this.viewer.isScriptExecuting()) break;
            n6 = (int)(System.currentTimeMillis() - l);
            int n7 = n5 - n6;
            if (n7 <= 0) continue;
            try {
                Thread.sleep(n7);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.viewer.requestRepaintAndWait();
        this.viewer.setInMotion(false);
    }

    boolean isInPosition(Point3f point3f, float f) {
        this.aaTest1.set(new Vector3f((Tuple3f)point3f), f * (float)Math.PI / 180.0f);
        this.ptTest1.set(4.321f, 1.23456f, 3.14159f);
        this.getRotation(this.matrixTest);
        this.matrixTest.transform((Tuple3f)this.ptTest1, (Tuple3f)this.ptTest2);
        this.matrixTest.set(this.aaTest1);
        this.matrixTest.transform((Tuple3f)this.ptTest1, (Tuple3f)this.ptTest3);
        return (double)this.ptTest3.distance(this.ptTest2) < 0.1;
    }

    void moveTo(float f, Point3f point3f, Point3f point3f2, float f2, float f3, float f4, float f5, float f6, Point3f point3f3, float f7, float f8, float f9) {
        Vector3f vector3f = new Vector3f((Tuple3f)point3f2);
        if (Float.isNaN(f2)) {
            this.getRotation(this.matrixEnd);
        } else if (f2 < 0.01f && f2 > -0.01f) {
            this.matrixEnd.setIdentity();
        } else {
            if (vector3f.x == 0.0f && vector3f.y == 0.0f && vector3f.z == 0.0f) {
                int n = (int)(f * 1000.0f) - 30;
                if (n > 0) {
                    try {
                        Thread.sleep(n);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return;
            }
            this.aaMoveTo.set(vector3f, f2 * (float)Math.PI / 180.0f);
            this.matrixEnd.set(this.aaMoveTo);
        }
        this.moveTo(f, null, point3f, f3, f4, f5, f6, point3f3, f7, f8, f9);
    }

    void moveTo(float f, Matrix3f matrix3f, Point3f point3f, float f2, float f3, float f4, float f5, Point3f point3f2, float f6, float f7, float f8) {
        if (matrix3f != null) {
            this.matrixEnd.set(matrix3f);
        }
        this.ptMoveToCenter = point3f == null ? this.fixedRotationCenter : point3f;
        float f9 = this.modelRadius;
        float f10 = point3f == null ? this.modelRadius : (f5 <= 0.0f ? this.viewer.calcRotationRadius(point3f) : f5);
        float f11 = this.scaleDefaultPixelsPerAngstrom;
        float f12 = point3f == null ? f11 : this.defaultScaleToScreen(f10);
        this.getRotation(this.matrixStart);
        this.matrixInverse.invert(this.matrixStart);
        this.matrixStep.mul(this.matrixEnd, this.matrixInverse);
        this.aaTotal.set(this.matrixStep);
        int n = 30;
        int n2 = (int)(f * (float)n);
        this.viewer.setInMotion(true);
        if (n2 > 1) {
            int n3 = 1000 / n;
            long l = System.currentTimeMillis();
            float f13 = this.zoomPercent;
            float f14 = f2 - f13;
            float f15 = this.getTranslationXPercent();
            float f16 = f3 - f15;
            float f17 = this.getTranslationYPercent();
            float f18 = f4 - f17;
            this.aaStepCenter.set((Tuple3f)this.ptMoveToCenter);
            this.aaStepCenter.sub((Tuple3f)this.fixedRotationCenter);
            this.aaStepCenter.scale(1.0f / (float)n2);
            float f19 = f12 - f11;
            float f20 = f10 - f9;
            if (point3f2 != null && this.isNavigationMode) {
                this.aaStepNavCenter.set((Tuple3f)point3f2);
                this.aaStepNavCenter.sub((Tuple3f)this.navigationCenter);
                this.aaStepNavCenter.scale(1.0f / (float)n2);
            }
            float f21 = this.getNavigationOffsetPercent('X');
            float f22 = f6 - f21;
            float f23 = this.getNavigationOffsetPercent('Y');
            float f24 = f7 - f23;
            float f25 = this.getNavigationDepthPercent();
            float f26 = f8 - f25;
            for (int i = 1; i < n2; ++i) {
                this.getRotation(this.matrixStart);
                this.matrixInverse.invert(this.matrixStart);
                this.matrixStep.mul(this.matrixEnd, this.matrixInverse);
                this.aaTotal.set(this.matrixStep);
                this.aaStep.set(this.aaTotal);
                this.aaStep.angle /= (float)(n2 - i);
                if (this.aaStep.angle == 0.0f) {
                    this.matrixStep.setIdentity();
                } else {
                    this.matrixStep.set(this.aaStep);
                }
                this.matrixStep.mul(this.matrixStart);
                float f27 = (float)i / ((float)n2 - 1.0f);
                this.modelRadius = f9 + f20 * f27;
                this.scaleDefaultPixelsPerAngstrom = f11 + f19 * f27;
                this.zoomToPercent(f13 + f14 * f27);
                this.translateToXPercent(f15 + f16 * f27);
                this.translateToYPercent(f17 + f18 * f27);
                this.setRotation(this.matrixStep);
                if (point3f != null) {
                    this.fixedRotationCenter.add((Tuple3f)this.aaStepCenter);
                }
                if (point3f2 != null && this.isNavigationMode) {
                    this.navigationCenter.add((Tuple3f)this.aaStepNavCenter);
                    this.navigate(0.0f, this.navigationCenter);
                    if (!Float.isNaN(f6) && !Float.isNaN(f7)) {
                        this.navTranslatePercent(0.0f, f21 + f22 * f27, f23 + f24 * f27);
                    }
                    if (!Float.isNaN(f8)) {
                        this.setNavigationDepthPercent(0.0f, f25 + f26 * f27);
                    }
                }
                if (System.currentTimeMillis() >= (l += (long)n3)) continue;
                this.viewer.requestRepaintAndWait();
                if (this.viewer.isScriptExecuting()) {
                    int n4 = (int)(l - System.currentTimeMillis());
                    if (n4 <= 0) continue;
                    try {
                        Thread.sleep(n4);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                break;
            }
        } else {
            int n5 = (int)(f * 1000.0f) - 30;
            if (n5 > 0) {
                try {
                    Thread.sleep(n5);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.setRotationRadius(f10);
        this.scaleDefaultPixelsPerAngstrom = f12;
        if (point3f != null) {
            this.moveRotationCenter(point3f, !this.windowCentered);
        }
        this.zoomToPercent(f2);
        this.translateToXPercent(f3);
        this.translateToYPercent(f4);
        this.setRotation(this.matrixEnd);
        if (point3f2 != null && this.isNavigationMode) {
            this.navigationCenter.set((Tuple3f)point3f2);
            if (!Float.isNaN(f6) && !Float.isNaN(f7)) {
                this.navTranslatePercent(0.0f, f6, f7);
            }
            if (!Float.isNaN(f8)) {
                this.setNavigationDepthPercent(0.0f, f8);
            }
        }
        if (f >= 0.0f) {
            this.viewer.requestRepaintAndWait();
        }
        this.viewer.setInMotion(false);
    }

    String getMoveToText(float f, boolean bl) {
        this.axisangleT.set(this.matrixRotate);
        float f2 = this.axisangleT.angle * 57.29578f;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("moveto ");
        if (bl) {
            stringBuffer.append("/* time, axisAngle */ ");
        }
        stringBuffer.append(f);
        if (f2 < 0.01f) {
            stringBuffer.append(" {0 0 1 0}");
        } else {
            this.vectorT.set(this.axisangleT.x, this.axisangleT.y, this.axisangleT.z);
            this.vectorT.normalize();
            this.vectorT.scale(1000.0f);
            stringBuffer.append(" {");
            TransformManager.truncate0(stringBuffer, this.vectorT.x);
            TransformManager.truncate0(stringBuffer, this.vectorT.y);
            TransformManager.truncate0(stringBuffer, this.vectorT.z);
            TransformManager.truncate2(stringBuffer, f2);
            stringBuffer.append("}");
        }
        if (bl) {
            stringBuffer.append(" /* zoom, translation */ ");
        }
        TransformManager.truncate2(stringBuffer, this.zoomPercent);
        TransformManager.truncate2(stringBuffer, this.getTranslationXPercent());
        TransformManager.truncate2(stringBuffer, this.getTranslationYPercent());
        stringBuffer.append(" ");
        if (bl) {
            stringBuffer.append(" /* center, rotationRadius */ ");
        }
        stringBuffer.append(this.getCenterText());
        stringBuffer.append(" ").append(this.modelRadius);
        stringBuffer.append(this.getNavigationText(bl));
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private String getCenterText() {
        return Escape.escape((Tuple3f)this.fixedRotationCenter);
    }

    private String getRotateXyzText() {
        float f;
        float f2;
        StringBuffer stringBuffer = new StringBuffer();
        float f3 = this.matrixRotate.m20;
        float f4 = -((float)Math.asin(f3)) * 57.29578f;
        if (f3 > 0.999f || f3 < -0.999f) {
            f2 = -((float)Math.atan2(this.matrixRotate.m12, this.matrixRotate.m11)) * 57.29578f;
            f = 0.0f;
        } else {
            f2 = (float)Math.atan2(this.matrixRotate.m21, this.matrixRotate.m22) * 57.29578f;
            f = (float)Math.atan2(this.matrixRotate.m10, this.matrixRotate.m00) * 57.29578f;
        }
        stringBuffer.append("reset");
        stringBuffer.append(";center ").append(this.getCenterText());
        if (f2 != 0.0f) {
            stringBuffer.append("; rotate x");
            TransformManager.truncate2(stringBuffer, f2);
        }
        if (f4 != 0.0f) {
            stringBuffer.append("; rotate y");
            TransformManager.truncate2(stringBuffer, f4);
        }
        if (f != 0.0f) {
            stringBuffer.append("; rotate z");
            TransformManager.truncate2(stringBuffer, f);
        }
        stringBuffer.append(";");
        this.addZoomTranslationNavigationText(stringBuffer);
        return stringBuffer.toString();
    }

    private void addZoomTranslationNavigationText(StringBuffer stringBuffer) {
        float f;
        float f2;
        if (this.zoomPercent != 100.0f) {
            stringBuffer.append(" zoom");
            TransformManager.truncate2(stringBuffer, this.zoomPercent);
            stringBuffer.append(";");
        }
        if ((f2 = this.getTranslationXPercent()) != 0.0f) {
            stringBuffer.append(" translate x");
            TransformManager.truncate2(stringBuffer, f2);
            stringBuffer.append(";");
        }
        if ((f = this.getTranslationYPercent()) != 0.0f) {
            stringBuffer.append(" translate y");
            TransformManager.truncate2(stringBuffer, f);
            stringBuffer.append(";");
        }
        if (this.modelRadius != this.rotationRadiusDefault) {
            stringBuffer.append(" set rotationRadius");
            TransformManager.truncate2(stringBuffer, this.modelRadius);
            stringBuffer.append(";");
        }
        if (this.isNavigationMode) {
            stringBuffer.append("navigate 0 center ").append(Escape.escape((Tuple3f)this.navigationCenter));
            stringBuffer.append(";navigate 0 translate");
            TransformManager.truncate2(stringBuffer, this.getNavigationOffsetPercent('X'));
            TransformManager.truncate2(stringBuffer, this.getNavigationOffsetPercent('Y'));
            stringBuffer.append(";navigate 0 depth ");
            TransformManager.truncate2(stringBuffer, this.getNavigationDepthPercent());
            stringBuffer.append(";");
        }
    }

    private String getRotateZyzText(boolean bl) {
        float f;
        float f2;
        StringBuffer stringBuffer = new StringBuffer();
        float f3 = this.matrixRotate.m22;
        float f4 = (float)Math.acos(f3) * 57.29578f;
        if (f3 > 0.999f || f3 < -0.999f) {
            f2 = (float)Math.atan2(this.matrixRotate.m10, this.matrixRotate.m11) * 57.29578f;
            f = 0.0f;
        } else {
            f2 = (float)Math.atan2(this.matrixRotate.m21, -this.matrixRotate.m20) * 57.29578f;
            f = (float)Math.atan2(this.matrixRotate.m12, this.matrixRotate.m02) * 57.29578f;
        }
        if (f2 != 0.0f && f4 != 0.0f && f != 0.0f && bl) {
            stringBuffer.append("#Follows Z-Y-Z convention for Euler angles\n");
        }
        stringBuffer.append("reset");
        stringBuffer.append(";center ").append(this.getCenterText());
        if (f2 != 0.0f) {
            stringBuffer.append("; rotate z");
            TransformManager.truncate2(stringBuffer, f2);
        }
        if (f4 != 0.0f) {
            stringBuffer.append("; rotate y");
            TransformManager.truncate2(stringBuffer, f4);
        }
        if (f != 0.0f) {
            stringBuffer.append("; rotate z");
            TransformManager.truncate2(stringBuffer, f);
        }
        stringBuffer.append(";");
        this.addZoomTranslationNavigationText(stringBuffer);
        return stringBuffer.toString();
    }

    private static void truncate0(StringBuffer stringBuffer, float f) {
        stringBuffer.append(' ');
        stringBuffer.append(Math.round(f));
    }

    private static void truncate2(StringBuffer stringBuffer, float f) {
        stringBuffer.append(' ');
        stringBuffer.append((float)Math.round(f * 100.0f) / 100.0f);
    }

    void setSpinX(float f) {
        this.spinX = f;
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinY(float f) {
        this.spinY = f;
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinZ(float f) {
        this.spinZ = f;
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinFps(int n) {
        if (n <= 0) {
            n = 1;
        } else if (n > 50) {
            n = 50;
        }
        this.spinFps = n;
    }

    private void clearSpin() {
        this.setSpinOn(false);
        this.isSpinInternal = false;
        this.isSpinFixed = false;
    }

    boolean getSpinOn() {
        return this.spinOn;
    }

    void setSpinOn(boolean bl) {
        this.setSpinOn(bl, Float.MAX_VALUE, false);
    }

    private void setSpinOn(boolean bl, float f, boolean bl2) {
        this.spinOn = bl;
        this.viewer.setBooleanProperty("_spinning", bl);
        if (bl) {
            if (this.spinThread == null) {
                this.spinThread = new SpinThread(f, bl2);
                this.spinThread.start();
            }
        } else if (this.spinThread != null) {
            this.spinThread.interrupt();
            this.spinThread = null;
        }
    }

    void setVibrationScale(float f) {
        this.vibrationScale = f;
    }

    void setVibrationPeriod(float f) {
        if (Float.isNaN(f)) {
            f = this.vibrationPeriod;
        } else if (f == 0.0f) {
            this.vibrationPeriod = 0.0f;
            this.vibrationPeriodMs = 0;
        } else {
            this.vibrationPeriod = Math.abs(f);
            this.vibrationPeriodMs = (int)(this.vibrationPeriod * 1000.0f);
            if (f > 0.0f) {
                return;
            }
            f = -f;
        }
        this.setVibrationOn(f > 0.0f && this.viewer.modelHasVibrationVectors(this.viewer.getCurrentModelIndex()));
    }

    protected void setVibrationT(float f) {
        this.vibrationRadians = f * ((float)Math.PI * 2);
        if (this.vibrationScale == 0.0f) {
            this.vibrationScale = this.viewer.getVibrationScale();
        }
        this.vibrationAmplitude = (float)Math.cos(this.vibrationRadians) * this.vibrationScale;
    }

    private void setVibrationOn(boolean bl) {
        if (!bl) {
            if (this.vibrationThread != null) {
                this.vibrationThread.interrupt();
                this.vibrationThread = null;
            }
            this.vibrationOn = false;
            return;
        }
        if (this.viewer.getModelCount() < 1) {
            this.vibrationOn = false;
            return;
        }
        if (this.vibrationThread == null) {
            this.vibrationThread = new VibrationThread();
            this.vibrationThread.start();
        }
        this.vibrationOn = true;
    }

    private void clearVibration() {
        this.setVibrationOn(false);
        this.vibrationScale = 0.0f;
    }

    void setStereoMode(int[] nArray) {
        this.stereoMode = 5;
        this.stereoColors = nArray;
    }

    void setStereoMode(int n) {
        this.stereoColors = null;
        this.stereoMode = n;
    }

    void setStereoDegrees(float f) {
        this.stereoDegrees = f;
        this.stereoRadians = f * ((float)Math.PI / 180);
    }

    synchronized Matrix3f getStereoRotationMatrix(boolean bl) {
        this.stereoFrame = bl;
        if (bl) {
            this.matrixTemp3.rotY(this.axesOrientationRasmol ? this.stereoRadians : -this.stereoRadians);
            this.matrixStereo.mul(this.matrixTemp3, this.matrixRotate);
        } else {
            this.matrixStereo.set(this.matrixRotate);
        }
        return this.matrixStereo;
    }

    boolean isWindowCentered() {
        return this.windowCentered;
    }

    void setWindowCentered(boolean bl) {
        this.windowCentered = bl;
        this.resetNavigationPoint(true);
    }

    void setDefaultRotation() {
        this.rotationCenterDefault.set((Tuple3f)this.viewer.getBoundBoxCenter());
        this.setFixedRotationCenter(this.rotationCenterDefault);
        this.rotationRadiusDefault = this.setRotationRadius(this.viewer.calcRotationRadius(this.rotationCenterDefault));
        this.windowCentered = true;
    }

    Point3f getRotationCenter() {
        return this.fixedRotationCenter;
    }

    float getRotationRadius() {
        return this.modelRadius;
    }

    float setRotationRadius(float f) {
        this.modelRadius = f <= 0.0f ? this.viewer.calcRotationRadius(this.fixedRotationCenter) : f;
        return this.modelRadius;
    }

    private void setRotationCenterAndRadiusXYZ(Point3f point3f, boolean bl) {
        this.resetNavigationPoint(false);
        if (point3f == null) {
            this.setFixedRotationCenter(this.rotationCenterDefault);
            this.modelRadius = this.rotationRadiusDefault;
            return;
        }
        this.setFixedRotationCenter(point3f);
        if (bl && this.windowCentered) {
            this.modelRadius = this.viewer.calcRotationRadius(this.fixedRotationCenter);
        }
    }

    private void setRotationCenterAndRadiusXYZ(String string, Point3f point3f) {
        this.pointT.set((Tuple3f)point3f);
        if (string == "average") {
            this.pointT.add((Tuple3f)this.viewer.getAverageAtomPoint());
        } else if (string == "boundbox") {
            this.pointT.add((Tuple3f)this.viewer.getBoundBoxCenter());
        } else if (string != "absolute") {
            this.pointT.set((Tuple3f)this.rotationCenterDefault);
        }
        this.setRotationCenterAndRadiusXYZ(this.pointT, true);
    }

    void setNewRotationCenter(Point3f point3f, boolean bl) {
        if (point3f == null) {
            point3f = this.rotationCenterDefault;
        }
        if (this.windowCentered) {
            this.translateToXPercent(0.0f);
            this.translateToYPercent(0.0f);
            this.setRotationCenterAndRadiusXYZ(point3f, true);
            if (bl) {
                this.scaleFitToScreen(true);
            }
        } else {
            this.moveRotationCenter(point3f, true);
        }
    }

    private void moveRotationCenter(Point3f point3f, boolean bl) {
        this.setRotationCenterAndRadiusXYZ(point3f, false);
        if (bl) {
            this.setRotationPointXY(this.fixedRotationCenter);
        }
    }

    void setCenter() {
        this.setRotationCenterAndRadiusXYZ(this.fixedRotationCenter, true);
    }

    void setCenterAt(String string, Point3f point3f) {
        this.setRotationCenterAndRadiusXYZ(string, point3f);
        this.scaleFitToScreen(true);
    }

    boolean canNavigate() {
        return false;
    }

    synchronized void navigate(int n, int n2) {
    }

    void navigate(float f, Point3f point3f) {
    }

    void navigate(float f, Vector3f vector3f, float f2) {
    }

    void navigate(float f, Point3f[] point3fArray, float[] fArray, int n, int n2) {
    }

    void navigate(float f, Point3f[][] point3fArray) {
    }

    void navTranslate(float f, Point3f point3f) {
    }

    void navTranslatePercent(float f, float f2, float f3) {
    }

    protected void calcNavigationPoint() {
    }

    protected void resetNavigationPoint(boolean bl) {
    }

    protected String getNavigationState() {
        return "";
    }

    void setNavigationDepthPercent(float f, float f2) {
    }

    Point3f getNavigationCenter() {
        return null;
    }

    Point3f getNavigationOffset() {
        return null;
    }

    float getNavigationDepthPercent() {
        return Float.NaN;
    }

    float getNavigationOffsetPercent(char c) {
        return 0.0f;
    }

    void setNavigationSlabOffsetPercent(float f) {
    }

    String getNavigationText(boolean bl) {
        return "";
    }

    boolean isNavigationCentered() {
        return false;
    }

    class VibrationThread
    extends Thread
    implements Runnable {
        VibrationThread() {
        }

        public void run() {
            long l;
            long l2 = l = System.currentTimeMillis();
            try {
                do {
                    long l3;
                    int n;
                    int n2;
                    if ((n2 = 33 - (n = (int)((l3 = System.currentTimeMillis()) - l2))) > 0) {
                        Thread.sleep(n2);
                    }
                    l2 = l3 = System.currentTimeMillis();
                    n = (int)(l3 - l);
                    float f = (float)(n % TransformManager.this.vibrationPeriodMs) / (float)TransformManager.this.vibrationPeriodMs;
                    TransformManager.this.setVibrationT(f);
                    TransformManager.this.viewer.refresh(0, "TransformationManager:VibrationThread:run()");
                } while (!this.isInterrupted());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class SpinThread
    extends Thread
    implements Runnable {
        float endDegrees;
        float nDegrees = 0.0f;
        boolean isSelected;

        SpinThread(float f, boolean bl) {
            this.endDegrees = Math.abs(f);
            this.isSelected = bl;
        }

        public void run() {
            float f = TransformManager.this.spinFps;
            TransformManager.this.viewer.setBooleanProperty("isSpinning", true);
            int n = 0;
            long l = System.currentTimeMillis();
            while (!this.isInterrupted()) {
                int n2;
                int n3;
                boolean bl;
                if (f != TransformManager.this.spinFps) {
                    f = TransformManager.this.spinFps;
                    n = 0;
                    l = System.currentTimeMillis();
                }
                if (f == 0.0f || !TransformManager.this.spinOn) {
                    TransformManager.this.setSpinOn(false);
                    break;
                }
                boolean bl2 = bl = TransformManager.this.isSpinInternal && TransformManager.this.internalRotationAxis.angle != 0.0f || TransformManager.this.isSpinFixed && TransformManager.this.fixedRotationAxis.angle != 0.0f || !TransformManager.this.isSpinFixed && !TransformManager.this.isSpinInternal && TransformManager.this.spinX + TransformManager.this.spinY + TransformManager.this.spinZ != 0.0f;
                int n4 = (int)(System.currentTimeMillis() - l);
                if ((n3 = (n2 = (int)((float)(++n * 1000) / f)) - n4) <= 0) continue;
                boolean bl3 = TransformManager.this.viewer.getInMotion();
                if (bl3) {
                    n3 += 1000;
                }
                if (bl && TransformManager.this.spinOn && !bl3) {
                    float f2 = 0.0f;
                    if (this.isSelected) {
                        TransformManager.this.setRotateSelected(true);
                    }
                    if (TransformManager.this.isSpinInternal || TransformManager.this.isSpinFixed) {
                        f2 = (TransformManager.this.isSpinInternal ? TransformManager.this.internalRotationAxis : TransformManager.this.fixedRotationAxis).angle / f;
                        if (TransformManager.this.isSpinInternal) {
                            TransformManager.this.rotateAxisAngleRadiansInternal(f2);
                        } else {
                            TransformManager.this.rotateAxisAngleRadiansFixed(f2);
                        }
                        this.nDegrees += Math.abs(f2 / ((float)Math.PI * 2) * 360.0f);
                    } else {
                        if (TransformManager.this.spinX != 0.0f) {
                            TransformManager.this.rotateXRadians(TransformManager.this.spinX * ((float)Math.PI / 180) / f);
                        }
                        if (TransformManager.this.spinY != 0.0f) {
                            TransformManager.this.rotateYRadians(TransformManager.this.spinY * ((float)Math.PI / 180) / f);
                        }
                        if (TransformManager.this.spinZ != 0.0f) {
                            TransformManager.this.rotateZRadians(TransformManager.this.spinZ * ((float)Math.PI / 180) / f);
                        }
                    }
                    if (this.isSelected) {
                        TransformManager.this.setRotateSelected(false);
                    }
                    TransformManager.this.viewer.refresh(1, "TransformationManager:SpinThread:run()");
                    if ((double)this.nDegrees >= (double)this.endDegrees - 1.0E-5) {
                        TransformManager.this.setSpinOn(false);
                    }
                }
                try {
                    Thread.sleep(n3);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            TransformManager.this.viewer.setBooleanProperty("isSpinning", false);
            if (this.isSelected) {
                TransformManager.this.setRotateSelected(false);
            }
        }
    }
}

