/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Hashtable;
import netscape.javascript.JSObject;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.util.Logger;
import org.xml.sax.XMLReader;

public class XmlChem3dReader
extends XmlReader {
    String[] chem3dImplementedAttributes = new String[]{"id", "symbol", "cartCoords", "bondAtom1", "bondAtom2", "bondOrder", "gridDatXDim", "gridDatYDim", "gridDatZDim", "gridDatXSize", "gridDatYSize", "gridDatZSize", "gridDatOrigin", "gridDatDat", "calcPartialCharges", "calcAtoms"};

    XmlChem3dReader(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, XMLReader xMLReader) {
        this.parent = xmlReader;
        this.reader = bufferedReader;
        this.atomSetCollection = atomSetCollection;
        new Chem3dHandler(xMLReader);
        this.parseReaderXML(xMLReader);
    }

    XmlChem3dReader(XmlReader xmlReader, AtomSetCollection atomSetCollection, JSObject jSObject) {
        this.parent = xmlReader;
        this.atomSetCollection = atomSetCollection;
        this.implementedAttributes = this.chem3dImplementedAttributes;
        new Chem3dHandler().walkDOMTree(jSObject);
    }

    public void processStartElement(String string, String string2, String string3, HashMap hashMap) {
        int n;
        String[] stringArray;
        String[] stringArray2;
        if ("model".equals(string2)) {
            this.atomSetCollection.newAtomSet();
            return;
        }
        if ("atom".equals(string2)) {
            this.atom = new Atom();
            this.atom.atomName = (String)hashMap.get("id");
            this.atom.elementSymbol = (String)hashMap.get("symbol");
            if (hashMap.containsKey("cartCoords")) {
                String string4 = (String)hashMap.get("cartCoords");
                String[] stringArray3 = AtomSetCollectionReader.getTokens((String)string4);
                this.atom.x = this.parseFloat(stringArray3[0]);
                this.atom.y = this.parseFloat(stringArray3[1]);
                this.atom.z = this.parseFloat(stringArray3[2]);
            }
            return;
        }
        if ("bond".equals(string2)) {
            String string5 = (String)hashMap.get("bondAtom1");
            String string6 = (String)hashMap.get("bondAtom2");
            int n2 = 1;
            if (hashMap.containsKey("bondOrder")) {
                n2 = this.parseInt((String)hashMap.get("bondOrder"));
            }
            this.atomSetCollection.addNewBond(string5, string6, n2);
            return;
        }
        if ("electronicStructureCalculation".equals(string2)) {
            stringArray2 = AtomSetCollectionReader.getTokens((String)((String)hashMap.get("calcPartialCharges")));
            stringArray = AtomSetCollectionReader.getTokens((String)((String)hashMap.get("calcAtoms")));
            n = this.parseInt(stringArray2[0]);
            while (--n >= 0) {
                this.atomSetCollection.mapPartialCharge(stringArray[n + 1], this.parseFloat(stringArray2[n + 1]));
            }
        }
        if ("gridData".equals(string2)) {
            stringArray = new VolumeData();
            n = this.parseInt((String)hashMap.get("gridDatXDim"));
            int n3 = this.parseInt((String)hashMap.get("gridDatYDim"));
            int n4 = this.parseInt((String)hashMap.get("gridDatZDim"));
            stringArray.voxelCounts[0] = n;
            stringArray.voxelCounts[1] = n3;
            stringArray.voxelCounts[2] = n4;
            float f = this.parseFloat((String)hashMap.get("gridDatXSize")) / (float)n;
            float f2 = this.parseFloat((String)hashMap.get("gridDatYSize")) / (float)n3;
            float f3 = this.parseFloat((String)hashMap.get("gridDatZSize")) / (float)n4;
            stringArray.setVolumetricVector(0, f, 0.0f, 0.0f);
            stringArray.setVolumetricVector(1, 0.0f, f2, 0.0f);
            stringArray.setVolumetricVector(2, 0.0f, 0.0f, f3);
            stringArray2 = AtomSetCollectionReader.getTokens((String)((String)hashMap.get("gridDatOrigin")));
            stringArray.volumetricOrigin.set(this.parseFloat(stringArray2[0]), this.parseFloat(stringArray2[1]), this.parseFloat(stringArray2[2]));
            stringArray2 = AtomSetCollectionReader.getTokens((String)((String)hashMap.get("gridDatData")));
            int n5 = this.parseInt(stringArray2[0]);
            int n6 = 1;
            float[][][] fArray = new float[n][n3][n4];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n; ++k) {
                        fArray[k][j][i] = this.parseFloat(stringArray2[n6++]);
                    }
                }
            }
            stringArray.setVoxelData(fArray);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("surfaceDataType", "mo");
            hashtable.put("defaultCutoff", new Float(0.01));
            hashtable.put("nCubeData", new Integer(n5));
            hashtable.put("volumeData", stringArray);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("jmolSurfaceInfo", hashtable);
            Logger.debug((String)"Chem3D molecular orbital data displayable using:  isosurface sign \"\" ");
            return;
        }
    }

    public void processEndElement(String string, String string2, String string3) {
        if ("atom".equals(string2)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.keepChars = false;
        this.chars = null;
    }

    class Chem3dHandler
    extends XmlReader.JmolXmlHandler {
        Chem3dHandler() {
            super(XmlChem3dReader.this);
        }

        Chem3dHandler(XMLReader xMLReader) {
            super(XmlChem3dReader.this);
            this.setHandler(xMLReader, this);
        }
    }
}

