/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3i;
import org.jmol.symmetry.Rotation;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.Translation;
import org.jmol.util.Logger;

public class HallInfo {
    String hallSymbol;
    String primitiveHallSymbol;
    char latticeCode;
    String latticeExtension;
    boolean isCentrosymmetric;
    int nRotations;
    RotationTerm[] rotationTerms = new RotationTerm[16];
    Point3i vector12ths;
    String vectorCode;

    public HallInfo(String string) {
        try {
            String string2 = this.hallSymbol = string.trim();
            string2 = this.extractLatticeInfo(string2);
            if (Translation.getLatticeIndex(this.latticeCode) == 0) {
                return;
            }
            this.latticeExtension = Translation.getLatticeExtension(this.latticeCode, this.isCentrosymmetric);
            string2 = this.extractVectorInfo(string2) + this.latticeExtension;
            int n = 0;
            char c = '\u0000';
            this.primitiveHallSymbol = "P";
            while (string2.length() > 0 && this.nRotations < 16) {
                string2 = this.extractRotationInfo(string2, n, c);
                RotationTerm rotationTerm = this.rotationTerms[this.nRotations - 1];
                this.primitiveHallSymbol = this.primitiveHallSymbol + " " + rotationTerm.primitiveCode;
            }
            this.primitiveHallSymbol = this.primitiveHallSymbol + this.vectorCode;
        }
        catch (Exception exception) {
            Logger.error("Invalid Hall symbol");
            this.nRotations = 0;
        }
    }

    public String dumpInfo() {
        StringBuffer stringBuffer = new StringBuffer("\nHall symbol: ").append(this.hallSymbol).append("\nprimitive Hall symbol: ").append(this.primitiveHallSymbol).append("\nlattice type: ").append(this.getLatticeDesignation());
        for (int i = 0; i < this.nRotations; ++i) {
            stringBuffer.append("\n\nrotation term ").append(i + 1).append(this.rotationTerms[i].dumpInfo());
        }
        return stringBuffer.toString();
    }

    public String getLatticeDesignation() {
        return Translation.getLatticeDesignation(this.latticeCode, this.isCentrosymmetric);
    }

    private String extractLatticeInfo(String string) {
        int n = string.indexOf(" ");
        if (n < 0) {
            return "";
        }
        String string2 = string.substring(0, n).toUpperCase();
        this.latticeCode = string2.charAt(0);
        if (this.latticeCode == '-') {
            this.isCentrosymmetric = true;
            this.latticeCode = string2.charAt(1);
        }
        return string.substring(n + 1).trim();
    }

    private String extractVectorInfo(String string) {
        this.vector12ths = new Point3i();
        this.vectorCode = "";
        int n = string.indexOf("(");
        int n2 = string.indexOf(")", n);
        if (n > 0 && n2 > n) {
            String string2 = string.substring(n + 1, n2);
            this.vectorCode = " (" + string2 + ")";
            string = string.substring(0, n).trim();
            n = string2.indexOf(" ");
            if (n >= 0) {
                this.vector12ths.x = Integer.parseInt(string2.substring(0, n));
                if ((n = (string2 = string2.substring(n + 1).trim()).indexOf(" ")) >= 0) {
                    this.vector12ths.y = Integer.parseInt(string2.substring(0, n));
                    string2 = string2.substring(n + 1).trim();
                }
            }
            this.vector12ths.z = Integer.parseInt(string2);
        }
        return string;
    }

    private String extractRotationInfo(String string, int n, char c) {
        String string2;
        int n2 = string.indexOf(" ");
        if (n2 >= 0) {
            string2 = string.substring(0, n2);
            string = string.substring(n2 + 1).trim();
        } else {
            string2 = string;
            string = "";
        }
        this.rotationTerms[this.nRotations] = new RotationTerm(string2, n, c);
        ++this.nRotations;
        return string;
    }

    class RotationTerm {
        String inputCode;
        String primitiveCode;
        String lookupCode;
        String translationString;
        Rotation rotation;
        Translation translation;
        Matrix4f seitzMatrix12ths = new Matrix4f();
        boolean isImproper;
        int order;
        char axisType;
        char diagonalReferenceAxis;
        boolean allPositive = true;

        RotationTerm() {
        }

        RotationTerm(String string, int n, char c) {
            this.getRotationInfo(string, n, c);
        }

        String dumpInfo() {
            StringBuffer stringBuffer = new StringBuffer("\ninput code: ").append(this.inputCode).append("; primitive code: ").append(this.primitiveCode).append("\norder: ").append(this.order).append(this.isImproper ? " (improper axis)" : "");
            if (this.axisType != '_') {
                stringBuffer.append("; axisType: ").append(this.axisType);
                if (this.diagonalReferenceAxis != '\u0000') {
                    stringBuffer.append(this.diagonalReferenceAxis);
                }
            }
            if (this.translationString.length() > 0) {
                stringBuffer.append("; translation: ").append(this.translationString);
            }
            if (HallInfo.this.vectorCode.length() > 0) {
                stringBuffer.append("; vector offset:").append(HallInfo.this.vectorCode);
            }
            if (this.rotation != null) {
                stringBuffer.append("\noperator: ").append(this.getXYZ(this.allPositive)).append("\nSeitz matrix:\n").append(SymmetryOperation.dumpSeitz(this.seitzMatrix12ths));
            }
            return stringBuffer.toString();
        }

        String getXYZ(boolean bl) {
            return SymmetryOperation.getXYZFromMatrix(this.seitzMatrix12ths, bl);
        }

        private void getRotationInfo(String string, int n, char c) {
            this.inputCode = string;
            if ((string = string + "   ").charAt(0) == '-') {
                this.isImproper = true;
                string = string.substring(1);
            }
            this.primitiveCode = "";
            this.order = string.charAt(0) - 48;
            this.diagonalReferenceAxis = '\u0000';
            this.axisType = '\u0000';
            int n2 = 2;
            char c2 = string.charAt(1);
            block0 : switch (c2) {
                case 'x': 
                case 'y': 
                case 'z': {
                    switch (string.charAt(2)) {
                        case '\"': 
                        case '\'': {
                            this.diagonalReferenceAxis = c2;
                            c2 = string.charAt(2);
                            ++n2;
                        }
                    }
                }
                case '*': {
                    this.axisType = c2;
                    break;
                }
                case '\"': 
                case '\'': {
                    this.axisType = c2;
                    switch (string.charAt(2)) {
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            this.diagonalReferenceAxis = string.charAt(2);
                            ++n2;
                            break block0;
                        }
                    }
                    this.diagonalReferenceAxis = c;
                    break;
                }
                default: {
                    this.axisType = (char)(this.order == 1 ? 95 : (HallInfo.this.nRotations == 0 ? 122 : (HallInfo.this.nRotations == 2 ? 42 : (n == 2 || n == 4 ? 120 : 39))));
                    string = string.substring(0, 1) + this.axisType + string.substring(1);
                }
            }
            this.primitiveCode = this.primitiveCode + (this.axisType == '_' ? "1" : string.substring(0, 2));
            if (this.diagonalReferenceAxis != '\u0000') {
                string = string.substring(0, 1) + this.diagonalReferenceAxis + this.axisType + string.substring(n2);
                this.primitiveCode = this.primitiveCode + this.diagonalReferenceAxis;
                n2 = 3;
            }
            this.lookupCode = string.substring(0, n2);
            this.rotation = Rotation.lookup(this.lookupCode);
            if (this.rotation == null) {
                Logger.error("Rotation lookup could not find " + this.inputCode + " ? " + this.lookupCode);
                return;
            }
            this.translation = new Translation();
            this.translationString = "";
            int n3 = string.length();
            for (int i = n2; i < n3; ++i) {
                char c3 = string.charAt(i);
                Translation translation = new Translation(c3, this.order);
                if (translation.translationCode == '\u0000') continue;
                this.translationString = this.translationString + "" + translation.translationCode;
                this.translation.rotationShift12ths += translation.rotationShift12ths;
                this.translation.vectorShift12ths.add((Tuple3i)translation.vectorShift12ths);
            }
            this.primitiveCode = (this.isImproper ? "-" : "") + this.primitiveCode + this.translationString;
            if (this.isImproper) {
                this.seitzMatrix12ths.set(this.rotation.seitzMatrixInv);
            } else {
                this.seitzMatrix12ths.set(this.rotation.seitzMatrix);
            }
            this.seitzMatrix12ths.m03 = this.translation.vectorShift12ths.x;
            this.seitzMatrix12ths.m13 = this.translation.vectorShift12ths.y;
            this.seitzMatrix12ths.m23 = this.translation.vectorShift12ths.z;
            switch (this.axisType) {
                case 'x': {
                    this.seitzMatrix12ths.m03 += (float)this.translation.rotationShift12ths;
                    break;
                }
                case 'y': {
                    this.seitzMatrix12ths.m13 += (float)this.translation.rotationShift12ths;
                    break;
                }
                case 'z': {
                    this.seitzMatrix12ths.m23 += (float)this.translation.rotationShift12ths;
                }
            }
            if (HallInfo.this.vectorCode.length() > 0) {
                Matrix4f matrix4f = new Matrix4f();
                Matrix4f matrix4f2 = new Matrix4f();
                matrix4f.setIdentity();
                matrix4f2.setIdentity();
                matrix4f.m03 = HallInfo.this.vector12ths.x;
                matrix4f.m13 = HallInfo.this.vector12ths.y;
                matrix4f.m23 = HallInfo.this.vector12ths.z;
                matrix4f2.m03 = -HallInfo.this.vector12ths.x;
                matrix4f2.m13 = -HallInfo.this.vector12ths.y;
                matrix4f2.m23 = -HallInfo.this.vector12ths.z;
                this.seitzMatrix12ths.mul(matrix4f, this.seitzMatrix12ths);
                this.seitzMatrix12ths.mul(matrix4f2);
            }
            if (Logger.isActiveLevel(0)) {
                Logger.debug("code = " + string + "; primitive code =" + this.primitiveCode + "\n Seitz Matrix(12ths):" + this.seitzMatrix12ths);
            }
        }
    }
}

