/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.text.DecimalFormat;
import org.jmol.util.Parser;

public class TextFormat {
    private static final DecimalFormat[] formatters = new DecimalFormat[10];
    private static final String[] formattingStrings = new String[]{"0", "0.0", "0.00", "0.000", "0.0000", "0.00000", "0.000000", "0.0000000", "0.00000000", "0.000000000"};
    private static final Boolean[] useNumberLocalization = new Boolean[1];

    public TextFormat() {
        TextFormat.useNumberLocalization[0] = Boolean.TRUE;
    }

    public static void setUseNumberLocalization(boolean bl) {
        TextFormat.useNumberLocalization[0] = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String formatDecimal(float f, int n) {
        DecimalFormat decimalFormat;
        if (n == Integer.MAX_VALUE) {
            return "" + f;
        }
        if (n < 0) {
            double d;
            if ((n = -n) > formattingStrings.length) {
                n = formattingStrings.length;
            }
            if (f == 0.0f) {
                return formattingStrings[n] + "E+0";
            }
            int n2 = 0;
            if (Math.abs(f) < 1.0f) {
                n2 = 10;
                d = (double)f * 1.0E-10;
            } else {
                n2 = -10;
                d = (double)f * 1.0E10;
            }
            String string = ("" + d).toUpperCase();
            int n3 = string.indexOf("E");
            n2 = Parser.parseInt(string.substring(n3 + 1)) + n2;
            return n3 < 0 ? "" + f : TextFormat.formatDecimal(Parser.parseFloat(string.substring(0, n3)), n - 1) + "E" + (n2 >= 0 ? "+" : "") + n2;
        }
        if (n >= formattingStrings.length) {
            n = formattingStrings.length - 1;
        }
        if ((decimalFormat = formatters[n]) == null) {
            decimalFormat = TextFormat.formatters[n] = new DecimalFormat(formattingStrings[n]);
        }
        String string = decimalFormat.format(f);
        return Boolean.TRUE.equals(useNumberLocalization[0]) ? string : string.replace(',', '.');
    }

    public static String format(float f, int n, int n2, boolean bl, boolean bl2) {
        return TextFormat.format(TextFormat.formatDecimal(f, n2), n, 0, bl, bl2);
    }

    public static String format(String string, int n, int n2, boolean bl, boolean bl2) {
        if (string == null) {
            return "";
        }
        if (n2 != Integer.MAX_VALUE && n2 > 0 && n2 < string.length()) {
            string = string.substring(0, n2);
        } else if (n2 < 0 && -n2 < string.length()) {
            string = string.substring(string.length() + n2);
        }
        int n3 = n - string.length();
        if (n3 <= 0) {
            return string;
        }
        boolean bl3 = bl2 && !bl && string.charAt(0) == '-';
        char c = bl2 ? (char)'0' : ' ';
        char c2 = bl3 ? (char)'-' : c;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(string);
        }
        stringBuffer.append(c2);
        int n4 = n3;
        while (--n4 > 0) {
            stringBuffer.append(c);
        }
        if (!bl) {
            stringBuffer.append(bl3 ? c + string.substring(1) : string);
        }
        return stringBuffer.toString();
    }

    public static String formatString(String string, String string2, String string3) {
        return TextFormat.formatString(string, string2, string3, Float.NaN);
    }

    public static String formatString(String string, String string2, float f) {
        return TextFormat.formatString(string, string2, null, f);
    }

    public static String formatString(String string, String string2, int n) {
        return TextFormat.formatString(string, string2, "" + n, Float.NaN);
    }

    public static String formatString(String string, String string2, String string3, float f) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        if ("".equals(string)) {
            return "";
        }
        int n3 = string2.length();
        if (string.indexOf("%") < 0 || n3 == 0 || string.indexOf(string2) < 0) {
            return string;
        }
        String string4 = "";
        int n4 = 0;
        while ((n2 = string.indexOf(37, n4)) >= 0 && (n = string.indexOf(string2, n2 + 1)) >= 0) {
            if (n4 != n2) {
                string4 = string4 + string.substring(n4, n2);
            }
            n4 = n2 + 1;
            if (n > n2 + 6) {
                string4 = string4 + '%';
                continue;
            }
            try {
                String string5;
                char c;
                boolean bl = false;
                if (string.charAt(n4) == '-') {
                    bl = true;
                    ++n4;
                }
                boolean bl2 = false;
                if (string.charAt(n4) == '0') {
                    bl2 = true;
                    ++n4;
                }
                int n5 = 0;
                while ((c = string.charAt(n4)) >= '0' && c <= '9') {
                    n5 = 10 * n5 + (c - 48);
                    ++n4;
                }
                int n6 = Integer.MAX_VALUE;
                if (string.charAt(n4) == '.' && (c = string.charAt(++n4)) >= '0' && c <= '9') {
                    n6 = c - 48;
                    ++n4;
                }
                if (!(string5 = string.substring(n4, n4 + n3)).equals(string2)) {
                    n4 = n2 + 1;
                    string4 = string4 + '%';
                    continue;
                }
                n4 += n3;
                if (!Float.isNaN(f)) {
                    string4 = string4 + TextFormat.format(f, n5, n6, bl, bl2);
                    continue;
                }
                if (string3 == null) continue;
                string4 = string4 + TextFormat.format(string3, n5, n6, bl, bl2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                n4 = n2;
                break;
            }
        }
        string4 = string4 + string.substring(n4);
        return string4;
    }

    public static String[] split(String string, String string2) {
        int n = 1;
        int n2 = string.indexOf(string2);
        int n3 = string2.length();
        if (n2 < 0 || n3 == 0) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        int n4 = string.length() - n3;
        while (n2 >= 0 && n2 < n4) {
            n2 = string.indexOf(string2, n2 + n3);
            ++n;
        }
        String[] stringArray = new String[n];
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        while ((n5 = string.indexOf(string2, n2)) >= 0 && n6 + 1 < n) {
            stringArray[n6++] = string.substring(n2, n5);
            n2 = n5 + n3;
        }
        if (string.indexOf(string2, n4) != n4) {
            n4 += n3;
        }
        stringArray[n6] = string.substring(n2, n4);
        return stringArray;
    }

    public static String replaceAllCharacters(String string, String string2, String string3) {
        int n = string2.length();
        while (--n >= 0) {
            String string4 = string2.substring(n, n + 1);
            string = TextFormat.simpleReplace(string, string4, string3);
        }
        return string;
    }

    public static String replaceAllCharacters(String string, String string2, char c) {
        int n = string2.length();
        while (--n >= 0) {
            string = string.replace(string2.charAt(n), c);
        }
        return string;
    }

    public static String simpleReplace(String string, String string2, String string3) {
        boolean bl;
        if (string == null || string.indexOf(string2) < 0 || string2.equals(string3)) {
            return string;
        }
        int n = string2.length();
        if (n == 0) {
            return string;
        }
        boolean bl2 = bl = string3.indexOf(string2) >= 0;
        while (string.indexOf(string2) >= 0) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while ((n2 = string.indexOf(string2, n3)) >= 0) {
                stringBuffer.append(string.substring(n3, n2)).append(string3);
                n3 = n2 + n;
            }
            stringBuffer.append(string.substring(n3));
            string = stringBuffer.toString();
            if (!bl) continue;
            break;
        }
        return string;
    }

    public static String trim(String string, String string2) {
        int n;
        int n2;
        int n3 = string2.length();
        if (n3 == 0) {
            return string.trim();
        }
        for (n2 = 0; string.indexOf(string2, n2) == n2; n2 += n3) {
        }
        for (n = string.length() - n3; string.indexOf(string2, n) == n; n -= n3) {
        }
        return string.substring(n2, n + n3);
    }

    public static String[] split(String string, char c) {
        return TextFormat.split(string, "" + c);
    }
}

