//  JmolShell - a platform for preparing Jmol presentations
//  
//  This file forms the basis for JmolShell. It is called by a WEB page that need
//  only include presentation-specific code. It uses the Jmol Java unit and the
//  Jmol.js library code that accompanies Jmol. f
//  
//  JmolShell is written by:
//	
//	Craig T. Martin
//	Dept of Chemistry and of Biochem & Mol Biol
//	University of Massachusetts
//	710 N Pleasant St
//	Amherst, MA 01003
//	(413) 545-3299
//	CTMartin@chem.umass.edu
//	http://www.chem.umass.edu/~cmartin
//  
//  
//  Requires Jmol.js  v10.0.39 or greater
//
//  This version works well in most Mac browsers!
//

var JmolShellUpdate = "Dec 9, 2007 11:23pm";

//Global variables
var TagLine = "",			authorG = "Bozo";
var CitationG = "J Irreprod Res 00, 123";
var PubMedIDG = "000",		LastUpdatedG = "1/01/1901";
var jHgt = 300, jWid = 300;
var ResetFileG = "Reset.spt";
var RecOn = "false";
var LastMsgSet = "";
var WaitingForO = "false";
var CaptureMsgs = "false";
var MsgStore = "";
var JmolDebugStatus = false;
var OneLineCmdBarG = false;
var Processing = true;
var PDBid = "";
var StDescr = "";
var st_JmolApp = "";
var pdbFileG = "";
var scrptfileG = "";
var LeftPanelWidthG = "";
var SupportPathG = "";
var PDBDataWindow = null;

// Constants for external links
//var JmolMainPage = "http://www.Jmol.org";
var JmolMainPage = "http://jmol.sourceforge.net";
var JmolShellMainPage = "http://people.chem.umass.edu/cmartin/Jmol";
var JmolJSPage = "http://jmol.sourceforge.net/jslibrary";
var JmolHelp = "http://chemapps.stolaf.edu/jmol/docs/";

var JmolWiki = "http://wiki.jmol.org:81";
var MouseHelp = "http://wiki.jmol.org/MouseManual";
var CHIMEHelp = "http://www.umass.edu/microbio/chime/manual/chimeman.htm#chcomref";
var RasmolHelp = "http://www.openrasmol.org/doc/#chcomref";
var PDB_Search = "http://pdbbeta.rcsb.org/pdb/explore.do?structureId=";

var BigMemory = "";
var DivMemory = "";
var NewDebug = false;
var DivDebug = false;

// A script to execute at startup
var StartUpScript = "set measurement angstroms";

// Constants for "design"
var FontSzG = 12;
var fntstyl = " style=\'font-size: " + (FontSzG-2)+ "px;\'";
var fntstylTiny = " style=\'font-size: " + (FontSzG-3)+ "px;\'";
var colWid = 38; colRows = 13;

// Constants for HTML formatting
var CrLf = "\n";
var HRSm = "\n\n<HR size=\"2\" >";
var HRBg = "\n\n<HR size=\"4\" >";
var Spc3 = "&nbsp;&nbsp;&nbsp;";
var Spc2 = "&nbsp;&nbsp;";
var br = "\n\n<br>";
var p = "\n\n<P>";
var HR = "\n\n<HR>";
var endDIV = "</DIV>\n\n";

// Constants for Form Select elements
var ColorOptions = "Color:"
		+ ",cpk,Red,Orange,Yellow,Green,Blue,Cyan,Violet,Brown"
		+ ",Magenta,Pink,LightGreen,LightBlue,LightYellow,Gray,Black,White,Purple";
		
var aaOptions = "aa:"
		+ ",Asn,Gln,Asp,Glu,Arg,Lys,Gly,Ala,Val,Ile,Leu,Thr"
		+ ",Phe,Tyr,Trp,Pro,Met,Ser,Thr,Cys,His,Cystine,-----"
		+ ",Hydrophobic,Neutral,Polar,Charged,Acidic,Basic,Amino,Aromatic"
		+ ",Aliphatic,Hydrogen";
		
var aaWhatOptions = "where:"
		+ ",Bonded,Ligand,Surface,Buried";
		
var typeOptions = "Type:,Protein,Nucleic,Solvent,Water,Hetero,Ions"

var ScndryOptions = "2ndry:,Helix,Sheet,Turn";
var BBOptions = "BB:,Backbone,Sidechain";
var nucleicOptions = "DNA:,AT,CG,A,C,G,T,U,Pyrimidine,Purine";

// Global variables that will change (but don't touch)
 var RecentPicks = [0,0,0,0];
 var UserMenuList = [];
 var UserDscr = [];
 var MainMenuList = [];
 var TestBedSelectionStart = 0;
 var TestBedSelectionEnd = 0;

 var sideBarWid = 290;  // Gets reset later
 var cmdHgt = (navigator.userAgent.indexOf("Safari")!=-1) ? 155 : 100;

 var DivList = new Array;
 var LastUserDiv = "";

 var AuthorMenuList = ["Feedback","Test Bed","Preview"];
 var AuthorMenuDscr = [
	"Allows recording of script commands and provides feedback from script calls",
	"A place for you to write HTML code, which can then be previewed in the Preview panel. Copy text from here to your HTML (text) file"
	+ " (warning: this is still under development. so copy over often and expect some crashes)",
	"Preview the web page generated by your Test Bed code (warning: this is still under development)"];
 var LastAuthorDiv = AuthorMenuList[0];

 var DebugDivHTML = 
	"<FORM ID='DebugDivForm' NAME='DebugDivForm'>" +
	"<TEXTAREA NAME='DebugDivField' ROWS='80' COLS='1000'></TEXTAREA>" +
	"</FORM>";
	
//=================================

// Function for writing form elements

function FormButtonTag(nam,onClk,clss) {
	return "<input type=\"button\" value=\"" + nam + "\""
			+ "onclick=\"" + onClk +  "\" class=\"" + clss + "\">"
}

function FormCheckBoxTag(CheckBoxName,CheckBoxLabel,onClk,clss,chckd) {
	var st = "<input name=\"" + CheckBoxName + "\" type=\"checkbox\" value=\"" + chkcd + "\""
			+ " onClick=\"" + onClk + "\"";
	if (clss) st += " class="+clss;
	st += ">"+ CheckBoxLabel + Spc3
}

//==============  Menu item  CMD  =============

function runonecmd()
{	run(document.onecmdbox.onecmd.value);
	document.onecmdbox.onecmd.value = "";
}

function runcline()
{	//alert(document.clinesolo.onecmd2.value);
	run(document.clinesolo.onecmd2.value);
	document.clinesolo.onecmd2.value = "";
}

// Note that this set of scripts uses routines defined in Jmol.js

// ======== Define some static WEB "pages" for later loading =========

// A command line BOX for multiple commands
//  Future: make this of dynamic width & height, turn it into a function call
//  Future: include message box and command history box
var OneCmdBoxHint = "Enter single Jmol script command here";
var MultiCmdBoxHint = "Enter multiple Jmol commands here - then press Test";

// Used below - this is the "Insert HTML code" drop-down menu in Test Bed
var MakeHTMMenuContent = [
	["Insert HTML code","",true],
	["-",""],
	["Link","Link"],
	["Button","Button"],
	["Check Box","Checkbox"],
	["-",""],
	["Distance measure","Distance"],
	["Angle measure","Angle"],
	["Dihedral measure","Dihedral"],
	["-",""],
	["New tab","NewTab"],
	["-",""],
	["New paragraph","NewParagraph"],
	["New line","NewLine"],
	["-",""],
	["Blank starting page","JmolShellGenerator"]
];
	
var CmdLineHTML = ""
	//CmdLineHTML += "<form name=\"onecmdbox\" action=\"javascript:runonecmd()\"><p>"
	//+ "<input autocomplete=\"off\" id=\"onecmd\" size=\"38\" value=\""+OneCmdBoxHint+"\" type=\"text\" "
	//+ "promptValue=\""+OneCmdBoxHint+"\">"
	//+ "</form>" + "<hr>"

	+ "<B>Enter a multi-line "
	+ LinkTag(JmolHelp,"CHIMECommands","Jmol","Click here for help with commands") 
		+ " script here</B> (<A HREF=\"javascript:LaunchHelp()\">Help</A>):"
	+ br + "<form name=\"CmdBoxForm\">"
		+ ClearTag()
		+ FormButtonTag("Test","run(document.CmdBoxForm.scriptBox.value)","formstyl") 
		+ Spc3 + FormButtonTag(";","ToggleCmdBx()","formstyl") 
		+ Spc3 + "<select class=\"formstyl\" name=\"Jm\" width=\"30\" onChange=\"MakeJmolCode(this.form.Jm.value)\">"
			+ "<option value = \"\" selected>Insert Jmol command</option>"
			+ "<option value = \"\"> - </option>"
			+ "<option value = \"OrientInfo\" title=\"Insert the MoveTo command to set to the current view\"> Current view </option>"
			+ "</select>"
		+ "\n<textarea name=\"scriptBox\" "
			+ " cols=\"" + colWid + "\" rows=\"" + colRows + "\" " + fntstyl +
			+ " promptValue=\""+ MultiCmdBoxHint +"\"></textarea>"
	+ "</form>"
	
	// * The following is in development - trying to make this content swap with as yet un-added content
	//      by making one big DIV, containing overlapping alternate DIVs, as for UserDivs
	
	// WriteMenu(MenuName,MenuClass,MenuItems,DescItems,MenuScript)
	+ "<hr>" + GetMenu("AuthorMenuDiv","AuthorMenuClass",AuthorMenuList,AuthorMenuDscr,"ShowAuthorDiv")
	+ DivStartTagC("AuthorPanelDiv", "AuthorParent")
	+ DivStartTagC(AuthorMenuList[0], "AuthorContent")
	+ "Command record".bold()
	+ br + "<form name=\"history\">"
		+ ClearTag()
		+ "<input name=\"ScriptRecordOn\" type=\"checkbox\" value=\"true\""
			+ " onClick=\"SetRecStatus()\"> Record commands"+ Spc3
		+ FormButtonTag(";","ToggleHist()","formstyl") 
		+ br
		+ "<textarea name=\"historyBox\"  value=\"\""
		+ "  cols=" + colWid + " rows=" + (colRows-2) + fntstyl + "></textarea>"
	+ "</form>"
		
	+ br + "<form name=\"Feedback\">"
	+ "Feedback".bold() + " (newest at top)"
		+ ClearTag()
		+ br
		+ "<textarea name=\"Messages\"  value=\"\""
		+ "  cols=" + colWid + " rows=" + (colRows-5) + fntstyl + "></textarea>"
	+ "<br></form>"
	+ DivEndTagC()

	+ DivStartTagC(AuthorMenuList[1], "AuthorContent")
	+ "<Form id=\"TestBedCode\" name=\"TestBedCode\">"
		+ Spc3 + DropDownMenu("HTM",MakeHTMMenuContent,"MakeHTMLCode(this.form.HTM.value)","formstyl","","30")
		+ "&nbsp;<A HREF=\"javascript:LaunchHelp()\" TARGET=\"_blank\" TITLE=\"Click here for help using this section\"><B>?</B></A>"
		+ br
	+ "<textarea name=\"TestBedBox\"  value=\"Enter HTML code here\""
			+ "  cols=" + colWid + " rows=30  "
			+ "onBlur=\"getTestBedSelection(document.TestBedCode.TestBedBox)\""
			+ fntstyl + "></textarea>"
	+"</Form>"
	+ DivEndTagC()

	+ DivStartTagC(AuthorMenuList[2], "AuthorContent")
	+ DivEndTagC()
	+ DivEndTagC()
	;
	
//  optionlist is an array of an array
//   the second level arrays contains in order: menu line, value returned, selected
//   if formName is specified, then the item is wrapped in a form tag
function DropDownMenu(tagName,optionlist,jsCode,tagClass,formName,tagWidth) {
	var st = (formName) ? "<Form id=\""+formName+"\" name=\""+formName+"\">\n" : "";
	st += Spc3 + "<select ";
	if (tagClass) st += "class=\""+tagClass+"\" ";
	st += "name=\""+tagName+"\" ";
	if (tagWidth) st += "width=\""+tagWidth+"\" ";
	if (jsCode) st += "onChange=\""+jsCode+"\" ";
	st += ">";
    for (var i=0; i<optionlist.length; i++){
		st += "\n<option value = \""+optionlist[i][1]+"\"";
		if (optionlist[i][2]) st += " SELECTED";
		st += ">"+optionlist[i][0]+"</option>";
	}
	st += "\n</select>";
	if (formName) st += "</Form>";
	return st;
}

// ---------------------------------------------------------------------

// A help window
var HelpHTML = "This " + LinkTag(JmolShellMainPage,"JmolShell","JmolShell","Click here to learn more about JmolShell")
	+ " presentation made possible by "
	+ LinkTag(JmolMainPage,"JmolSrc","Jmol","Click here to learn more about Jmol") 
		+ ", an open-source project. "
	+ LinkTag(JmolHelp,"JmolHelp","Scripting commands","Click here for help with Jmol commands")
		+ " follow those of " 
	+ LinkTag(RasmolHelp,"RasmolHelp","Rasmol","Click here for Rasmol help") + "/" 
	+ LinkTag(CHIMEHelp,"CHIMEHelp","CHIME.","Click here for CHIME help")
	+ " (see also the " + LinkTag(JmolWiki,"Jmol Wiki","Jmol Wiki","Click here for help in Wiki format") + ")."
	+ HR + "The Jmol "
	+ LinkTag(MouseHelp,"MouseHelp","mouse gestures","Click here to learn more about mouse gestures") 
	+ " are designed to function with single-button mice"
		+ " on the Mac. All references to 'left' get translated to 'only'"

	+ "<table border=\"1\" cellspacing=\"2\" cellpadding=\"1\">"
		+ GetTblRw("rotate X and Y axes","left drag")
		+ GetTblRw("zoom + rotate Z axis","shift left drag<br> OR middle button drag")
		+ GetTblRw("rotate Z axis only","shift right drag")
		+ GetTblRw("translate X and Y axes","shift double left drag<br> OR double middle drag")
			+ GetTblRw("reset to center","shift double left click<br> OR double middle click")
		+ GetTblRw("wheel - zoom","a wheel is also a middle button if clicked/dragged")
		+ GetTblRw("popup menu","right click<br> OR ctrl left click")
	+ "</table>"

	+ "\n\n<H3>To measure distances and angles</H3>"
	+ "Double click, optionally single click 0, 1, or 2 times, Double click"

	+ "<p>After your first double-click the cursor will change and then you can"
		+ "\'hover\' over several different atoms to get different distances."

	+ "<p>Move outside the applet to cancel the measurement."

	+ "<p>For a distance measurment:"

	+ "<p>double click to drop an anchor"
	+ "<br>double click on the destination"

	+ "<p>For an angle measurement:"

	+ "<p>double click to drop an anchor"
	+ "<br>single click on an intermediate point"
	+ "<br>double click on the final point"

	+ "<p>For a torsion measurement:"

	+ "<p>double click to drop anchor"
	+ "<br>single click"
	+ "<br>single click"
	+ "<br>double click"
	
	+ "\n\n<H3>Selection examples</H3>"
	+ "Select:"
	+ "<TABLE BORDER=\"0\" CELLSPACING=\"2\" CELLPADDING=\"1\">"
	+ "<TR>" + "<TD width=70>:G</TD>" + "<TD>Chain G</TD>" + "</TR>"
	+ "<TR>" + "<TD>145:G</TD>" + "<TD>Residue 145 of Chain G</TD>" + "</TR>"
	+ "<TR>" + "<TD>45-50:G</TD>" + "<TD>Residues 45 to 50 of Chain G</TD>" + "</TR>"
	+ "<TR>" + "<TD>*.CA</TD>" + "<TD>all c-alphas</TD>" + "</TR>"
	+ "<TR>" + "<TD>[Cys].CA</TD>" + "<TD>all Cys c-alphas</TD>" + "</TR>"
	+ "<TR>" + "<TD>[Cys]:A.CA</TD>" + "<TD>all Cys c-alphas in Chain A</TD>" + "</TR>"
	+ "</TABLE>"
	
	;

// ---------------------------------------------------------------------

// An "About" window - dynamic!
//	This takes information from the user, combined with info from this shell
//		and presents it all in a uniform format
function jAbout()
{
	return "Literature reference for the structure:<br>" +
		LinkTag("http://www.ncbi.nlm.nih.gov:80/entrez/query.fcgi?cmd=Retrieve" +
		"&db=PubMed&list_uids=" + PubMedIDG + "&dopt=Abstract",
		"PubMedW",CitationG,"Click here to go to PubMed entry")  +

	
	HR + "Presentation by " + AuthorG + "<br>Last updated: " + LastUpdatedG +

 		p + "(JmolShell last updated: " + JmolShellUpdate + ")" +

	HR + "This " + LinkTag(JmolShellMainPage,"JmolShell","JmolShell","Click here to learn more about JmolShell")
		+ " presentation made possible by " + 
		LinkTag(JmolMainPage,"JmolSrc","Jmol","Click here to go to Jmol main page")
			+ ", an open-source project, " +
		"using a set of JavaScript functions provided in the library " + 
		LinkTag(JmolJSPage,"JmolLib","Jmol.js",
			"Click here to go to Jmol javascript library page") + 

		p + "Developed using " + "JmolShell" + ", by " + 
		LinkTag("http://www.chem.umass.edu/people/cmartin","CTM","Craig Martin",
			"Click here to go to his home page at UMass") + ", " +
		EMailTag("cmartin","chem.umass.edu") + ", " +
		"Department of Chemistry, University of Massachusetts, Amherst, MA" +
		
	
	"<FORM ID=\"MolecInfo\" NAME=\"MolecInfo\">" +	
	HR + "Molecule info: " + br +
	FormButtonTag("PDB Header","DisplayPDBData('fileHeader')","formstyl") +
	FormButtonTag("PDB Data","DisplayPDBData('fileContents')","formstyl") +
	FormButtonTag("Chains","DisplayPDBData('chainInfo')","formstyl") + br +
	FormButtonTag("Status","DisplayPDBData('appletInfo')","formstyl") +
	FormButtonTag("Machine Info","DisplayMachineInfo()","formstyl") +	
	FormButtonTag("Resize Panel","ReSizeLeftPanel()","formstyl") +	
	//FormButtonTag("DIVs","LoopThruElems('DIV')","formstyl") +	
	//FormButtonTag("SPANs","LoopThruElems('SPAN')","formstyl") +	
	//FormButtonTag("JPG","DisplayJPG()","formstyl") +
	"</FORM>";
}

// Open a new window and fill it with useful information
function DisplayPDBData(getData) {
	if (PDBDataWindow) 
		{ PDBDataWindow.close();
		  PDBDataWindow = null; }
	PDBDataWindow = window.open('','PDBDataWindow','location=no,width=650,height=500,title=Bobo,toolbar=no,scrollbars=no,resizable=yes');
	PDBDataWindow.document.write("<style> .MonoClass {font-family: Monaco, Courier, Courier New; } </style><BODY>"
		+ "<FORM ID=\"PDBContents\" NAME=\"PDBContents\">"
		+ "<TEXTAREA NAME=\"FileContents\" CLASS=\"MonoClass\" ROWS=\"30\" COLS=\"82\"></TEXTAREA>"
		+ "</FORM></BODY>");
	if (PDBDataWindow.PDBContents) PDBDataWindow.PDBContents.FileContents.value = jmolGetPropertyAsString(getData)
	else 
		{ PDBDataWindow.close();
		alert("Not supported in this browswer");
		}
}

function DisplayMachineInfo() {
	if (PDBDataWindow) 
		{ PDBDataWindow.close();
		  PDBDataWindow = null; }
	PDBDataWindow = window.open("","PDBDataWindow","location=no, width=650 height=500 title=\"Bobo\" toolbar=no, scrollbars=no, resizable=yes");
	PDBDataWindow.document.write("<style> .MonoClass {font-family: Monaco, Courier, Courier New; } </style><BODY>"
		+ "<FORM ID=\"PDBContents\" NAME=\"PDBContents\">"
		+ "<TEXTAREA NAME=\"FileContents\" CLASS=\"MonoClass\" ROWS=\"30\" COLS=\"82\"></TEXTAREA>"
		+ "</FORM></BODY>");
		var st = "AppCodeName: " + navigator.appCodeName +
		"\nAppName: " + navigator.appName +
		"\nAppVersion: " + navigator.appVersion +
		"\nUserAgent: " + navigator.userAgent +
		"\nPlatform: " + navigator.platform + 
//		"\nJava version " + java.lang.System.getProperty("java.version") + 
        "\nJava enabled: " + navigator.javaEnabled() + 
		"\nDocPath " + document.location.pathname + 
		"\nHostPath: " + document.location.host;
	if (PDBDataWindow.PDBContents) PDBDataWindow.PDBContents.FileContents.value = st
	else { PDBDataWindow.close();
		alert(st);
		}
}

// Not yet tested. Requires Jmol 11.4
function DisplayJPG() {
	JPGWindow = window.open("","JPGWindow","location=no, width=650 height=500 toolbar=no, scrollbars=no, resizable=yes");
	alert("window created");
	JPGWindow.document.write("<BODY>"
		+"<IMG SRC=\"data:image/jpeg;base64,"+jmolGetProperty("image")+"\">"
		+ "</BODY>");
}

// Make HTML code for pasting into a user-scripted presentation
//  This popup sits above the multi-command entry box and provides help for users
//  who are creating their own presentations. Button and link take the current command
//  set and wrap them in the appropriate function call. Distance, angle, and dihedral
//  take info from the last 2/3/4 user clicks and generate a toggle to turn off the
//  the appropriate displays. 
function MakeHTMLCode(CntrlType)
{	if (CntrlType=="") { return null };

	var st = "";
	if (CntrlType=="JmolShellGenerator")
		{ window.open(SupportPathG+"JmolShellGenerator.html","GeneratorWindow");
		   document.TestBedCode.HTM[0].selected = true;
		  return null; }

	if ((CntrlType=="NewLine") || (CntrlType=="NewParagraph")) {		
		if (CntrlType=="NewLine")  st = "\n<br>"; 
		if (CntrlType=="NewParagraph")  st = "\n<p>";
	} else {
		// Grab a label from selected text. Otherwise ask user.
		with (document.TestBedCode) {
			var Lbl = (TestBedSelectionStart==TestBedSelectionEnd) ?
				prompt("Enter the text for your "+CntrlType,CntrlType+" text") :
				TestBedBox.value.substring(TestBedSelectionStart,TestBedSelectionEnd);
			}

		// Grab the script from the multi-line script box. Then process it to one line
		if ((CntrlType=="Link") || (CntrlType=="Button") || (CntrlType=="CheckBox")) {
			var scrp = ReplaceAll(document.CmdBoxForm.scriptBox.value,CrLf,";");
			scrp = ReplaceAll(scrp,"\r",";");
			scrp = ReplaceAll(scrp,"\n",";");
		
			if (CntrlType=="CheckBox") {
				var AltScript = prompt("Alter the following script to NEGATE its effect (to be executed when the check box is unchecked)",scrp);
				st = "jmolCheckbox(\"" + scrp + "\", \"" + AltScript + "\", \"" + Lbl + "\")"
			} else {
				st = (CntrlType=="Link") ? "jmolLink(\"" + scrp + "\", \"" + Lbl + "\")" : "jmolButton(\"" + scrp + "\", \"" + Lbl + "\")";
			}
		}
		 else
		
		// Or grab coordinates from recent clicks and process them into a distance measurent
		{	if (CntrlType=="Distance")
				st = "ToggleMeasure(\"" + Lbl + "\",0," + RecentPicks[0] + "," + RecentPicks[1] + ")";
			if (CntrlType=="Angle")
				st = "ToggleMeasure(\"" + Lbl + "\",0," + RecentPicks[0] + "," + RecentPicks[1] + "," + RecentPicks[2] + ")";
			if (CntrlType=="Dihedral")
				st = "ToggleMeasure(\"" + Lbl + "\",0," + RecentPicks[0] + "," + RecentPicks[1] + "," + RecentPicks[2] + "," + RecentPicks[3] + ")";
			if (CntrlType=="NewTab")
				{ var LblMore = prompt("Enter more descriptive text telling the user what this tab will reveal","The " +Lbl+" tab details xxx");
				  st = "StartNewDiv(\"" + Lbl + "\",\"" + LblMore + "\")";
				  alert("Warning: do not try and preview text with this function call in it - it will likely crash preview. "
					+ "Copy it over to your HTML file. It should work fine there") }
		}
	
	// If Javascript, wrap it in the appropriate tag
	st = "<scri" + "pt>" + st + "</scri" + "pt>";
	
	}
	
	// Find out where to put it
	if (TestBedSelectionStart>=0) {
		with (document.TestBedCode) 
			TestBedBox.value = TestBedBox.value.substring(0,TestBedSelectionStart) + st 
				+ TestBedBox.value.substring(TestBedSelectionEnd,TestBedBox.value.length);
		// Unselect...
		TestBedSelectionStart += st.length;
		TestBedSelectionEnd = TestBedSelectionStart;
	} else {
		var xxx = prompt("Copy the following and paste it into your HTML file",st);
	}
	//Reset menu to top
	document.TestBedCode.HTM[0].selected = true;
}

function getTestBedSelection(txtarea) {
	TestBedSelectionStart = txtarea.selectionStart;
	TestBedSelectionEnd = txtarea.selectionEnd;
}

function LaunchHelp() {
	window.open(SupportPathG+"Help/JmolShell_CMD_Help.html","HelpWindow");
}

function MakeJmolCode(CntrlType)
{	if (CntrlType=="") { return null };

	var st = "";
	if (CntrlType=="OrientInfo")
		{ var orientinfo = new Array();
		  orientinfo = jmolGetPropertyAsArray("orientationInfo");
		  st = orientinfo.moveTo }
	
	// Add to the end of the script box
	document.CmdBoxForm.scriptBox.value += "\n" + st;
	
	//Reset menu to top
	document.CmdBoxForm.Jm[0].selected = true;
}


// ---------------------------------------------------------------------

// To Do: Include support for MoveTo
//   	Note:	show axisangle
//		yields:	axis-angle rotation = -0.37671968 0.7977311 -0.47085804 84.490776

var PresetsHTML = "Use the following to execute Jmol commands:".bold()
	+ p
	
	+ "<form name=\"SelectForm\" >" + ClearTag() + br
		+ "<B>Select</B>:" + Spc3
		+ SelectTag("aaList","DoSelectForm",aaOptions)
		+ SelectTag("aaWhatList","DoSelectForm",aaWhatOptions)
		+ SelectTag("Secondary","DoSelectForm",ScndryOptions)
		+ Spc3
		+ SelectTag("BBSide","DoSelectForm",BBOptions)
		+ SelectTag("AClass","DoSelectForm",typeOptions)
		+ SelectTag("Nucleic","DoSelectForm",nucleicOptions)
		+ FormButtonTag("Last clicked","DoSelectClicked()","formstyl")
		+ br + Spc3	
		+ "Chain " + InputTextTag("Chain","DoSelectForm",fntstyl,1,1)
		+ Spc3 + "Res No " + InputTextTag("ResNo","DoSelectForm",fntstyl,4,7)
		+ Spc3 + "Atom No " + InputTextTag("AtomNo","DoSelectForm",fntstyl,5,10)
		+ br
		+ FormButtonTag("Do","DoSelectForm();run(document.SelectForm.selecttxt.value)","formstyl")
		+ InputTextTag("selecttxt","",fntstyl,30,200)
		+ p + Spc2 + "Find within "
		+ InputTextTag("DstAng","DoWithinForm",fntstyl,3,7)
		+ " &#197; of the above selection"
		+ br + Spc2 + FormButtonTag("Do","DoWithinForm();run(document.SelectForm.withintxt.value)","formstyl")
		+ InputTextTag("withintxt","",fntstyl,30,200)
	+ "</form>"
		
	+ HRSm
	
	+ "<form name=\"ApplyForm\" action='Do'>" + ClearTag()
		+ "<B>Apply</B>: " + Spc3
		+"Wireframe " + InputTextTag("wireframe","DoApplyForm",fntstyl,3,8) +Spc3+Spc3
		+ SelectTag("Color","DoApplyForm",ColorOptions)
		
		+ br + "Rocket " + InputTextTag("rocket","DoApplyForm",fntstyl,4,8) + Spc3
		+ Spc3 + Spc3 + "Cartoon " + InputTextTag("cartoon","DoApplyForm",fntstyl,4,8) + Spc3 
		+ InputTextToggle("Transluc","DoApplyForm",fntstyl) + "Transluc" 
		+ br + "Backbone " + InputTextTag("backbone","DoApplyForm",fntstyl,4,8) + Spc3
		+"Ribbon " + InputTextTag("ribbon","DoApplyForm",fntstyl,4,8) 
		+ br + "Spacefill " + InputTextTag("spacefill","DoApplyForm",fntstyl,3,8) + Spc3
		+"Dots " + InputTextTag("dots","DoApplyForm",fntstyl,4,8) + Spc3
		+"Halos " + InputTextTag("halos","DoApplyForm",fntstyl,4,8) + Spc3 
		+ "<br>" + FormButtonTag("Do","DoApplyForm();run(document.ApplyForm.selecttxt.value)","formstyl")
		+ InputTextTag("selecttxt","",fntstyl,30,200)
	+ "</form>"
	
	+ HRBg
	
	+ "<form name=\"EnviroForm\" action=\"\">" + ClearTag()
		+ "<B>Global</B>:"

		+ br + Spc3 + "<B>Stereo</B>:<br>" + Spc3
			+ Spc2 + InputRadio("StereoView","","DoEnviroForm","Checked",fntstyl) + "None"
			+ Spc2 + InputRadio("StereoView","off","DoEnviroForm","",fntstyl) + "Off"
			+ Spc2 + InputRadio("StereoView","-5","DoEnviroForm","",fntstyl) + "cross-eyed"
			+ Spc2 + InputRadio("StereoView","5","DoEnviroForm","",fntstyl) + "wall-eyed"

		+ br + Spc3+"Bkgrnd "
		+ SelectTag("background","DoEnviroForm",ColorOptions)
		+ Spc3+"HBonds " + InputTextTag("hbonds","DoEnviroForm",fntstyl,4,8)
	
		+ br + "<input name=\"ShowOr\" type=\"checkbox\" "
			+ " onClick=\"SetShowOr()\"> Rotate to current view"
			//+ " in " + InputTextTag("Rtime","DoEnviroForm",fntstyl,3,4) + "sec"
		
		+ br + InputTextTag("CurrOr","DoEnviroForm",fntstyl,30,500) 

		+ "<br>" + FormButtonTag("Do","DoEnviroForm();run(document.EnviroForm.selecttxt.value)","formstyl")
		+ InputTextTag("selecttxt","",fntstyl,30,500)
	+ "</form>"
	;
	
// ========== Functions for the Cmd side-bar ===========

// Used by DoApplyForm (only)
function AddOpt(val,st,prop)
{ if (val != "") st += (st != "")  ?  ";"+prop+" "+val  :  prop+" "+val;
  return st
}

// Used by DoSelectForm (only)
function AddOptB(val,st,prefx)
{  if ((val.indexOf(":") == -1)&&(val!="")) st += (st != "")  ?  " and "+prefx+val  :  prefx+val;
  return st;
}

// Used by EnviroForm (only)
function SetShowOr()
{  with (document.EnviroForm) {
  if (ShowOr.checked)
	{ SetCurrOr() }
  else
	{ CurrOr.value = "" }
  }
  DoEnviroForm();
}

// Used by EnviroForm (only)
function SetCurrOr()
{  with (document.EnviroForm) {
	// issue a Jmol command and wait for the return
	CurrOr.value = "...thinking";
	WaitingForO = "true";
	run("show orientation");
	
  	//var orientationInfo = jmolGetPropertyAsArray("orientationInfo");
	//alert(orientationInfo);
	//orientationInfo.moveTo="moveto 1.0 -345 -938 -23 64.8;"
	//orientationInfo.rotateZYZ="reset; rotate z -160.7; rotate y 64.8;  
	//rotate z 159.0;"
	//orientationInfo.transYPercent=0
	//orientationInfo.transXPercent=0
	//orientationInfo.zoom=100
	
	
	// This function is completed by the event handler showmsg
  }
}

// Process the Environment part of the form, filling in the text box with Jmol script
function DoEnviroForm()
{ var st = "";
  var i=0;
  with (document.EnviroForm) {
  	with (background) {if (value != "") if (value.indexOf(":") == -1) st += (st != "") ? ";" + "background "+value : "background "+value};
 	with (hbonds) { st = AddOpt(value,st,"hbonds") };
	
	stereosetting = "";
	for (i=0;i<StereoView.length;i++)
		{ if (StereoView[i].checked) {stereosetting = StereoView[i].value } }
 	st = AddOpt(stereosetting,st,"stereo");

	if (ShowOr.checked) {
		if (st != "") st += ";";
		st += CurrOr.value;
		};
	selecttxt.value = st;
  };
}

// Process the Apply part of the form, filling in the text box with Jmol script
function DoApplyForm()
{
  var st = "";
  with (document.ApplyForm) {
  	st = AddOpt(wireframe.value,st,"wireframe");
  	st = AddOpt(spacefill.value,st,"spacefill");
  	st = AddOpt(dots.value,st,"dots");
  	st = AddOpt(backbone.value,st,"backbone");
	st = AddOpt(cartoon.value,st,"cartoon");
	st = AddOpt(rocket.value,st,"rocket");
	if (Transluc.checked) 
		{ if (cartoon.value=="") { st = AddOpt("on",st,"cartoon") };
		  st = AddOpt("translucent",st,"color cartoons ");
		};
  	st = AddOpt(ribbon.value,st,"ribbon");  	
  	st = AddOpt(halos.value,st,"halos");
  	with (Color) {if (value != "") if (value.indexOf(":") == -1)
		st += (st != "") ? ";" + "color "+value : "color "+value};
	selecttxt.value = st;
  };
}

// Process the Select part of the form, filling in the text box with Jmol script
function DoSelectForm()
{
  var st = "";
  with (document.SelectForm) {
	st = AddOptB(aaList.value,st,"");
	st = AddOptB(aaWhatList.value,st,"");
	st = AddOptB(Secondary.value,st,"");
	st = AddOptB(BBSide.value,st,"");
	st = AddOptB(AClass.value,st,"");
	st = AddOptB(Nucleic.value,st,"");
	st = AddOptB(Chain.value,st,"*");
	st = AddOptB(ResNo.value,st,"");
	st = AddOptB(AtomNo.value,st,"atomno=");
  	selecttxt.value = (st != "") ? st = "Select " + st  :  "";
  };
  DoWithinForm();
}

// Process the Select part of the form, filling in the text box with Jmol script
function DoWithinForm()
{
  with (document.SelectForm) {
	if ((selecttxt.value=="") || (DstAng.value=="")) {
		st = ""
	} else {
		SelArg = selecttxt.value.substr(6,selecttxt.value.length-5);
  		st = "Select within(" + DstAng.value + "," + SelArg + ") and not (" + SelArg + ")";
	}
	withintxt.value = st;
  };
}

function DoSelectClicked()
{
  with (document.SelectForm) {
	selecttxt.value="select atomno="+RecentPicks[0];
  };
}

// In command history box, within Cmd, respond to checkbox
function SetRecStatus()
{ ScriptRecOn = document.history.ScriptRecordOn.checked; }

function ReplaceAll(st,stold,stnew)
{	var indx = st.indexOf(stold);
	while (indx != -1)
		{ st = st.replace(stold,stnew);
		  indx = st.indexOf(stold); };
	return st;
}

function ToggleHist()
{ with (document.history.historyBox) {
if (value.indexOf(";") != -1)
 {	value = ReplaceAll(value,";",CrLf)
   } else {
	value = ReplaceAll(value,CrLf,";");
	value = ReplaceAll(value,"\r",";");
	value = ReplaceAll(value,"\n",";");
}  }	}

function ToggleCmdBx()
{ with (document.CmdBoxForm.scriptBox) {
if (value.indexOf(";") != -1)
 {	value = ReplaceAll(value,";",CrLf)
   } else {
	value = ReplaceAll(value,CrLf,";");
	value = ReplaceAll(value,"\r",";");
	value = ReplaceAll(value,"\n",";");
}  }	}

// The following allows for form fields to have default values that 
//   are automatically blanked out on user entry. The class is also changed
//   so that text style or color can change as well.
//   When setting up a field, include "prompt value" as promptValue
function SetUpFields(fType) {
    if (!document.getElementsByTagName){ return; }
    var allfields = document.getElementsByTagName(fType);

    // loop through all input tags and add events
    for (var i=0; i<allfields.length; i++){
		var field = allfields[i];
		if (field.getAttribute("promptValue"))  {
		  field.value = field.getAttribute("promptValue");
		  field.className = "PromptFieldClass";
   		  field.onfocus = function () { if (this.value == this.getAttribute('promptValue'))
			{this.value = ''; this.className = 'FilledFieldClass'} }
       }
    }
}


// The following two functions work together and are for debugging only...
// For debugging only (temporary)
function SetDivBgColor(dvNm,clr) {
  if (GetObj(dvNm)) {
   with (GetObj(dvNm).style) {
	var vis_store = visibility;
	var bg_store = backgroundColor;
	var bwid_store = borderWidth;
	var bsty_store = borderStyle;
	visibility = true;
	backgroundColor = clr;
	borderWidth = "2px"; 
	borderStyle = "solid";
	alert("Changing the color of "+dvNm+" to " + clr);
	backgroundColor = bg_store; 
	visibility = vis_store;
	borderWidth = bwid_store;
	borderStyle = bsty_store;
	} } else {
	alert("Cannot find "+dvNm+" element")}
}

//border-width: 2pxpx;
//border-style: solid;


function LoopThruElems(objectTyp) {
    if (!document.getElementsByTagName){ return; }
    var allfields = document.getElementsByTagName(objectTyp);
	alert(allfields.length + " "+objectTyp+"s found");

    // loop through all input tags and add events
    for (var i=0; i<allfields.length; i++){
		var field = allfields[i];
		SetDivBgColor(field.id,"red");
    }
}

// ========== Functions for the Help side-bar ===========

// Used by HelpHTML definition (only)
function GetTblRw(txt1,txt2)
{
return "<tr align=\"left\" valign=\"top\">"
	+ "<td>" + txt1 + "</td>"
	+ "<td>" + txt2 + "</td>"
	+ "</tr>";
}

// ========== Functions to toggle the side-bars ===========

// Used to reference dHTML elements browser-specifically 
function GetObj(id) {
  if (document.layers)	{ path = document.layers[id] }
  else if (document.all)	{ path = document.all[id] }
  else	if (document.getElementById)	{ path = document.getElementById(id) }
  else alert("Error getting object - browser not supported!");
  return path
}

// Sets individual DIV visibility (true = visible)
function SetVisibility(velement,vstatus) {
   if (GetObj(velement)) 
	  { GetObj(velement).style.visibility = (vstatus) ? "visible" : "hidden"; }
}

// Sets individual DIV visibility (true = visible)
function SetYScroll(velement,sstatus) {
   if (GetObj(velement)) 
	  { GetObj(velement).style.overflow = (sstatus) ? "auto" : "hidden"; }
}

// Toggle content in the JmolShell side-bar
// The following assumes overlapping DIV's containing content
// on the left side. It allows toggling visibility so that only
// one is showing at a time 
function ShowDiv(id)
{ for (var i=0; i< MainMenuList.length; i++) 
	{ SetVisibility(MainMenuList[i],(MainMenuList[i] == id )); 
	  SetYScroll(MainMenuList[i],(MainMenuList[i] == id )) }

  //SetYScroll("MainDiv",(UserMenuList.length<1));
  //The following Kludge should not be necessary (and isn't, in Safari)
	if (id=="MainDiv") {
		if (UserMenuList.length>0) {
			SetVisibility(LastUserDiv,true);
			SetVisibility("UserMenuDiv",true);
			SetVisibility("UserParent",true);
		  	for(i=0; i< UserMenuList.length; i++) 
				{ SetYScroll(UserMenuList[i],false) };
			SetYScroll(LastUserDiv,true);
			SetYScroll(id,false);
		}
		else {
			SetYScroll(id,true);
		}
	} else {
		if (UserMenuList.length>0) {
			for(i=0; i< UserMenuList.length; i++) 
				{ SetVisibility(UserMenuList[i],false) };
			SetVisibility("UserMenuDiv",false);
			SetVisibility("UserParent",false);
			SetYScroll(id,true);
		}
		else {
			SetYScroll(id,true);
		}
	}
	for(i=0; i< AuthorMenuList.length; i++) 
		{ SetVisibility(AuthorMenuList[i],false) };
	SetVisibility("AuthorPanelDiv",(id=="CmdDiv"))
	SetVisibility("AuthorMenuDiv",(id=="CmdDiv"))
	SetVisibility(LastAuthorDiv,(id=="CmdDiv"))
	
	ReSetSizes();
}


// ========== Functions that can be called within the HTML page ====

// This function simplifies the generation of toggle boxes with the explicit
//  function of turning monitor lines on/off
//  Retained for legacy. The function below is more versatile
function ToggleMonitor(atom1,atom2,InTextLbl)
{  return ToggleMeasure(InTextLbl,250,atom1,atom2)  }

// This is a newer version of the above. It can be called with 2, 3, or 4 atom ids
//    to yield distance, angle, or dihedral angle
// Note that the label comes FIRST in this call
function ToggleMeasure(InTextLbl,spaceSize,atom1,atom2,atom3,atom4)
{
  var st = "<script>jmolCheckbox(\""
	+ "select atomno=" + atom1 + " or atomno=" + atom2
	+ ( (atom3!=null) ? " or atomno=" + atom3 : "")
	+ ( (atom4!=null) ? " or atomno=" + atom4 : "")
	+ ";" + ((spaceSize>0) ? "spacefill " + spaceSize + ";" : "")
	+ "monitor " + atom1 + " " + atom2
	+ ( (atom3!=null) ? " " + atom3 : "" )
	+ ( (atom4!=null) ? " " + atom4 : "" )
	+ "\",\""
	+ "select atomno=" + atom1 + " or atomno=" + atom2
	+ ( (atom3!=null) ? " or atomno=" + atom3 : "")
	+ ( (atom4!=null) ? " or atomno=" + atom4 : "")
	+ ";" + ((spaceSize>0) ? "spacefill off;" : "")
	+ "monitor " + atom1 + " " + atom2
	+ ( (atom3!=null) ? " " + atom3 : "" )
	+ ( (atom4!=null) ? " " + atom4 : "" )
	+ "\"," + "\"" + InTextLbl + "\")</script>";
  return DocWrite(st);
}

// Function to write a series of controls useful for animations
function AnimControls(nframes)
{
	var i=0;
	var RunScriptC = ";animation fps 1;animation on";
	var RunRScript = "frame " + nframes + ";animation direction -1;animation mode once" + RunScriptC;
	var RunFScript = "frame 1;animation direction +1;animation mode once" + RunScriptC;
	var t = "Run: " +
		"<script>" +
		"jmolButton(\"" + RunRScript + "\", \"\<\");" +
		"jmolButton(\"" + RunFScript + "\", \"\>\");" +

		"</script>";

	t += p + "Step: " +
		"<script>" +
		"jmolButton(\"frame 1\", \"\<\<\");" +

		"jmolButton(\"animation frame prev\", \"\<\");" +

		"jmolButton(\"animation frame next\", \"\>\");" +

		"jmolButton(\"frame " + nframes  + "\", \"\>\>\")" +
		"</script>" +
		p +
		"<form><script>" +
 		"jmolRadioGroup([";

	for (i=1; i<=nframes; i++)
		{ t += "[\"frame " + i + "\",\"\",\"\"],"  }
	
	t += " ], \" \", \"\") " +
		"</script></form>";
		
	DocWrite(t);
}

// ========== General functions ===========

// Called by SetupPage. Draws the menu buttons that control
// visibility of the DIV panels
function NavLink(lnk,txt,Dscr)
{  return "<a href=\"javascript:ShowDiv(\'" + lnk + "\')\"" 
	+ ((Dscr=="") ? "" : " title=\"" + Dscr + "\"") + ">" + txt + "</a>"; }

// ---------------

// replace all occurences of x by y in st
function rplc(st, x, y) {

  if ((x == y) || (parseInt(y.indexOf(x)) > -1)) { return st }
    
  while (st.indexOf(x) != -1) {
    st = st.substring(0, st.indexOf(x)) + y
		+ st.substring(st.indexOf(x) + x.length, st.length);  }
  return st;
}

// ---------------

// Defines a "DIV" start tag, based on a css class, with possibility of override
// Remembers a list of DIVs - useful for debugging
function DivStartTagC(divid, divclass)
{	if (divclass != "")		divclass = " class=\"" + divclass + "\" ";
	var st = "\n\n<div id=\"" + divid + "\" name=\"" + divid + "\" " + divclass + ">";
	var TmpRs = DivList.splice(DivList.length,0,divid);
  if (DivDebug) { DivMemory += st };
	//alert(st)
	return st;
}

function DivEndTagC()
{	var st = "\n</DIV> " + CommentString(DivList[DivList.length-1]) + "\n\n";
	var TmpRs = DivList.splice(DivList.length-1,1);
  if (DivDebug) 
	if (st.indexOf("DIV")>=0)
		{ DivMemory += st };
	return st;
}

// ---------------

function SpanWrap(st,spanclass, styl, id) {
  if (spanclass != "")	spanclass = " class=\"" + spanclass + "\" ";
  if (styl != "")		styl = " style=\"" + styl + "\" ";
  if (id != "")			id = " id=\"" + id + "\" ";
  return "<span " + id + spanclass + styl + ">" + st + "</span>"
}

// ---------------

// Places a string right-adjusted (used internally only)
function floatRight(st)
  { return SpanWrap(st,"","position: relative; float:right",""); }

// ---------------

// Places a string right-adjusted (used internally only)
// This is totally unnecessary, but helps in debugging - select "View Generated Code"
function CommentString(st)
  { return "<!" + "-- " + st + " -->"; }

// ---------------

// put Email tags for me and for the user
//  not currently used
function EMailTagName(RealName, User, domain)
{ return "<a href=\"mailto:" + User + "@" + domain + "\">" + RealName + "</a>" }

// ---------------

function EMailTag(User, domain)
{ return "<a href=\"mailto:" + User + "@" + domain + "\">" + User + "@" + domain + "</a>" }

// ---------------

function SetTagLine(PDBid, Dscr,Citation) {
  DscrPlus = Dscr + "<br>" + SpanWrap(Citation,"TagLine", "", "")
  GetObj("TagLineSpan").innerHTML = (PDBid == "" ) ? 
	DscrPlus :
	LinkTag(PDB_Search + PDBid,
		"ProteinDataBank", PDBid,"Click here to go to entry at the PDB") + " - "+ DscrPlus;
}

// ---------------

// Return an HTML link to go somewhere
function LinkTag(Dest,Targt,Txt,Dscr)
{ return "<a href=\"" + Dest + "\" target=\"" + Targt + "\"" 
	+ ((Dscr=="") ? "" : " title=\"" + Dscr + "\"") + ">" + Txt + "</a>" }

// ======== Routines for generating form elements (used by CmdLine code) =======

// Return a clickable button that executes a script
function FormButtonTag(nam,onClk,clss) {
	return "<input type=\"button\" value=\"" + nam + "\""
			+ "onclick=\"" + onClk +  "\" CLASS=\"" + clss + "\">"
}


// return a complete Select element for a form. Generates a pop-up menu
function SelectTag(nam,onchng,optns)
{	if (onchng != "") onchng += "()";
	optns = "<option>" + optns.replace(/,/g,"<option>");
	var st = "<select name=\"" + nam + "\" class=\"SelectTag\" size=\"1\" onchange=\"" + onchng + "\"" 
		+ " WIDTH=\"59\" >" + optns + "</select>";
	return st;
}

// Return an "text input" form element
function InputTextTag(nam,onchng,styl,sz,maxsz)
{	if (onchng != "") onchng = " onchange=\"" + onchng + "()\"";
	var st = "<input name='" + nam + "' type='text' size='" + sz + "' maxlength='" + maxsz + "'"
	+ onchng + ">";
	return st;
}

// Return a "checkbox" form element
function InputTextToggle(nam,onchng,styl)
{	if (onchng != "") onchng = " onchange=\"" + onchng + "()\"";
	var st = "<input name=\"" + nam + "\" type=\"checkbox\""
	+ onchng + ">";
	return st;
}

// Return a "radio button" form element
function InputRadio(grpnam,rtnval,onchng,IsChecked,styl)
{	if (onchng != "") onchng = " onclick=\"" + onchng + "()\"";
	(IsChecked != "") ? IsChecked = " CHECKED" : IsChecked = "";
	var st = "<input name=\"" + grpnam + "\" type=\"radio\" Value=\"" + rtnval + "\" "
	+ onchng + IsChecked + ">";
	return st;
}


// Return a "Clear" form element
function ClearTag() {
  return SpanWrap("<input type=\"reset\" value=\"Clear\"" + fntstyl + ">",
	"", "position: relative; float:right", "");
}

// =============== jShell specific stuff ==================

// Reset protein to default view, coloring, etc
function Reset()
  { run("script " + ResetFileG); }

// ---------------

// Draws an HTML link to execute script to load new molecule
function LinkToLoadNew(filename,lnktxt,PDB,dscr,citation) {
  var q = "\'";
  var stdsc = "Load coordinates for " + PDB + " - " + dscr;
  var stjsscrpt = "LoadNewPDB("
		+ q + filename + q + ","
		+ q + "" + q + ","
		+ q + PDB + q + ","
		+ q + dscr + q + ","
		+ q + citation + q
		+ ")";
  var st = "<A HREF=\"javascript:" + stjsscrpt + "\" TITLE=\"" + stdsc + "\">" + lnktxt + "</A>";
  DocWrite(st);
}

// Shows frame i of a model and updates the info header appropriately
function ShowFrame(i,PDB,dscr,citation) {
	var st = "frame " + i;
	jmolScript(st);
	SetTagLine(PDB,dscr,citation);
}

function LoadingWaitMsg(st)
{	jmolScript("set echo top left;echo loading "+st+"...;delay 1");
}

// Executes script to load new molecule and updates the info header appropriately
function LoadNewPDB(filename,scrpt,PDB,dscr,citation) {
	if (scrpt=="")
		{ scrpt = "script " + ResetFileG + ""  };
	var st = "load " + filename;
	LoadingWaitMsg(filename);
	jmolScript(st);
	var iposStar = scrpt.indexOf("_ResetAll_");
	if (iposStar>-1) {
		Reset();
		scrpt = scrpt.replace("_ResetAll_","");
	}
	jmolScript(scrpt);
	SetTagLine(PDB,dscr,citation);
}

// Writes HTML code to generate a button set for loading new molecules
// Call with the following
//  [filename,dscr,script,PDB,citation], [filename,btntxt,PDB,dscr,citation], ...
// Include as many buttons as you like
function ButtonsToLoadNew() {
  var filename="", dscr="", scrp="", PDB="", citation="", chkd="", btntxt="", sti=""; longdscr="", resol="";
  var btns = ButtonsToLoadNew.arguments;
  var nbtns = btns.length;
  var st = "<form>";
  for (var i = 0; i < nbtns; i++) {
	filename = btns[i][0];
	dscr = btns[i][1];
	scrp = btns[i][2];
	PDB = btns[i][3];
	citation = btns[i][4];
	chkd = btns[i][5];
	chkd = (chkd=="CHECKED") ? " CHECKED" : "";
	resol="";
	if (btns[i].length>5) { resol = btns[i][6] };
	longdscr="";
	if (btns[i].length>6) { longdscr = btns[i][7] };
	
	btntxt = dscr + " <SMALL>(" + PDB
	if (!(resol=="")) { btntxt += ", " + resol + "A" }
	btntxt += ")</SMALL>";
	sti = "<input type=\"radio\" class=\"JSRadioSet\" name=\"Bub\" "
	if (longdscr!="") sti += "Title=\"" + longdscr  + "\" ";
	sti += "onClick="
		+ "\"LoadNewPDB(\'" + filename  + "\',"
		+ "\'" +  scrp  + "\',"
		+ "\'" +  PDB  + "\',"
		+ "\'" +  dscr  + "\',"
		+ "\'" +  citation  + "\'"
		+ ")\"" + chkd + ">" +  btntxt + "<br>";
	st += sti;
	
  }
  st += "</form>";
  DocWrite(st);
}

// Like that above but using a "Definitions" list
function ButtonsToLoadDef() {
  var filename="", dscr="", scrp="", PDB="", citation="", chkd="", btntxt="", sti="";
  var btns = ButtonsToLoadDef.arguments;
  var nbtns = btns.length;
  var st = "<form>" + "<DL>";
  for (var i = 0; i < nbtns; i++) {
	filename = btns[i][0];
	dscr = btns[i][1];
	scrp = btns[i][2];
	PDB = btns[i][3];
	citation = btns[i][4];
	chkd = btns[i][5];
	definit = btns[i][6];
	chkd = (chkd=="CHECKED") ? " CHECKED" : "";
	
	btntxt = dscr + " <SMALL>(" + PDB + ")</SMALL>";
	sti = "<input type=\"radio\" name=\"Bub\" onClick="
		+ "\"LoadNewPDB(\'" + filename  + "\',"
		+ "\'" +  scrp  + "\',"
		+ "\'" +  PDB  + "\',"
		+ "\'" +  dscr  + "\',"
		+ "\'" +  citation  + "\'"
		+ ")\"" + chkd + ">" +  btntxt + "<br>";

	st += "<DT>" + sti + "<DD>" + definit;
  }
  st += "</DL>" + "</form>";
  DocWrite(st);
}

// Write a routine like that above, but that switches frames only
//  [ for future development ]


// Send command(s) to Jmol, saving in History if Record mode is ON
function run(Jscript)
  { jmolScript(Jscript);
	with (document.history) {
		if (ScriptRecordOn.checked) {
			if (historyBox.value != "") historyBox.value += CrLf;
			historyBox.value += ReplaceAll(Jscript,";",CrLf);
		}
	}
  }

// ---------- Stuff for message call back ------------

// Feedback on the recently picked atom
//  place the result into boxes on main page
function showpick(a,b)
{	b = ""+b;
	with (document.cline) {
		var atno = b.substring( b.indexOf("#")+1 );
		atno = atno.substring(0,atno.indexOf(" "));
		Res.value = b.substring(b.indexOf("[")+1,b.indexOf("]"));
		ResNo.value = b.substring(b.indexOf("]")+1,b.indexOf(":"));
		Chain.value = b.substring(b.indexOf(":")+1,b.indexOf("."));
		Atom.value = b.substring(b.indexOf(".")+1,b.indexOf("#"));
		AtomNo.value = atno;
		var atfull = b.substring(0,b.indexOf(" ",b.indexOf("#")));
		FullCall.value = atfull;
		
		RecentPicks[3] = RecentPicks[2];
		RecentPicks[2] = RecentPicks[1];
		RecentPicks[1] = RecentPicks[0];
		RecentPicks[0] = AtomNo.value;
	}
}

// Messages from Jmol (info about number of atoms selected, etc)
//  this is specified in the MessageCallBack argument below
function showmsg(a,b,c)
{	b = ""+b;
	with (document.Feedback.Messages) {
		var st = value;
		value = b+"\n"+st;
	}
	
	var ScriptCompleted = (b.indexOf("Script completed")==-1);
	
	// The following (optionally) records content to a global variable
	if (CaptureMsgs=="true")
		{ if ((b.indexOf("Jmol executing")==-1) && (ScriptCompleted))
			{ MsgStore += b + "\n"; } }
			
	if (Processing) {
		if (ScriptCompleted) {
			Processing = false;
			jmolScript(StartUpScript);
		}
	}

	// the following responds to a prior request from ShowOr
	if (WaitingForO=="true") {
		var istart = b.indexOf("moveto ");
		if (istart>-1) {
			WaitingForO = "false";
			with (document.EnviroForm) {
				st = b.substring(istart,b.indexOf("OR")-2);
				CurrOr.value = st;
				DoEnviroForm();
			}
	 	 }
  	}

	// If the system was waiting for a completed message to be sent
	//   then do something
	if (b.indexOf("Script completed")>-1)
		if (CaptureMsgs=="true") CaptureMsgs="false";
	
	LastMsgSet = b;
	
	//alert("showmsg: " + a + " !! " + b);
}

// All writing to the HTML document body must go through here
function DocWrite(st) {
  //document.writeln(st);
  _jmolDocumentWrite(st);
  if (NewDebug) { BigMemory += st };
  return st;
}

//==================== Special section for User DIVs ============

// Only the first function should be called by the User

// Called by the User. It marks the beginning of a new user-defined DIV.
//  It writes the necessary code to start a new DIV (and finish the previous),
//    but also adds to the global arrays UserMenuList and UserDscr
//  By default, the DIV defined first is visible. The rest are hidden.
//
// ToDo: Modify this to remember a list of DIVs?
//
function StartNewDiv(DivName,Dscr,LastUpDate) {
  if (LastUserDiv=="") LastUserDiv = DivName;
  if (UserMenuList.length==0) 
		{ DocWrite(DivStartTagC("UserParent","UserParent")); }

  UserMenuList[UserMenuList.length] = DivName;
  UserDscr[UserDscr.length] = Dscr + " (last updated " + LastUpDate + ")";
  var st = (UserMenuList.length>1) ? DivEndTagC() : "";

  st += DivStartTagC(DivName,"UserContent");
  DocWrite(st);
}

// ===================================

// This is used when the user clicks on a menu item in the UserMenuList
//  it hides all User Divs, and then enables the one passed
function ShowUserDiv(id)
{ var i=0;
  for(var i=0; i< UserMenuList.length; i++) 
		{ SetVisibility(UserMenuList[i],false);  }
  SetVisibility(id,true);
  LastUserDiv = id;
  ShowDiv("MainDiv");
  ReSetSizes();
}

// As above but for the authoring menu under the CMD tab
function ShowAuthorDiv(id)
{ var i=0;
  for(var i=0; i< AuthorMenuList.length; i++) 
		{ SetVisibility(AuthorMenuList[i],false);  }
  SetVisibility(id,true);
  LastAuthorDiv = id;
  if (id=="Preview")
	{ GetObj(AuthorMenuList[2]).innerHTML = ConvertInner(document.TestBedCode.TestBedBox.value) }
  ShowDiv("CmdDiv");
  ReSetSizes();
}

// Used by the above
// Takes the HTML and evaluates jmol function calls, returning the result
function ConvertInner(st) {
	while (st.indexOf("<script>")>=0) {
		var istart = st.indexOf("<script>");
		var iend = st.indexOf("</script>")+9;
		var st_sub = st.substring(istart+8,iend-9);
		//alert("Before conversion: "+st_sub);
		jmolSetDocument(false);
			var st_cnv = eval(st_sub);
		jmolSetDocument(document);
		//alert("After conversion: "+st_cnv);
		var st_left = st.substring(0,istart);
		var st_right = st.substring(iend,st.length);
		st = st_left + st_cnv + st_right;
		//alert("Final string: "+st);
	}
	return st
}



// =============

// Writes a menu, using the table construct
// Called as a part of WrapUp, so that it knows what to draw
//   Gets information from the passed arrays UserMenuList and UserDscr
function WriteMenu(MenuName,MenuClass,MenuItems,DescItems,MenuScript)
{
  DocWrite(GetMenu(MenuName,MenuClass,MenuItems,DescItems,MenuScript));
}

function GetMenu(MenuName,MenuClass,MenuItems,DescItems,MenuScript)
{
 // Define a DIV for this menu, at the top of the enclosing DIV
 var st = DivStartTagC(MenuName,MenuClass);
 var n = MenuItems.length;
 var pWid = Math.round(100/n);
 var mWid = Math.round((sideBarWid)/n);
 var FrntSt = "<TD width=\"" + pWid + "%\"><A HREF=\"javascript:" + MenuScript + "(\'";
 var MidSt1 = "\')\" title=\'";
 var MidSt2 = "\'>";
 var EndSt = "</A></TD>";

 // Write a table containing the menu elements, then close this DIV
 st += "<TABLE BORDER=\"0\" CELLSPACING=\"2\" CELLPADDING=\"1\" WIDTH=\"100%\" BGCOLOR=\"#FFFFCC\">";
 st += "<TR ALIGN=\"center\" VALIGN=\"top\">";
 for(var i=0; i< n; i++) {
	st += FrntSt + MenuItems[i] + MidSt1 + DescItems[i] + MidSt2 + MenuItems[i] + EndSt;
 }
 st += "</TABLE>" + DivEndTagC();
 return st;
}

// ============

// Used by following function
function SetDivHeight(velement,pxhgt) {
   if (GetObj(velement)) { GetObj(velement).style.height = pxhgt+"px"; }
}

// Called whenever a window is re-sized (added 3-31-06)
//  Note that the "BODY" element must now include a call to this function on resize)
//    within the BODY tag include:   onResize="ReSetSizes()"
function ReSetSizesEmpty() {
}
function ReSetSizes() {
  jHgt = (window.innerHeight) ? window.innerHeight : document.body.offsetHeight;
	
  //Reset Main Left DIV's
  var menuHeight = GetObj("MenuD").offsetHeight;
  var hgtpx = jHgt-menuHeight;
  for (var i=0; i< MainMenuList.length; i++)
	 { SetDivHeight(MainMenuList[i],hgtpx); }	
  SetDivHeight("LeftPanel",hgtpx);

  // Reset User Div's, if any
  if (UserMenuList.length>0) {
	hgtpx = hgtpx - GetObj("UserMenuDiv").offsetHeight;
	SetDivHeight("UserParent",hgtpx);
    for (var i=0; i< UserMenuList.length; i++) 
		{ SetDivHeight(UserMenuList[i],hgtpx); }
  }
}

// ====================

// This code is called once, below, to create the DIV containing the applet
// Prepare the DIV layer to contain the applet, but don't yet write it
function CreateAppletDiv() {
  var st_AppDiv = DivStartTagC("Appd","JmolApp");
						
  jmolSetAppletColor("white", "black", "white", "white");

  var LoadScript = "load " + pdbFileG;
  if (scrptfileG) LoadScript += ";script " + scrptfileG;

  // Write the JMol applet within this DIV - get string to write later
   jmolSetDocument(0);

   jmolSetAppletCssClass("appletCssClass");
   var s = jmolApplet([1.0,0.94], LoadScript);
   var sext = "";
     sext = "\n<param name='MessageCallback' value='" + "showmsg" + "' />";
     s = s.replace(/<param/, sext + "\n<param");
     sext = "";
     sext = "\n<param name='PickCallback' value='" + "showpick" + "' />";
     s = s.replace(/<param/, sext + "\n<param");
 
  //Restore direct writing by Jmol.js calls
  jmolSetDocument(document);

  // Write a form containing a box for user-entered commands, then close the DIV
  var cmdWid = Math.round(jWid/7) - 21;

  // Write boxes for parsed picking stuff
  var st_CB = DivStartTagC("PickingDiv","BottomLeft") + "\n\n<form name=\"cline\" class=\"TopForm\">";

  st_CB +=  "<input name=\"Res\" value=\"Res\" size=5 " + fntstyl + " >"
	+ "<input name=\"ResNo\" value=\"ResNo\" size=5 " + fntstyl + " >"
	+ "<input name=\"Chain\" value=\"Ch\" size=2 " + fntstyl + " >"
	+ "<input name=\"Atom\" value=\"Atom\" size=5 " + fntstyl + " >"
	+ "<input name=\"AtomNo\" value=\"AtomNo\" size=6 " + fntstyl + " >"
	+ "<input name=\"FullCall\" value=\"\" size=20 " + fntstyl + " >"
	+ "</form>" + DivEndTagC();

  st_CB += DivStartTagC("ClineDiv","BottomRight")
	+ "\n\n<form name=\"clinesolo\" action=\"javascript:runcline()\">"
	+ "<input autocomplete=\"off\" id=\"onecmd2\" size=\"35\" value=\""+OneCmdBoxHint+"\" type=\"text\" "
	+ "promptValue=\""+OneCmdBoxHint+"\" z-index=\"9\">"
	
	+ "<input name=\"HaloToggle\" type=\"checkbox\" onClick=\"ToggleHalo()\"> "
	+ "<span class=\"formstyl\">Selection halos</span>"
	+ "</form>" + DivEndTagC();
  	
  return st_AppDiv + st_CB + s + DivEndTagC();

}

function ToggleHalo() {
	run("selectionHalos "+((document.clinesolo.HaloToggle.checked) ? "on" : "off"));
}

// Resize the left panel and adjust everthing accordingly
//   It works!!! Dec 6, 2007
function ReSizeLeftPanel(NewWidth) {
	if (!NewWidth) NewWidth = prompt("Enter new width for the left panel (in pixels)","350");
	if (!NewWidth) return;
	if ((NewWidth<200)||(NewWidth>800)) {
		if (NewWidth) alert("The width "+NewWidth+" is not acceptable");
		return;
	}

	// Resize the right DIV, containing the applet
	var StyleAppd = GetObj("Appd").style;
	StyleAppd.marginLeft = (4.0+(1.0*NewWidth))+"px";
	
	// MainMenuList = ["MainDiv","About","CmdDiv","PreSetsDiv","HelpDiv","DebugDiv"];
	var new_WidPix = NewWidth+"px";
	for (var i=0; i< MainMenuList.length; i++)
	   GetObj(MainMenuList[i]).style.width = new_WidPix;

	GetObj("LeftPanel").style.width = new_WidPix;
	GetObj("LeftParent").style.width = new_WidPix;

	GetObj("AuthorPanelDiv").style.width = new_WidPix;
	GetObj("UserParent").style.width = new_WidPix;
	for (var i=0; i< UserMenuList.length; i++) 
		 GetObj(UserMenuList[i]).style.width = new_WidPix;

	GetObj("MenuD").style.width = new_WidPix;
	GetObj("TagLineSpan").style.width = new_WidPix;
}

//================================================================
//======== These draw the bulk of the page for the user ==========

// Define and write a Jmol Applet, sized dynamically
//
//	Arguments to the function JmolAppl are:
//
//	       pdbfile:  the name of the pdb coordinate file
//	     scrptfile:  the name of a default script file to run after loading
//          PDBid:  the PDB identifier for this structure
//         StDescr:  a description of the structure (eg, name of the protein)
//        Citation:  journal reference for the structure presented
//        PubMedID:  PubMed ID for the above journal reference
//          Author:  name of the author of this particular presentation
//     LastUpdated:  Date this particular presentation was last updated
//
//			== the following paramters are optional ==
//
//     SupportPath:  the path to the support folder (default: same folder)
//
//   No longer supported:
//      sideBarWid: width, in pixels, of the sidebar (default: 290)

function JmolAppl(pdbfile,scrptfile,PDBidSet,StDescrSet,Citation,PubMedID,
                  Author,LastUpdated,SupportPath,LeftPanelWidth,OneLineCmdBar) 
{
  var UseSignedAppl;
  LeftPanelWidthG = LeftPanelWidth;
  PDBid = PDBidSet;
  StDescr = StDescrSet;
  pdbFileG = pdbfile;
  scrptfileG = scrptfile;

  if (! SupportPath) SupportPath = "./";
  SupportPathG = SupportPath;
  var CSSPath = SupportPath + "JmolShell.css";

  // Load the style sheet
  DocWrite("<link rel=\"stylesheet\" href=\"" + CSSPath + "\" type=\"text/css\">");

  // vertical height for the single command line entry box
  if (!OneLineCmdBarG) cmdHgt = 0;

  // Figure out if being called locally or via the net
  jmolDebugAlert(JmolDebugStatus);
  if (JmolDebugStatus) alert("JmolDebugStatus on");
  UseSignedAppl = (document.location.host=="");

  // First, call a setup routine in Jmol.js
  jmolInitialize(SupportPath,UseSignedAppl);
  jmolCheckBrowser("alert","This browser does not fully support Jmol. " + 
	"Some functions are limited.");

  // Update the SupportPath and other global variables from calling params
  AuthorG = Author;
  CitationG = Citation;
  PubMedIDG = PubMedID;
  ResetFileG = scrptfile;
  LastUpdatedG = LastUpdated;

  FontSzG = ((navigator.appVersion.indexOf("Mac") != -1)) ? 12 : 10;
  CrLf = ((navigator.appVersion.indexOf("Mac") != -1)) ? "\r" : "\n";

  // change the title of the window to a description of the structure
  document.title = PDBid+" - "+StDescr;

//    Layout of "DIV" elements (Main, About, Cmd, Help overlap each other)
// +----------+-----------------------------------------+
// |			|									|
// |	MenuD	|									|
// |			|									|
// +---------+									|
// |			|			Appd					|
// |	Main	|									|
// |	About	|									|
// |	Cmd	|									|
// |	Help	|									|
// |			|									|
// +----------+-----------------------------------------+


// ------------ Next, draw the 'MenuD' DIV box to the top left --------------

  //var stTop = DivStartTagC("FullWindow", "FullWindow") + DivStartTagC("LeftParent", "LeftParent");
  var stTop =  DivStartTagC("LeftParent", "LeftParent");
				
  DocWrite(stTop);

// Draw the menu at the top
  var st_Menu = DivStartTagC("MenuD","MainMenu")
 	+ NavLink("MainDiv","Main","The presentation content, including the complete" + 
			" story for the molecule at right")
		+ " | " 		
	+ NavLink("About","About","Information about this molecule and about JmolShell. Literature citation.")
		+ " | "
	+ NavLink("CmdDiv","Cmd","provides a command line and multi-line box for executing " + 
		"multiple Jmol commands. Also allows recording of commands and a Test Bed for making " +
			"your own code in the development of your own JmolShell project")
		+ " | "		
	+ NavLink("PreSetsDiv","Presets","Lets you construct Jmol commands using a simple " +
			"form. This is a good way to learn how to write scripts")
		+ " | "
	+ NavLink("HelpDiv","Help","Help on using Jmol. Links to documentation.");
	
	if (NewDebug) { 
		st_Menu += " | " + NavLink("DebugDiv","D","Debugging info");}
	
	st_Menu += " || "
	+ "<a href=\"javascript:Reset()\" title=\"Reset structure to starting point\">Reset</a>"
	+ HR + SpanWrap("loading...","","","TagLineSpan")
	+ DivEndTagC();
  DocWrite(st_Menu);

  DocWrite( DivStartTagC("LeftPanel", "LeftPanel") );

// ------- Next, draw the 'MainDiv,About,Help,&Cmd' DIV boxes to the left ----------

// Draw the left-content, multiple times overlapping
// All but the MainDiv panel are set to invisible for now.
// MainDiv must be last and is left open-ended, since user content in the calling page will follow

  MainMenuList = ["MainDiv","About","CmdDiv","PreSetsDiv","HelpDiv","DebugDiv"];
  var st_DIVs = DivStartTagC("About","MainContent") +jAbout() + DivEndTagC();
  	st_DIVs += DivStartTagC("CmdDiv","MainContent") + CmdLineHTML + DivEndTagC();
  	st_DIVs += DivStartTagC("HelpDiv","MainContent") + HelpHTML + DivEndTagC();
  	st_DIVs += DivStartTagC("PreSetsDiv","MainContent") + PresetsHTML + DivEndTagC();
  	st_DIVs += DivStartTagC("DebugDiv","MainContent") + DebugDivHTML + DivEndTagC();
  DocWrite(st_DIVs);

  // Finally, write the MainDiv (User) LeftDiv
  DocWrite( DivStartTagC("MainDiv","MainContent") );

}


// =================================================================

// Call this after the User's HTML
function WrapUpPage()
{ 
  // If the user defined User (sub-) DIV's, wrap that up and write a menu for it
  if (UserMenuList.length>0) {
	DocWrite(DivEndTagC()+DivEndTagC());     //Close off the last user DIV and UserParentDiv
	WriteMenu("UserMenuDiv","UserMenu",UserMenuList,UserDscr,"ShowUserDiv");
   }
	DocWrite(DivEndTagC());            //Close off UserMenuDiv

  // Close off MainDIV, LeftPanel, LeftParent
  DocWrite( DivEndTagC() + DivEndTagC() );

  ShowDiv("MainDiv");
  SetVisibility(UserMenuList[0],true);

  // Write the code that draws the Jmol applet
  DocWrite(CreateAppletDiv());

  if (NewDebug) document.DebugDivForm.DebugDivField.value = BigMemory;
  if (DivDebug) document.DebugDivForm.DebugDivField.value = DivMemory;
  if (DivDebug) prompt("Here is the DIV structure",DivMemory);
	
   // Close off Appd and FullWindow
  DocWrite( DivEndTagC() );

 // Update the Tag Line
  SetTagLine(PDBid, StDescr,CitationG);

  ReSetSizes();
  SetUpFields("input");
  SetUpFields("textarea");

  var tst = GetObj("Appd");
  //alert("well width =" + tst.style.width);

  if (LeftPanelWidthG) ReSizeLeftPanel(LeftPanelWidthG);

  run(StartUpScript);
}

