/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Font3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Measurement;
import org.jmol.viewer.Measures;
import org.jmol.viewer.PendingMeasurement;
import org.jmol.viewer.ShapeRenderer;

class MeasuresRenderer
extends ShapeRenderer {
    short colix;
    boolean showMeasurementNumbers;
    short measurementMad;
    Font3D font3d;
    Measurement measurement;
    AxisAngle4f aaT = new AxisAngle4f();
    Matrix3f matrixT = new Matrix3f();
    Point3f pointT = new Point3f();

    MeasuresRenderer() {
    }

    void render() {
        Measures measures = (Measures)this.shape;
        this.colix = measures.colix;
        if (this.colix == 0) {
            this.colix = this.g3d.getColixBackgroundContrast();
        }
        this.measurementMad = measures.mad;
        this.font3d = measures.font3d;
        this.showMeasurementNumbers = measures.showMeasurementNumbers;
        int i = measures.measurementCount;
        while (--i >= 0) {
            this.renderMeasurement(measures.measurements[i], this.colix);
        }
        this.renderPendingMeasurement(measures.pendingMeasurement);
    }

    void renderMeasurement(Measurement measurement, short colix) {
        this.renderMeasurement(measurement.count, measurement, colix, true);
    }

    void renderMeasurement(int count, Measurement measurement, short colix, boolean renderArcs) {
        this.measurement = measurement;
        switch (count) {
            case 2: {
                this.renderDistance(colix);
                break;
            }
            case 3: {
                this.renderAngle(colix, renderArcs);
                break;
            }
            case 4: {
                this.renderTorsion(colix, renderArcs);
                break;
            }
            default: {
                throw new NullPointerException();
            }
        }
    }

    int drawSegment(int x1, int y1, int z1, int x2, int y2, int z2, short colix) {
        if (this.measurementMad < 0) {
            this.g3d.drawDashedLine(colix, 4, 2, x1, y1, z1, x2, y2, z2);
            return 1;
        }
        short widthPixels = this.measurementMad;
        if (this.measurementMad >= 20) {
            widthPixels = this.viewer.scaleToScreen((z1 + z2) / 2, this.measurementMad);
        }
        this.g3d.fillCylinder(colix, (byte)2, widthPixels, x1, y1, z1, x2, y2, z2);
        return (widthPixels + 1) / 2;
    }

    void renderDistance(short colix) {
        this.renderDistance(this.frame.getAtomAt(this.measurement.countPlusIndices[1]), this.frame.getAtomAt(this.measurement.countPlusIndices[2]), colix);
    }

    void renderDistance(Atom atomA, Atom atomB, short colix) {
        if (this.displayModelIndex >= 0 && (this.displayModelIndex != atomA.modelIndex || this.displayModelIndex != atomB.modelIndex)) {
            return;
        }
        int zA = atomA.getScreenZ() - atomA.getScreenD() - 10;
        int zB = atomB.getScreenZ() - atomB.getScreenD() - 10;
        int radius = this.drawSegment(atomA.getScreenX(), atomA.getScreenY(), zA, atomB.getScreenX(), atomB.getScreenY(), zB, colix);
        this.paintMeasurementString((atomA.getScreenX() + atomB.getScreenX()) / 2, (atomA.getScreenY() + atomB.getScreenY()) / 2, (zA + zB) / 2, radius, colix);
    }

    void renderAngle(short colix, boolean renderArcs) {
        this.renderAngle(this.frame.getAtomAt(this.measurement.countPlusIndices[1]), this.frame.getAtomAt(this.measurement.countPlusIndices[2]), this.frame.getAtomAt(this.measurement.countPlusIndices[3]), colix, renderArcs);
    }

    void renderAngle(Atom atomA, Atom atomB, Atom atomC, short colix, boolean renderArcs) {
        if (this.displayModelIndex >= 0 && (this.displayModelIndex != atomA.modelIndex || this.displayModelIndex != atomB.modelIndex || this.displayModelIndex != atomC.modelIndex)) {
            return;
        }
        this.g3d.setColix(colix);
        int zA = atomA.getScreenZ() - atomA.getScreenD() - 10;
        int zB = atomB.getScreenZ() - atomB.getScreenD() - 10;
        int zC = atomC.getScreenZ() - atomC.getScreenD() - 10;
        int zOffset = (zA + zB + zC) / 3;
        int radius = this.drawSegment(atomA.getScreenX(), atomA.getScreenY(), zA, atomB.getScreenX(), atomB.getScreenY(), zB, colix);
        radius += this.drawSegment(atomB.getScreenX(), atomB.getScreenY(), zB, atomC.getScreenX(), atomC.getScreenY(), zC, colix);
        radius = (radius + 1) / 2;
        if (!renderArcs) {
            return;
        }
        AxisAngle4f aa = this.measurement.aa;
        if (aa == null) {
            this.paintMeasurementString(atomB.getScreenX() + 5, atomB.getScreenY() - 5, zB, radius, colix);
            return;
        }
        int dotCount = (int)((double)aa.angle / (Math.PI * 2) * 64.0);
        float stepAngle = aa.angle / (float)dotCount;
        this.aaT.set(aa);
        int iMid = dotCount / 2;
        int i = dotCount;
        while (--i >= 0) {
            this.aaT.angle = (float)i * stepAngle;
            this.matrixT.set(this.aaT);
            this.pointT.set(this.measurement.pointArc);
            this.matrixT.transform(this.pointT);
            this.pointT.add(atomB.point3f);
            Point3i screenArc = this.viewer.transformPoint(this.pointT);
            int zArc = screenArc.z - zOffset;
            if (zArc < 0) {
                zArc = 0;
            }
            this.g3d.drawPixel(screenArc.x, screenArc.y, zArc);
            if (i != iMid) continue;
            this.pointT.set(this.measurement.pointArc);
            this.pointT.scale(1.1f);
            this.matrixT.transform(this.pointT);
            this.pointT.add(atomB.point3f);
            Point3i screenLabel = this.viewer.transformPoint(this.pointT);
            int zLabel = screenLabel.z - zOffset;
            this.paintMeasurementString(screenLabel.x, screenLabel.y, zLabel, radius, colix);
        }
    }

    void renderTorsion(short colix, boolean renderArcs) {
        int[] countPlusIndices = this.measurement.countPlusIndices;
        this.renderTorsion(this.frame.getAtomAt(countPlusIndices[1]), this.frame.getAtomAt(countPlusIndices[2]), this.frame.getAtomAt(countPlusIndices[3]), this.frame.getAtomAt(countPlusIndices[4]), colix, renderArcs);
    }

    void renderTorsion(Atom atomA, Atom atomB, Atom atomC, Atom atomD, short colix, boolean renderArcs) {
        if (this.displayModelIndex >= 0 && (this.displayModelIndex != atomA.modelIndex || this.displayModelIndex != atomB.modelIndex || this.displayModelIndex != atomC.modelIndex || this.displayModelIndex != atomD.modelIndex)) {
            return;
        }
        int zA = atomA.getScreenZ() - atomA.getScreenD() - 10;
        int zB = atomB.getScreenZ() - atomB.getScreenD() - 10;
        int zC = atomC.getScreenZ() - atomC.getScreenD() - 10;
        int zD = atomD.getScreenZ() - atomD.getScreenD() - 10;
        int radius = this.drawSegment(atomA.getScreenX(), atomA.getScreenY(), zA, atomB.getScreenX(), atomB.getScreenY(), zB, colix);
        radius += this.drawSegment(atomB.getScreenX(), atomB.getScreenY(), zB, atomC.getScreenX(), atomC.getScreenY(), zC, colix);
        radius += this.drawSegment(atomC.getScreenX(), atomC.getScreenY(), zC, atomD.getScreenX(), atomD.getScreenY(), zD, colix);
        this.paintMeasurementString((atomA.getScreenX() + atomB.getScreenX() + atomC.getScreenX() + atomD.getScreenX()) / 4, (atomA.getScreenY() + atomB.getScreenY() + atomC.getScreenY() + atomD.getScreenY()) / 4, (zA + zB + zC + zD) / 4, radius /= 3, colix);
    }

    void paintMeasurementString(int x, int y, int z, int radius, short colix) {
        if (!this.showMeasurementNumbers) {
            return;
        }
        String strMeasurement = this.measurement.strMeasurement;
        if (strMeasurement == null) {
            return;
        }
        int xT = x + radius / 2 + 2;
        int yT = y - radius / 2;
        int zT = z - radius - 2;
        if (zT < 1) {
            zT = 1;
        }
        this.g3d.drawString(strMeasurement, this.font3d, colix, xT, yT, zT);
    }

    void renderPendingMeasurement(PendingMeasurement pendingMeasurement) {
        int count = pendingMeasurement.count;
        int[] countPlusIndices = pendingMeasurement.countPlusIndices;
        if (!pendingMeasurement.isActive || count < 2) {
            return;
        }
        short colixRubberband = this.viewer.getColixRubberband();
        if (countPlusIndices[count] == -1) {
            this.renderPendingWithCursor(pendingMeasurement, colixRubberband);
        } else {
            this.renderMeasurement(pendingMeasurement, colixRubberband);
        }
    }

    void renderPendingWithCursor(PendingMeasurement pendingMeasurement, short colixRubberband) {
        int count = pendingMeasurement.count;
        if (count < 2) {
            return;
        }
        if (count > 2) {
            this.renderMeasurement(count - 1, pendingMeasurement, colixRubberband, false);
        }
        Atom atomLast = this.frame.getAtomAt(pendingMeasurement.countPlusIndices[count - 1]);
        int lastZ = atomLast.getScreenZ() - atomLast.getScreenD() - 10;
        this.drawSegment(atomLast.getScreenX(), atomLast.getScreenY(), lastZ, this.viewer.getCursorX(), this.viewer.getCursorY(), 0, colixRubberband);
    }
}

