/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedReader;
import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.viewer.MeshCollection;

class Pmesh
extends MeshCollection {
    Pmesh() {
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        if ("bufferedreader" == propertyName) {
            BufferedReader br = (BufferedReader)value;
            if (this.currentMesh == null) {
                this.allocMesh(null);
            }
            this.currentMesh.clear();
            this.readPmesh(br);
            this.currentMesh.initialize();
            this.currentMesh.visible = true;
            return;
        }
        super.setProperty(propertyName, value, bs);
    }

    void readPmesh(BufferedReader br) {
        try {
            this.readVertexCount(br);
            this.readVertices(br);
            this.readPolygonCount(br);
            this.readPolygonIndexes(br);
        }
        catch (Exception e) {
            System.out.println("Pmesh.readPmesh exception:" + e);
        }
    }

    void readVertexCount(BufferedReader br) throws Exception {
        this.currentMesh.setVertexCount(this.parseInt(br.readLine()));
    }

    void readVertices(BufferedReader br) throws Exception {
        if (this.currentMesh.vertexCount > 0) {
            for (int i = 0; i < this.currentMesh.vertexCount; ++i) {
                String line = br.readLine();
                float x = this.parseFloat(line);
                float y = this.parseFloat(line, this.ichNextParse);
                float z = this.parseFloat(line, this.ichNextParse);
                this.currentMesh.vertices[i] = new Point3f(x, y, z);
            }
        }
    }

    void readPolygonCount(BufferedReader br) throws Exception {
        this.currentMesh.setPolygonCount(this.parseInt(br.readLine()));
    }

    void readPolygonIndexes(BufferedReader br) throws Exception {
        if (this.currentMesh.polygonCount > 0) {
            for (int i = 0; i < this.currentMesh.polygonCount; ++i) {
                this.currentMesh.polygonIndexes[i] = this.readPolygon(br);
            }
        }
    }

    int[] readPolygon(BufferedReader br) throws Exception {
        int vertexIndexCount = this.parseInt(br.readLine());
        if (vertexIndexCount < 4) {
            return null;
        }
        int vertexCount = vertexIndexCount - 1;
        int[] vertices = new int[vertexCount];
        for (int i = 0; i < vertexCount; ++i) {
            vertices[i] = this.parseInt(br.readLine());
        }
        int extraVertex = this.parseInt(br.readLine());
        if (extraVertex != vertices[0]) {
            System.out.println("?Que? polygon is not complete");
            throw new NullPointerException();
        }
        return vertices;
    }
}

