/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.viewer.Prueba;
import org.jmol.viewer.ShapeRenderer;

class PruebaRenderer
extends ShapeRenderer {
    private static final int level = 1;

    PruebaRenderer() {
    }

    void render() {
        Prueba prueba = (Prueba)this.shape;
        short colix = prueba.colix;
        int vertexCount = this.g3d.getGeodesicVertexCount(1);
        Vector3f[] tvs = this.g3d.getTransformedVertexVectors();
        Point3i[] screens = this.viewer.allocTempScreens(vertexCount);
        short[] geodesicFaceVertexes = this.g3d.getGeodesicFaceVertexes(1);
        int geodesicFaceCount = this.g3d.getGeodesicFaceCount(1);
        this.calcScreens(vertexCount, tvs, screens);
        int i = geodesicFaceCount;
        int j = 0;
        while (--i >= 0) {
            short vA = geodesicFaceVertexes[j++];
            short vB = geodesicFaceVertexes[j++];
            short vC = geodesicFaceVertexes[j++];
            this.g3d.fillTriangle(colix, screens[vA], vA, screens[vB], vB, screens[vC], vC);
        }
        this.viewer.freeTempScreens(screens);
    }

    void calcScreens(int count, Vector3f[] tvs, Point3i[] screens) {
        float scaledRadius = this.viewer.scaleToScreen(1000, 1.0f);
        int i = count;
        while (--i >= 0) {
            Vector3f tv = tvs[i];
            Point3i screen = screens[i];
            screen.x = 150 + (int)(scaledRadius * tv.x);
            screen.y = 150 - (int)(scaledRadius * tv.y);
            screen.z = 1000 - (int)(scaledRadius * tv.z);
        }
    }
}

