/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Xyzd;
import org.jmol.viewer.Atom;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Stars;

class StarsRenderer
extends ShapeRenderer {
    StarsRenderer() {
    }

    void render() {
        Stars stars = (Stars)this.shape;
        if (stars.mads == null) {
            return;
        }
        Atom[] atoms = this.frame.atoms;
        int displayModelIndex = this.displayModelIndex;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            short mad;
            Atom atom = atoms[i];
            if (displayModelIndex >= 0 && atom.modelIndex != displayModelIndex || (mad = stars.mads[i]) == 0) continue;
            short colix = stars.colixes == null ? (short)0 : stars.colixes[i];
            this.render1(atom, mad, colix);
        }
    }

    void render1(Atom atom, short mad, short colix) {
        long xyzd = atom.xyzd;
        int x = Xyzd.getX(xyzd);
        int y = Xyzd.getY(xyzd);
        int z = Xyzd.getZ(xyzd);
        int d = this.viewer.scaleToScreen(z, mad);
        atom.formalChargeAndFlags = (byte)(atom.formalChargeAndFlags | 1);
        d -= d & 1 ^ 1;
        colix = Graphics3D.inheritColix(colix, atom.colixAtom);
        int r = d / 2;
        this.g3d.drawLine(colix, x - r, y, z, x - r + d, y, z);
        this.g3d.drawLine(colix, x, y - r, z, x, y - r + d, z);
    }
}

