/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.jmol.api.JmolViewer;
import org.jmol.viewer.JmolConstants;
import org.openscience.jmol.ui.JmolPopupAwt;
import org.openscience.jmol.ui.JmolPopupSwing;
import org.openscience.jmol.ui.PopupResourceBundle;

public abstract class JmolPopup {
    private static final boolean forceAwt = false;
    JmolViewer viewer;
    Component jmolComponent;
    MenuItemListener mil;
    Object elementsComputedMenu;
    Object aaresiduesComputedMenu;
    Object aboutMenu;
    Object consoleMenu;
    Object modelSetInfoMenu;
    String nullModelSetName;
    String hiddenModelSetName;
    Hashtable htCheckbox = new Hashtable();

    JmolPopup(JmolViewer viewer) {
        this.viewer = viewer;
        this.jmolComponent = viewer.getAwtComponent();
        this.mil = new MenuItemListener();
    }

    public static JmolPopup newJmolPopup(JmolViewer viewer) {
        if (!viewer.isJvm12orGreater()) {
            return new JmolPopupAwt(viewer);
        }
        return new JmolPopupSwing(viewer);
    }

    void build(Object popupMenu) {
        this.addMenuItems("popupMenu", popupMenu, new PopupResourceBundle());
        this.addVersionAndDate(popupMenu);
        if (!this.viewer.isJvm12orGreater() && this.consoleMenu != null) {
            this.enableMenu(this.consoleMenu, false);
        }
    }

    public void updateComputedMenus() {
        this.updateElementsComputedMenu(this.viewer.getElementsPresentBitSet());
        this.updateAaresiduesComputedMenu(this.viewer.getGroupsPresentBitSet());
        this.updateModelSetInfoMenu();
    }

    void updateElementsComputedMenu(BitSet elementsPresentBitSet) {
        if (this.elementsComputedMenu == null || elementsPresentBitSet == null) {
            return;
        }
        this.removeAll(this.elementsComputedMenu);
        for (int i = 0; i < JmolConstants.elementNames.length; ++i) {
            if (!elementsPresentBitSet.get(i)) continue;
            String elementName = JmolConstants.elementNames[i];
            String elementSymbol = JmolConstants.elementSymbols[i];
            String entryName = elementSymbol + " - " + elementName;
            String script = "select " + elementName;
            this.addMenuItem(this.elementsComputedMenu, entryName, script);
        }
    }

    void updateAaresiduesComputedMenu(BitSet groupsPresentBitSet) {
        if (this.aaresiduesComputedMenu == null || groupsPresentBitSet == null) {
            return;
        }
        this.removeAll(this.aaresiduesComputedMenu);
        for (int i = 1; i < 23; ++i) {
            if (!groupsPresentBitSet.get(i)) continue;
            String aaresidueName = JmolConstants.predefinedGroup3Names[i];
            String script = "select " + aaresidueName;
            this.addMenuItem(this.aaresiduesComputedMenu, aaresidueName, script);
        }
    }

    void updateModelSetInfoMenu() {
        if (this.modelSetInfoMenu == null) {
            return;
        }
        this.removeAll(this.modelSetInfoMenu);
        this.renameMenu(this.modelSetInfoMenu, this.nullModelSetName);
        this.enableMenu(this.modelSetInfoMenu, false);
        String modelSetName = this.viewer.getModelSetName();
        if (modelSetName == null) {
            return;
        }
        this.renameMenu(this.modelSetInfoMenu, this.viewer.getBooleanProperty("hideNameInPopup") ? this.hiddenModelSetName : modelSetName);
        this.enableMenu(this.modelSetInfoMenu, true);
        this.addMenuItem(this.modelSetInfoMenu, "atoms:" + this.viewer.getAtomCount());
        this.addMenuItem(this.modelSetInfoMenu, "bonds:" + this.viewer.getBondCount());
        this.addMenuSeparator(this.modelSetInfoMenu);
        this.addMenuItem(this.modelSetInfoMenu, "groups:" + this.viewer.getGroupCount());
        this.addMenuItem(this.modelSetInfoMenu, "chains:" + this.viewer.getChainCount());
        this.addMenuItem(this.modelSetInfoMenu, "polymers:" + this.viewer.getPolymerCount());
        this.addMenuItem(this.modelSetInfoMenu, "models:" + this.viewer.getModelCount());
        if (this.viewer.showModelSetDownload()) {
            this.addMenuSeparator(this.modelSetInfoMenu);
            this.addMenuItem(this.modelSetInfoMenu, this.viewer.getModelSetFileName(), this.viewer.getModelSetPathName());
        }
    }

    private void addVersionAndDate(Object popupMenu) {
        if (this.aboutMenu != null) {
            this.addMenuSeparator(this.aboutMenu);
            this.addMenuItem(this.aboutMenu, "Jmol 10.00.36");
            this.addMenuItem(this.aboutMenu, JmolConstants.date);
        }
    }

    private void addMenuItems(String key, Object menu, PopupResourceBundle popupResourceBundle) {
        String value = popupResourceBundle.getStructure(key);
        if (value == null) {
            this.addMenuItem(menu, "#" + key);
            return;
        }
        StringTokenizer st = new StringTokenizer(value);
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            String word = popupResourceBundle.getWord(item);
            if (item.endsWith("Menu")) {
                Object subMenu = this.newMenu(word);
                if ("elementsComputedMenu".equals(item)) {
                    this.elementsComputedMenu = subMenu;
                } else if ("aaresiduesComputedMenu".equals(item)) {
                    this.aaresiduesComputedMenu = subMenu;
                } else {
                    this.addMenuItems(item, subMenu, popupResourceBundle);
                }
                if ("aboutMenu".equals(item)) {
                    this.aboutMenu = subMenu;
                } else if ("consoleMenu".equals(item)) {
                    this.consoleMenu = subMenu;
                } else if ("modelSetInfoMenu".equals(item)) {
                    this.nullModelSetName = word;
                    this.hiddenModelSetName = popupResourceBundle.getWord("hiddenModelSetName");
                    this.modelSetInfoMenu = subMenu;
                    this.enableMenu(this.modelSetInfoMenu, false);
                }
                this.addMenuSubMenu(menu, subMenu);
                continue;
            }
            if ("-".equals(item)) {
                this.addMenuSeparator(menu);
                continue;
            }
            if (item.endsWith("Checkbox")) {
                String basename = item.substring(0, item.length() - 8);
                this.addCheckboxMenuItem(menu, word, basename);
                continue;
            }
            this.addMenuItem(menu, word, popupResourceBundle.getStructure(item));
        }
    }

    void rememberCheckbox(String key, Object checkboxMenuItem) {
        this.htCheckbox.put(key, checkboxMenuItem);
    }

    Object addMenuItem(Object menuItem, String entry) {
        return this.addMenuItem(menuItem, entry, null);
    }

    public abstract void show(int var1, int var2);

    abstract void addMenuSeparator(Object var1);

    abstract Object addMenuItem(Object var1, String var2, String var3);

    abstract void updateMenuItem(Object var1, String var2, String var3);

    abstract void addCheckboxMenuItem(Object var1, String var2, String var3);

    abstract void addMenuSubMenu(Object var1, Object var2);

    abstract Object newMenu(String var1);

    abstract void enableMenu(Object var1, boolean var2);

    abstract void renameMenu(Object var1, String var2);

    abstract void removeAll(Object var1);

    class MenuItemListener
    implements ActionListener {
        MenuItemListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String script = e.getActionCommand();
            if (script == null || script.length() == 0) {
                return;
            }
            if (script.startsWith("http:") || script.startsWith("file:") || script.startsWith("/")) {
                JmolPopup.this.viewer.showUrl(script);
                return;
            }
            JmolPopup.this.viewer.evalStringQuiet(script);
        }
    }
}

