/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;

final class Line3D {
    Graphics3D g3d;
    static final int VISIBILITY_UNCLIPPED = 0;
    static final int VISIBILITY_CLIPPED = 1;
    static final int VISIBILITY_OFFSCREEN = 2;
    static final int zLT = 32;
    static final int zGT = 16;
    static final int xLT = 8;
    static final int xGT = 4;
    static final int yLT = 2;
    static final int yGT = 1;

    Line3D(Graphics3D g3d) {
        this.g3d = g3d;
    }

    void drawLine(int argbA, boolean tScreenedA, int argbB, boolean tScreenedB, int xA, int yA, int zA, int xB, int yB, int zB) {
        int dxBA = xB - xA;
        int dyBA = yB - yA;
        int dzBA = zB - zA;
        switch (this.visibilityCheck(xA, yA, zA, xB, yB, zB)) {
            case 0: {
                this.plotLineDeltaUnclipped(argbA, tScreenedA, argbB, tScreenedB, xA, yA, zA, dxBA, dyBA, dzBA);
                break;
            }
            case 1: {
                this.plotLineDeltaClipped(argbA, tScreenedA, argbB, tScreenedB, xA, yA, zA, dxBA, dyBA, dzBA);
            }
        }
    }

    void drawVLine(int argb, boolean tScreened, int x, int y, int z, int h, boolean checkSlab) {
        int width = this.g3d.width;
        int height = this.g3d.height;
        if (x < 0 || x >= width) {
            return;
        }
        if (checkSlab && (z < this.g3d.slab || z > this.g3d.depth)) {
            return;
        }
        if (h < 0) {
            y += h;
            h = -h;
        }
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        if (y < 0) {
            h += y;
            y = 0;
        }
        if (y + h >= height) {
            h = height - 1 - y;
        }
        int offset = x + width * y;
        if (!tScreened) {
            for (int i = 0; i <= h; ++i) {
                if (z < zbuf[offset]) {
                    zbuf[offset] = (short)z;
                    pbuf[offset] = argb;
                }
                offset += width;
            }
            return;
        }
        boolean flipflop = ((x ^ y) & 1) != 0;
        for (int i = 0; i <= h; ++i) {
            if ((flipflop = !flipflop) && z < zbuf[offset]) {
                zbuf[offset] = (short)z;
                pbuf[offset] = argb;
            }
            offset += width;
        }
    }

    void drawHLine(int argb, boolean tScreened, int x, int y, int z, int w, boolean checkSlab) {
        int width = this.g3d.width;
        int height = this.g3d.height;
        if (y < 0 || y >= height) {
            return;
        }
        if (checkSlab && (z < this.g3d.slab || z > this.g3d.depth)) {
            return;
        }
        if (w < 0) {
            x += w;
            w = -w;
        }
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        if (x < 0) {
            w += x;
            x = 0;
        }
        if (x + w >= width) {
            w = width - 1 - x;
        }
        int offset = x + width * y;
        if (!tScreened) {
            for (int i = 0; i <= w; ++i) {
                if (z < zbuf[offset]) {
                    zbuf[offset] = (short)z;
                    pbuf[offset] = argb;
                }
                ++offset;
            }
            return;
        }
        boolean flipflop = ((x ^ y) & 1) != 0;
        for (int i = 0; i <= w; ++i) {
            if ((flipflop = !flipflop) && z < zbuf[offset]) {
                zbuf[offset] = (short)z;
                pbuf[offset] = argb;
            }
            ++offset;
        }
    }

    void drawDashedLine(int argbA, boolean tScreenedA, int argbB, boolean tScreenedB, int run, int rise, int xA, int yA, int zA, int xB, int yB, int zB) {
        int dxBA = xB - xA;
        int dyBA = yB - yA;
        int dzBA = zB - zA;
        switch (this.visibilityCheck(xA, yA, zA, xB, yB, zB)) {
            case 0: {
                this.plotDashedLineDeltaUnclipped(argbA, tScreenedA, argbB, tScreenedB, run, rise, xA, yA, zA, dxBA, dyBA, dzBA);
                break;
            }
            case 1: {
                this.plotDashedLineDeltaClipped(argbA, tScreenedA, argbB, tScreenedB, run, rise, xA, yA, zA, dxBA, dyBA, dzBA);
            }
        }
    }

    int visibilityCheck(int x1, int y1, int z1, int x2, int y2, int z2) {
        int cc2;
        int cc1 = this.clipCode(x1, y1, z1);
        if ((cc1 | (cc2 = this.clipCode(x2, y2, z2))) == 0) {
            return 0;
        }
        int xLast = this.g3d.xLast;
        int yLast = this.g3d.yLast;
        int slab = this.g3d.slab;
        int depth = this.g3d.depth;
        do {
            if ((cc1 & cc2) != 0) {
                return 2;
            }
            int dx = x2 - x1;
            int dy = y2 - y1;
            int dz = z2 - z1;
            if (cc1 != 0) {
                if ((cc1 & 8) != 0) {
                    y1 += -x1 * dy / dx;
                    z1 += -x1 * dz / dx;
                    x1 = 0;
                } else if ((cc1 & 4) != 0) {
                    y1 += (xLast - x1) * dy / dx;
                    z1 += (xLast - x1) * dz / dx;
                    x1 = xLast;
                } else if ((cc1 & 2) != 0) {
                    x1 += -y1 * dx / dy;
                    z1 += -y1 * dz / dy;
                    y1 = 0;
                } else if ((cc1 & 1) != 0) {
                    x1 += (yLast - y1) * dx / dy;
                    z1 += (yLast - y1) * dz / dy;
                    y1 = yLast;
                } else if ((cc1 & 0x20) != 0) {
                    x1 += (slab - z1) * dx / dz;
                    y1 += (slab - z1) * dy / dz;
                    z1 = slab;
                } else {
                    x1 += (depth - z1) * dx / dz;
                    y1 += (depth - z1) * dy / dz;
                    z1 = depth;
                }
                cc1 = this.clipCode(x1, y1, z1);
                continue;
            }
            if ((cc2 & 8) != 0) {
                y2 += -x2 * dy / dx;
                z2 += -x2 * dz / dx;
                x2 = 0;
            } else if ((cc2 & 4) != 0) {
                y2 += (xLast - x2) * dy / dx;
                z2 += (xLast - x2) * dz / dx;
                x2 = xLast;
            } else if ((cc2 & 2) != 0) {
                x2 += -y2 * dx / dy;
                z2 += -y2 * dz / dy;
                y2 = 0;
            } else if ((cc2 & 1) != 0) {
                x2 += (yLast - y2) * dx / dy;
                z2 += (yLast - y2) * dz / dy;
                y2 = yLast;
            } else if ((cc2 & 0x20) != 0) {
                x2 += (slab - z2) * dx / dz;
                y2 += (slab - z2) * dy / dz;
                z2 = slab;
            } else {
                x2 += (depth - z2) * dx / dz;
                y2 += (depth - 2) * dy / dz;
                z2 = depth;
            }
            cc2 = this.clipCode(x2, y2, z2);
        } while ((cc1 | cc2) != 0);
        return 1;
    }

    final int clipCode(int x, int y, int z) {
        int code = 0;
        if (x < 0) {
            code |= 8;
        } else if (x >= this.g3d.width) {
            code |= 4;
        }
        if (y < 0) {
            code |= 2;
        } else if (y >= this.g3d.height) {
            code |= 1;
        }
        if (z < this.g3d.slab) {
            code |= 0x20;
        } else if (z > this.g3d.depth) {
            code |= 0x10;
        }
        return code;
    }

    void plotDashedLineDeltaUnclipped(int argb1, boolean tScreened1, int argb2, boolean tScreened2, int run, int rise, int x, int y, int z, int dx, int dy, int dz) {
        if (rise >= run) {
            this.plotLineDeltaUnclipped(argb1, tScreened1, argb2, tScreened2, x, y, z, dx, dy, dz);
            return;
        }
        int runIndex = 0;
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int offset = y * width + x;
        if (z < zbuf[offset]) {
            zbuf[offset] = (short)z;
            pbuf[offset] = argb1;
        }
        if (dx == 0 && dy == 0) {
            return;
        }
        int xIncrement = 1;
        int yOffsetIncrement = width;
        if (dx < 0) {
            dx = -dx;
            xIncrement = -1;
        }
        if (dy < 0) {
            dy = -dy;
            yOffsetIncrement = -width;
        }
        int twoDx = dx + dx;
        int twoDy = dy + dy;
        int zCurrentScaled = z << 10;
        if (dy <= dx) {
            int roundingFactor = dx - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dx;
            int twoDxAccumulatedYError = 0;
            int n = dx - 1;
            int nMid = n / 2;
            while (--n >= 0) {
                offset += xIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDxAccumulatedYError += twoDy) > dx) {
                    offset += yOffsetIncrement;
                    twoDxAccumulatedYError -= twoDx;
                }
                int zCurrent = zCurrentScaled >> 10;
                if (runIndex < rise && zCurrent < zbuf[offset]) {
                    zbuf[offset] = (short)zCurrent;
                    int n2 = pbuf[offset] = n > nMid ? argb1 : argb2;
                }
                if (++runIndex != run) continue;
                runIndex = 0;
            }
        } else {
            int roundingFactor = dy - 1;
            if (dy < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dy;
            int twoDyAccumulatedXError = 0;
            int n = dy - 1;
            int nMid = n / 2;
            while (--n >= 0) {
                offset += yOffsetIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDyAccumulatedXError += twoDx) > dy) {
                    offset += xIncrement;
                    twoDyAccumulatedXError -= twoDy;
                }
                int zCurrent = zCurrentScaled >> 10;
                if (runIndex < rise && zCurrent < zbuf[offset]) {
                    zbuf[offset] = (short)zCurrent;
                    int n3 = pbuf[offset] = n > nMid ? argb1 : argb2;
                }
                if (++runIndex != run) continue;
                runIndex = 0;
            }
        }
    }

    void plotDashedLineDeltaClipped(int argb1, boolean tScreened1, int argb2, boolean tScreened2, int run, int rise, int x, int y, int z, int dx, int dy, int dz) {
        if (rise >= run) {
            this.plotLineDeltaClipped(argb1, tScreened1, argb2, tScreened2, x, y, z, dx, dy, dz);
            return;
        }
        int runIndex = 0;
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int height = this.g3d.height;
        int slab = this.g3d.slab;
        int depth = this.g3d.depth;
        int offset = y * width + x;
        if (x >= 0 && x < width && y >= 0 && y < height && z >= slab && z <= depth && z < zbuf[offset]) {
            zbuf[offset] = (short)z;
            pbuf[offset] = argb1;
        }
        if (dx == 0 && dy == 0) {
            return;
        }
        int xCurrent = x;
        int yCurrent = y;
        int xIncrement = 1;
        int yIncrement = 1;
        int yOffsetIncrement = width;
        if (dx < 0) {
            dx = -dx;
            xIncrement = -1;
        }
        if (dy < 0) {
            dy = -dy;
            yIncrement = -1;
            yOffsetIncrement = -width;
        }
        int twoDx = dx + dx;
        int twoDy = dy + dy;
        int zCurrentScaled = z << 10;
        if (dy <= dx) {
            int roundingFactor = dx - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dx;
            int twoDxAccumulatedYError = 0;
            int n = dx - 1;
            int nMid = n / 2;
            while (--n >= 0) {
                int zCurrent;
                xCurrent += xIncrement;
                offset += xIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDxAccumulatedYError += twoDy) > dx) {
                    yCurrent += yIncrement;
                    offset += yOffsetIncrement;
                    twoDxAccumulatedYError -= twoDx;
                }
                if (runIndex < rise && xCurrent >= 0 && xCurrent < width && yCurrent >= 0 && yCurrent < height && (zCurrent = zCurrentScaled >> 10) >= slab && zCurrent <= depth && zCurrent < zbuf[offset]) {
                    zbuf[offset] = (short)zCurrent;
                    int n2 = pbuf[offset] = n > nMid ? argb1 : argb2;
                }
                if (++runIndex != run) continue;
                runIndex = 0;
            }
        } else {
            int roundingFactor = dy - 1;
            if (dy < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dy;
            int twoDyAccumulatedXError = 0;
            int n = dy - 1;
            int nMid = n / 2;
            while (--n > 0) {
                int zCurrent;
                yCurrent += yIncrement;
                offset += yOffsetIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDyAccumulatedXError += twoDx) > dy) {
                    xCurrent += xIncrement;
                    offset += xIncrement;
                    twoDyAccumulatedXError -= twoDy;
                }
                if (runIndex < rise && xCurrent >= 0 && xCurrent < width && yCurrent >= 0 && yCurrent < height && (zCurrent = zCurrentScaled >> 10) >= slab && zCurrent <= depth && zCurrent < zbuf[offset]) {
                    zbuf[offset] = (short)zCurrent;
                    int n3 = pbuf[offset] = n > nMid ? argb1 : argb2;
                }
                if (++runIndex != run) continue;
                runIndex = 0;
            }
        }
    }

    void plotLineDeltaUnclipped(int[] shades1, boolean tScreened1, int[] shades2, boolean tScreened2, int fp8Intensity, int x1, int y1, int z1, int dx, int dy, int dz) {
        boolean flipflop;
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int offset = y1 * width + x1;
        int intensity = fp8Intensity >> 8;
        int intensityUp = intensity < 63 ? intensity + 1 : intensity;
        int intensityDn = intensity > 0 ? intensity - 1 : intensity;
        int argb1 = shades1[intensity];
        int argb1Up = shades1[intensityUp];
        int argb1Dn = shades1[intensityDn];
        int argb2 = shades2[intensity];
        int argb2Up = shades2[intensityUp];
        int argb2Dn = shades2[intensityDn];
        boolean tScreened = tScreened1;
        boolean bl = flipflop = ((x1 ^ y1) & 1) != 0;
        if ((!tScreened || (flipflop = !flipflop)) && z1 < zbuf[offset]) {
            zbuf[offset] = (short)z1;
            pbuf[offset] = argb1;
        }
        if (dx == 0 && dy == 0) {
            return;
        }
        int xIncrement = 1;
        int yOffsetIncrement = width;
        if (dx < 0) {
            dx = -dx;
            xIncrement = -1;
        }
        if (dy < 0) {
            dy = -dy;
            yOffsetIncrement = -width;
        }
        int twoDx = dx + dx;
        int twoDy = dy + dy;
        int zCurrentScaled = z1 << 10;
        int argb = argb1;
        int argbUp = argb1Up;
        int argbDn = argb1Dn;
        if (dy <= dx) {
            int roundingFactor = dx - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dx;
            int twoDxAccumulatedYError = 0;
            int n = dx - 1;
            int nMid = n / 2;
            while (--n >= 0) {
                int zCurrent;
                if (n == nMid) {
                    argb = argb2;
                    argbUp = argb2Up;
                    argbDn = argb2Dn;
                    tScreened = tScreened2;
                    if (tScreened && !tScreened1) {
                        int xT = offset % width;
                        int yT = offset / width;
                        flipflop = ((xT ^ yT) & 1) == 0;
                    }
                }
                offset += xIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDxAccumulatedYError += twoDy) > dx) {
                    offset += yOffsetIncrement;
                    twoDxAccumulatedYError -= twoDx;
                    boolean bl2 = flipflop = !flipflop;
                }
                if (tScreened && !(flipflop = !flipflop) || (zCurrent = zCurrentScaled >> 10) >= zbuf[offset]) continue;
                zbuf[offset] = (short)zCurrent;
                int rand8 = Shade3D.nextRandom8Bit();
                pbuf[offset] = rand8 < 85 ? argbDn : (rand8 > 170 ? argbUp : argb);
            }
        } else {
            int roundingFactor = dy - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dy;
            int twoDyAccumulatedXError = 0;
            int n = dy - 1;
            int nMid = n / 2;
            while (--n >= 0) {
                int zCurrent;
                if (n == nMid) {
                    argb = argb2;
                    argbUp = argb2Up;
                    argbDn = argb2Dn;
                    tScreened = tScreened2;
                    if (tScreened && !tScreened1) {
                        int xT = offset % width;
                        int yT = offset / width;
                        flipflop = ((xT ^ yT) & 1) == 0;
                    }
                }
                offset += yOffsetIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDyAccumulatedXError += twoDx) > dy) {
                    offset += xIncrement;
                    twoDyAccumulatedXError -= twoDy;
                    boolean bl3 = flipflop = !flipflop;
                }
                if (tScreened && !(flipflop = !flipflop) || (zCurrent = zCurrentScaled >> 10) >= zbuf[offset]) continue;
                zbuf[offset] = (short)zCurrent;
                int rand8 = Shade3D.nextRandom8Bit();
                pbuf[offset] = rand8 < 85 ? argbDn : (rand8 > 170 ? argbUp : argb);
            }
        }
    }

    void plotLineDeltaUnclipped(int argb1, boolean tScreened1, int argb2, boolean tScreened2, int x1, int y1, int z1, int dx, int dy, int dz) {
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int offset = y1 * width + x1;
        boolean flipflop = ((x1 ^ y1) & 1) != 0;
        boolean tScreened = tScreened1;
        int argb = argb1;
        if ((!tScreened || (flipflop = !flipflop)) && z1 < zbuf[offset]) {
            zbuf[offset] = (short)z1;
            pbuf[offset] = argb1;
        }
        if (dx == 0 && dy == 0) {
            return;
        }
        int xIncrement = 1;
        int yOffsetIncrement = width;
        if (dx < 0) {
            dx = -dx;
            xIncrement = -1;
        }
        if (dy < 0) {
            dy = -dy;
            yOffsetIncrement = -width;
        }
        int twoDx = dx + dx;
        int twoDy = dy + dy;
        int zCurrentScaled = z1 << 10;
        if (dy <= dx) {
            int roundingFactor = dx - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dx;
            int twoDxAccumulatedYError = 0;
            int n = dx - 1;
            int nMid = n / 2;
            while (--n >= 0) {
                int zCurrent;
                if (n == nMid) {
                    tScreened = tScreened2;
                    argb = argb2;
                }
                offset += xIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDxAccumulatedYError += twoDy) > dx) {
                    offset += yOffsetIncrement;
                    twoDxAccumulatedYError -= twoDx;
                    boolean bl = flipflop = !flipflop;
                }
                if (tScreened && !(flipflop = !flipflop) || (zCurrent = zCurrentScaled >> 10) >= zbuf[offset]) continue;
                zbuf[offset] = (short)zCurrent;
                pbuf[offset] = argb;
            }
        } else {
            int roundingFactor = dy - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dy;
            int twoDyAccumulatedXError = 0;
            int n = dy - 1;
            int nMid = n / 2;
            while (--n >= 0) {
                int zCurrent;
                if (n == nMid) {
                    tScreened = tScreened2;
                    argb = argb2;
                }
                offset += yOffsetIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDyAccumulatedXError += twoDx) > dy) {
                    offset += xIncrement;
                    twoDyAccumulatedXError -= twoDy;
                    boolean bl = flipflop = !flipflop;
                }
                if (tScreened && !(flipflop = !flipflop) || (zCurrent = zCurrentScaled >> 10) >= zbuf[offset]) continue;
                zbuf[offset] = (short)zCurrent;
                pbuf[offset] = argb;
            }
        }
    }

    void plotLineDeltaClipped(int argb1, boolean tScreened1, int argb2, boolean tScreened2, int x1, int y1, int z1, int dx, int dy, int dz) {
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int height = this.g3d.height;
        int slab = this.g3d.slab;
        int depth = this.g3d.depth;
        int offset = y1 * width + x1;
        if (!(tScreened1 && ((x1 ^ y1) & 1) != 0 || x1 < 0 || x1 >= width || y1 < 0 || y1 >= height || z1 < slab || z1 > depth || z1 >= zbuf[offset])) {
            zbuf[offset] = (short)z1;
            pbuf[offset] = argb1;
        }
        if (dx == 0 && dy == 0) {
            return;
        }
        int xCurrent = x1;
        int yCurrent = y1;
        int xIncrement = 1;
        int yIncrement = 1;
        int yOffsetIncrement = width;
        if (dx < 0) {
            dx = -dx;
            xIncrement = -1;
        }
        if (dy < 0) {
            dy = -dy;
            yIncrement = -1;
            yOffsetIncrement = -width;
        }
        int twoDx = dx + dx;
        int twoDy = dy + dy;
        int zCurrentScaled = z1 << 10;
        boolean tScreened = tScreened1;
        int argb = argb1;
        if (dy <= dx) {
            int roundingFactor = dx - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dx;
            int twoDxAccumulatedYError = 0;
            int n = dx - 1;
            int nMid = n / 2;
            while (--n >= 0) {
                int zCurrent;
                if (n == nMid) {
                    tScreened = tScreened2;
                    argb = argb2;
                }
                xCurrent += xIncrement;
                offset += xIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDxAccumulatedYError += twoDy) > dx) {
                    yCurrent += yIncrement;
                    offset += yOffsetIncrement;
                    twoDxAccumulatedYError -= twoDx;
                }
                if (xCurrent < 0 || xCurrent >= width || yCurrent < 0 || yCurrent >= height || tScreened && ((xCurrent ^ yCurrent) & 1) != 0 || (zCurrent = zCurrentScaled >> 10) < slab || zCurrent > depth || zCurrent >= zbuf[offset]) continue;
                zbuf[offset] = (short)zCurrent;
                pbuf[offset] = argb;
            }
        } else {
            int roundingFactor = dy - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dy;
            int twoDyAccumulatedXError = 0;
            int n = dy - 1;
            int nMid = n / 2;
            while (--n >= 0) {
                int zCurrent;
                if (n == nMid) {
                    tScreened = tScreened2;
                    argb = argb2;
                }
                yCurrent += yIncrement;
                offset += yOffsetIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDyAccumulatedXError += twoDx) > dy) {
                    xCurrent += xIncrement;
                    offset += xIncrement;
                    twoDyAccumulatedXError -= twoDy;
                }
                if (xCurrent < 0 || xCurrent >= width || yCurrent < 0 || yCurrent >= height || tScreened && ((xCurrent ^ yCurrent) & 1) != 0 || (zCurrent = zCurrentScaled >> 10) < slab || zCurrent > depth || zCurrent >= zbuf[offset]) continue;
                zbuf[offset] = (short)zCurrent;
                pbuf[offset] = argb;
            }
        }
    }

    void plotLineDeltaClipped(int[] shades1, boolean tScreened1, int[] shades2, boolean tScreened2, int fp8Intensity, int x1, int y1, int z1, int dx, int dy, int dz) {
        int intensity = fp8Intensity >> 8;
        int argb1 = shades1[intensity];
        int argb2 = shades2[intensity];
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int height = this.g3d.height;
        int slab = this.g3d.slab;
        int depth = this.g3d.depth;
        int offset = y1 * width + x1;
        if (!(tScreened1 && ((x1 ^ y1) & 1) != 0 || x1 < 0 || x1 >= width || y1 < 0 || y1 >= height || z1 < slab || z1 > depth || z1 >= zbuf[offset])) {
            zbuf[offset] = (short)z1;
            pbuf[offset] = argb1;
        }
        if (dx == 0 && dy == 0) {
            return;
        }
        int xCurrent = x1;
        int yCurrent = y1;
        int xIncrement = 1;
        int yIncrement = 1;
        int yOffsetIncrement = width;
        if (dx < 0) {
            dx = -dx;
            xIncrement = -1;
        }
        if (dy < 0) {
            dy = -dy;
            yIncrement = -1;
            yOffsetIncrement = -width;
        }
        int twoDx = dx + dx;
        int twoDy = dy + dy;
        int zCurrentScaled = z1 << 10;
        boolean tScreened = tScreened1;
        int argb = argb1;
        if (dy <= dx) {
            int roundingFactor = dx - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dx;
            int twoDxAccumulatedYError = 0;
            int n = dx - 1;
            int nMid = n / 2;
            while (--n >= 0) {
                int zCurrent;
                if (n == nMid) {
                    tScreened = tScreened2;
                    argb = argb2;
                }
                xCurrent += xIncrement;
                offset += xIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDxAccumulatedYError += twoDy) > dx) {
                    yCurrent += yIncrement;
                    offset += yOffsetIncrement;
                    twoDxAccumulatedYError -= twoDx;
                }
                if (xCurrent < 0 || xCurrent >= width || yCurrent < 0 || yCurrent >= height || tScreened && ((xCurrent ^ yCurrent) & 1) != 0 || (zCurrent = zCurrentScaled >> 10) < slab || zCurrent > depth || zCurrent >= zbuf[offset]) continue;
                zbuf[offset] = (short)zCurrent;
                pbuf[offset] = argb;
            }
        } else {
            int roundingFactor = dy - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dy;
            int twoDyAccumulatedXError = 0;
            int n = dy - 1;
            int nMid = n / 2;
            while (--n >= 0) {
                int zCurrent;
                if (n == nMid) {
                    argb = argb2;
                    tScreened = tScreened2;
                }
                yCurrent += yIncrement;
                offset += yOffsetIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDyAccumulatedXError += twoDx) > dy) {
                    xCurrent += xIncrement;
                    offset += xIncrement;
                    twoDyAccumulatedXError -= twoDy;
                }
                if (xCurrent < 0 || xCurrent >= width || yCurrent < 0 || yCurrent >= height || tScreened && ((xCurrent ^ yCurrent) & 1) != 0 || (zCurrent = zCurrentScaled >> 10) < slab || zCurrent > depth || zCurrent >= zbuf[offset]) continue;
                zbuf[offset] = (short)zCurrent;
                pbuf[offset] = argb;
            }
        }
    }
}

