/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Platform3D;

class Text3D {
    Component component;
    int height;
    int ascent;
    int width;
    int size;
    int[] bitmap;
    static Hashtable htFont3d = new Hashtable();

    Text3D(String text, Font3D font3d, Platform3D platform) {
        this.calcMetrics(text, font3d);
        platform.checkOffscreenSize(this.width, this.height);
        this.renderOffscreen(text, font3d, platform);
        this.rasterize(platform);
    }

    void calcMetrics(String text, Font3D font3d) {
        FontMetrics fontMetrics = font3d.fontMetrics;
        this.ascent = fontMetrics.getAscent();
        this.height = this.ascent + fontMetrics.getDescent();
        this.width = fontMetrics.stringWidth(text);
        this.size = this.width * this.height;
    }

    void renderOffscreen(String text, Font3D font3d, Platform3D platform) {
        Graphics g = platform.gOffscreen;
        g.setColor(Color.black);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.white);
        g.setFont(font3d.font);
        g.drawString(text, 0, this.ascent);
    }

    void rasterize(Platform3D platform) {
        PixelGrabber pixelGrabber = new PixelGrabber(platform.imageOffscreen, 0, 0, this.width, this.height, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException e) {
            System.out.println("Que? 7748");
        }
        int[] pixels = (int[])pixelGrabber.getPixels();
        int bitmapSize = this.size + 31 >> 5;
        this.bitmap = new int[bitmapSize];
        int shifter = 0;
        int offset = 0;
        while (offset < this.size) {
            if ((pixels[offset] & 0xFFFFFF) != 0) {
                shifter |= 1;
            }
            if ((offset & 0x1F) == 31) {
                this.bitmap[offset >> 5] = shifter;
            }
            ++offset;
            shifter <<= 1;
        }
        if ((offset & 0x1F) != 0) {
            this.bitmap[offset >> 5] = shifter <<= 31 - (offset & 0x1F);
        }
    }

    static synchronized Text3D getText3D(String text, Font3D font3d, Platform3D platform) {
        Text3D text3d;
        Hashtable<String, Text3D> htForThisFont = (Hashtable<String, Text3D>)htFont3d.get(font3d);
        if (htForThisFont != null) {
            text3d = (Text3D)htForThisFont.get(text);
            if (text3d != null) {
                return text3d;
            }
        } else {
            htForThisFont = new Hashtable<String, Text3D>();
            htFont3d.put(font3d, htForThisFont);
        }
        text3d = new Text3D(text, font3d, platform);
        htForThisFont.put(text, text3d);
        return text3d;
    }

    static void plot(int x, int y, int z, int argb, int argbBackground, String text, Font3D font3d, Graphics3D g3d) {
        Text3D text3d = Text3D.getText3D(text, font3d, g3d.platform);
        int[] bitmap = text3d.bitmap;
        int textWidth = text3d.width;
        int textHeight = text3d.height;
        if (x + textWidth < 0 || x > g3d.width || y + textHeight < 0 || y > g3d.height) {
            return;
        }
        if (x < 0 || x + textWidth > g3d.width || y < 0 || y + textHeight > g3d.height) {
            Text3D.plotClipped(x, y, z, argb, argbBackground, g3d, textWidth, textHeight, bitmap);
        } else {
            Text3D.plotUnclipped(x, y, z, argb, argbBackground, g3d, textWidth, textHeight, bitmap);
        }
    }

    static void plotUnclipped(int x, int y, int z, int argb, int argbBackground, Graphics3D g3d, int textWidth, int textHeight, int[] bitmap) {
        int offset = 0;
        int shiftregister = 0;
        int i = 0;
        int j = 0;
        short[] zbuf = g3d.zbuf;
        int[] pbuf = g3d.pbuf;
        int screenWidth = g3d.width;
        int pbufOffset = y * screenWidth + x;
        while (i < textHeight) {
            while (j < textWidth) {
                if ((offset & 0x1F) == 0) {
                    shiftregister = bitmap[offset >> 5];
                }
                if (shiftregister == 0 && argbBackground == 0) {
                    int skip = 32 - (offset & 0x1F);
                    j += skip;
                    offset += skip;
                    pbufOffset += skip;
                    continue;
                }
                if ((shiftregister < 0 || argbBackground != 0) && z < zbuf[pbufOffset]) {
                    zbuf[pbufOffset] = (short)z;
                    pbuf[pbufOffset] = shiftregister < 0 ? argb : argbBackground;
                }
                shiftregister <<= 1;
                ++offset;
                ++j;
                ++pbufOffset;
            }
            while (j >= textWidth) {
                ++i;
                j -= textWidth;
                pbufOffset += screenWidth - textWidth;
            }
        }
    }

    static void plotClipped(int x, int y, int z, int argb, int argbBackground, Graphics3D g3d, int textWidth, int textHeight, int[] bitmap) {
        int offset = 0;
        int shiftregister = 0;
        int i = 0;
        int j = 0;
        while (i < textHeight) {
            while (j < textWidth) {
                if ((offset & 0x1F) == 0) {
                    shiftregister = bitmap[offset >> 5];
                }
                if (shiftregister == 0 && argbBackground == 0) {
                    int skip = 32 - (offset & 0x1F);
                    j += skip;
                    offset += skip;
                    continue;
                }
                if (shiftregister < 0 || argbBackground != 0) {
                    g3d.plotPixelClipped(shiftregister < 0 ? argb : argbBackground, x + j, y + i, z);
                }
                shiftregister <<= 1;
                ++offset;
                ++j;
            }
            while (j >= textWidth) {
                ++i;
                j -= textWidth;
            }
        }
    }
}

