/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.viewer.AlphaPolymer;
import org.jmol.viewer.AminoMonomer;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Monomer;

class AminoPolymer
extends AlphaPolymer {
    short[] mainchainHbondOffsets;
    short[] min1Indexes;
    short[] min1Energies;
    short[] min2Indexes;
    short[] min2Energies;
    boolean hbondsAlreadyCalculated;
    static final boolean debugHbonds = false;
    final Vector3f vectorPreviousOC = new Vector3f();
    final Point3f aminoHydrogenPoint = new Point3f();
    private static final float maxHbondAlphaDistance = 9.0f;
    private static final float maxHbondAlphaDistance2 = 81.0f;
    private static final float minimumHbondDistance2 = 0.5f;
    private static final double QConst = -27888.0;

    AminoPolymer(Monomer[] monomers) {
        super(monomers);
    }

    boolean hasWingPoints() {
        return true;
    }

    void calcHydrogenBonds() {
        if (!this.hbondsAlreadyCalculated) {
            this.allocateHbondDataStructures();
            this.calcProteinMainchainHydrogenBonds();
            this.hbondsAlreadyCalculated = true;
        }
    }

    void allocateHbondDataStructures() {
        this.mainchainHbondOffsets = new short[this.monomerCount];
        this.min1Indexes = new short[this.monomerCount];
        this.min1Energies = new short[this.monomerCount];
        this.min2Indexes = new short[this.monomerCount];
        this.min2Energies = new short[this.monomerCount];
        int i = this.monomerCount;
        while (--i >= 0) {
            this.min2Indexes[i] = -1;
            this.min1Indexes[i] = -1;
        }
    }

    void freeHbondDataStructures() {
        this.min2Energies = null;
        this.min2Indexes = null;
        this.min1Energies = null;
        this.min1Indexes = null;
        this.mainchainHbondOffsets = null;
    }

    void calcProteinMainchainHydrogenBonds() {
        for (int i = 0; i < this.monomerCount; ++i) {
            AminoMonomer residue = (AminoMonomer)this.monomers[i];
            this.mainchainHbondOffsets[i] = 0;
            if (i > 0 && residue.getGroupID() != 15) {
                Point3f nitrogenPoint = residue.getNitrogenAtomPoint();
                this.aminoHydrogenPoint.add((Tuple3f)nitrogenPoint, (Tuple3f)this.vectorPreviousOC);
                this.bondAminoHydrogen(i, this.aminoHydrogenPoint);
            }
            Point3f carbonPoint = residue.getCarbonylCarbonAtomPoint();
            Point3f oxygenPoint = residue.getCarbonylOxygenAtomPoint();
            this.vectorPreviousOC.sub((Tuple3f)carbonPoint, (Tuple3f)oxygenPoint);
        }
    }

    void bondAminoHydrogen(int indexDonor, Point3f hydrogenPoint) {
        AminoMonomer source = (AminoMonomer)this.monomers[indexDonor];
        Point3f sourceAlphaPoint = source.getLeadAtomPoint();
        Point3f sourceNitrogenPoint = source.getNitrogenAtomPoint();
        int energyMin1 = 0;
        int energyMin2 = 0;
        int indexMin1 = -1;
        int indexMin2 = -1;
        int i = this.monomerCount;
        while (--i >= 0) {
            AminoMonomer target;
            Point3f targetAlphaPoint;
            float dist2;
            if (i == indexDonor || i + 1 == indexDonor || i - 1 == indexDonor || (dist2 = sourceAlphaPoint.distanceSquared(targetAlphaPoint = (target = (AminoMonomer)this.monomers[i]).getLeadAtomPoint())) > 81.0f) continue;
            int energy = this.calcHbondEnergy(sourceNitrogenPoint, hydrogenPoint, target);
            if (energy < energyMin1) {
                energyMin2 = energyMin1;
                indexMin2 = indexMin1;
                energyMin1 = energy;
                indexMin1 = i;
                continue;
            }
            if (energy >= energyMin2) continue;
            energyMin2 = energy;
            indexMin2 = i;
        }
        if (indexMin1 >= 0) {
            this.mainchainHbondOffsets[indexDonor] = (short)(indexDonor - indexMin1);
            this.min1Indexes[indexDonor] = (short)indexMin1;
            this.min1Energies[indexDonor] = (short)energyMin1;
            this.createResidueHydrogenBond(indexDonor, indexMin1);
            if (indexMin2 >= 0) {
                this.createResidueHydrogenBond(indexDonor, indexMin2);
                this.min2Indexes[indexDonor] = (short)indexMin2;
                this.min2Energies[indexDonor] = (short)energyMin2;
            }
        }
    }

    int calcHbondEnergy(Point3f nitrogenPoint, Point3f hydrogenPoint, AminoMonomer target) {
        double distON;
        double distCN;
        double distCH;
        Point3f targetOxygenPoint = target.getCarbonylOxygenAtomPoint();
        float distOH2 = targetOxygenPoint.distanceSquared(hydrogenPoint);
        if (distOH2 < 0.5f) {
            return -9900;
        }
        Point3f targetCarbonPoint = target.getCarbonylCarbonAtomPoint();
        float distCH2 = targetCarbonPoint.distanceSquared(hydrogenPoint);
        if (distCH2 < 0.5f) {
            return -9900;
        }
        float distCN2 = targetCarbonPoint.distanceSquared(nitrogenPoint);
        if (distCN2 < 0.5f) {
            return -9900;
        }
        float distON2 = targetOxygenPoint.distanceSquared(nitrogenPoint);
        if (distON2 < 0.5f) {
            return -9900;
        }
        double distOH = Math.sqrt(distOH2);
        int energy = (int)(-27888.0 / distOH - -27888.0 / (distCH = Math.sqrt(distCH2)) + -27888.0 / (distCN = Math.sqrt(distCN2)) - -27888.0 / (distON = Math.sqrt(distON2)));
        if (energy < -9900) {
            return -9900;
        }
        if (energy > -500) {
            return 0;
        }
        return energy;
    }

    void createResidueHydrogenBond(int indexAminoGroup, int indexCarbonylGroup) {
        int order;
        int aminoBackboneHbondOffset = indexAminoGroup - indexCarbonylGroup;
        switch (aminoBackboneHbondOffset) {
            case 2: {
                order = 128;
                break;
            }
            case 3: {
                order = 192;
                break;
            }
            case 4: {
                order = 256;
                break;
            }
            case 5: {
                order = 320;
                break;
            }
            case -3: {
                order = 384;
                break;
            }
            case -4: {
                order = 448;
                break;
            }
            default: {
                order = 64;
            }
        }
        AminoMonomer donor = (AminoMonomer)this.monomers[indexAminoGroup];
        Atom nitrogen = donor.getNitrogenAtom();
        AminoMonomer recipient = (AminoMonomer)this.monomers[indexCarbonylGroup];
        Atom oxygen = recipient.getCarbonylOxygenAtom();
        Frame frame = this.model.mmset.frame;
        frame.bondAtoms(nitrogen, oxygen, order);
    }

    void calculateStructures() {
        int iMax;
        this.calcHydrogenBonds();
        char[] structureTags = new char[this.monomerCount];
        this.findHelixes(structureTags);
        int iStart = 0;
        while (iStart < this.monomerCount) {
            if (structureTags[iStart] == '\u0000') {
                ++iStart;
                continue;
            }
            for (iMax = iStart + 1; iMax < this.monomerCount && structureTags[iMax] != '\u0000'; ++iMax) {
            }
            this.addSecondaryStructure((byte)3, iStart, iMax - 1);
            iStart = iMax;
        }
        int i = this.monomerCount;
        while (--i >= 0) {
            structureTags[i] = '\u0000';
        }
        this.findSheets(structureTags);
        iStart = 0;
        while (iStart < this.monomerCount) {
            if (structureTags[iStart] == '\u0000') {
                ++iStart;
                continue;
            }
            for (iMax = iStart + 1; iMax < this.monomerCount && structureTags[iMax] != '\u0000' || iMax < this.monomerCount - 1 && structureTags[iMax + 1] != '\u0000'; ++iMax) {
            }
            if (iMax - iStart >= 3) {
                this.addSecondaryStructure((byte)2, iStart, iMax - 1);
            }
            iStart = iMax;
        }
    }

    void findHelixes(char[] structureTags) {
        this.findPitch(3, 4, '4', structureTags);
    }

    void findPitch(int minRunLength, int pitch, char tag, char[] tags) {
        int runLength = 0;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (this.mainchainHbondOffsets[i] == pitch) {
                if (++runLength == minRunLength) {
                    int j = minRunLength;
                    while (--j >= 0) {
                        tags[i - j] = tag;
                    }
                    continue;
                }
                if (runLength <= minRunLength) continue;
                tags[i] = tag;
                continue;
            }
            runLength = 0;
        }
    }

    void findSheets(char[] structureTags) {
        for (int a = 0; a < this.monomerCount; ++a) {
            for (int b = 0; b < this.monomerCount; ++b) {
                if (this.isHbonded(a + 1, b) && this.isHbonded(b, a - 1)) {
                    structureTags[a - 1] = 112;
                    structureTags[b] = 112;
                    structureTags[a + 1] = 112;
                    continue;
                }
                if (this.isHbonded(a, b) && this.isHbonded(b, a)) {
                    structureTags[b] = 97;
                    structureTags[a] = 97;
                    continue;
                }
                if (!this.isHbonded(a + 1, b - 1) || !this.isHbonded(b + 1, a - 1)) continue;
                structureTags[a - 1] = 65;
                structureTags[b + 1] = 65;
                structureTags[b - 1] = 65;
                structureTags[a + 1] = 65;
            }
        }
    }

    boolean isHbonded(int indexDonor, int indexAcceptor) {
        if (indexDonor < 0 || indexDonor >= this.monomerCount || indexAcceptor < 0 || indexAcceptor >= this.monomerCount) {
            return false;
        }
        return this.min1Indexes[indexDonor] == indexAcceptor && this.min1Energies[indexDonor] <= -500 || this.min2Indexes[indexDonor] == indexAcceptor && this.min2Energies[indexDonor] <= -500;
    }
}

