/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.SelectionIndependentShape;
import org.jmol.viewer.Util;

abstract class MeshCollection
extends SelectionIndependentShape {
    int meshCount;
    Mesh[] meshes = new Mesh[4];
    Mesh currentMesh;
    int ichNextParse;
    static final float[] decimalScale = new float[]{0.1f, 0.01f, 0.001f, 1.0E-4f, 1.0E-5f, 1.0E-6f, 1.0E-7f, 1.0E-8f};
    static final float[] tensScale = new float[]{10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f};

    MeshCollection() {
    }

    void initShape() {
        this.colix = (short)5;
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        int i;
        if ("meshID" == propertyName) {
            String meshID = (String)value;
            if (meshID == null) {
                this.currentMesh = null;
                return;
            }
            int i2 = this.meshCount;
            while (--i2 >= 0) {
                this.currentMesh = this.meshes[i2];
                if (!meshID.equals(this.currentMesh.meshID)) continue;
                return;
            }
            this.allocMesh(meshID);
            return;
        }
        if ("on" == propertyName) {
            if (this.currentMesh != null) {
                this.currentMesh.visible = true;
            } else {
                int i3 = this.meshCount;
                while (--i3 >= 0) {
                    this.meshes[i3].visible = true;
                }
            }
            return;
        }
        if ("off" == propertyName) {
            if (this.currentMesh != null) {
                this.currentMesh.visible = false;
            } else {
                int i4 = this.meshCount;
                while (--i4 >= 0) {
                    this.meshes[i4].visible = false;
                }
            }
            return;
        }
        if ("color" == propertyName) {
            if (value != null) {
                this.colix = Graphics3D.getColix((Object)value);
                if (this.currentMesh != null) {
                    this.currentMesh.colix = this.colix;
                } else {
                    int i5 = this.meshCount;
                    while (--i5 >= 0) {
                        this.meshes[i5].colix = this.colix;
                    }
                }
            }
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent;
            boolean bl = isTranslucent = "translucent" == value;
            if (this.currentMesh != null) {
                this.currentMesh.colix = Graphics3D.setTranslucent((short)this.currentMesh.colix, (boolean)isTranslucent);
            } else {
                i = this.meshCount;
                while (--i >= 0) {
                    this.meshes[i].colix = Graphics3D.setTranslucent((short)this.meshes[i].colix, (boolean)isTranslucent);
                }
            }
        }
        if ("dots" == propertyName) {
            boolean showDots;
            boolean bl = showDots = value == Boolean.TRUE;
            if (this.currentMesh != null) {
                this.currentMesh.showPoints = showDots;
            } else {
                i = this.meshCount;
                while (--i >= 0) {
                    this.meshes[i].showPoints = showDots;
                }
            }
            return;
        }
        if ("mesh" == propertyName) {
            boolean showMesh;
            boolean bl = showMesh = value == Boolean.TRUE;
            if (this.currentMesh != null) {
                this.currentMesh.drawTriangles = showMesh;
            } else {
                i = this.meshCount;
                while (--i >= 0) {
                    this.meshes[i].drawTriangles = showMesh;
                }
            }
            return;
        }
        if ("fill" == propertyName) {
            boolean showFill;
            boolean bl = showFill = value == Boolean.TRUE;
            if (this.currentMesh != null) {
                this.currentMesh.fillTriangles = showFill;
            } else {
                i = this.meshCount;
                while (--i >= 0) {
                    this.meshes[i].fillTriangles = showFill;
                }
            }
            return;
        }
        if ("delete" == propertyName) {
            if (this.currentMesh != null) {
                int iCurrent = this.meshCount;
                while (this.meshes[--iCurrent] != this.currentMesh) {
                }
                for (int j = iCurrent + 1; j < this.meshCount; ++j) {
                    this.meshes[j - 1] = this.meshes[j];
                }
                this.meshes[--this.meshCount] = null;
                this.currentMesh = null;
            } else {
                int i6 = this.meshCount;
                while (--i6 >= 0) {
                    this.meshes[i6] = null;
                }
                this.meshCount = 0;
            }
            return;
        }
    }

    void allocMesh(String meshID) {
        this.meshes = (Mesh[])Util.ensureLength(this.meshes, this.meshCount + 1);
        Mesh mesh = new Mesh(meshID, this.g3d, this.colix);
        this.meshes[this.meshCount++] = mesh;
        this.currentMesh = mesh;
    }

    float parseFloat(String str) {
        return this.parseFloatChecked(str, 0, str.length());
    }

    float parseFloat(String str, int ich) {
        int cch = str.length();
        if (ich >= cch) {
            return Float.NaN;
        }
        return this.parseFloatChecked(str, ich, cch);
    }

    float parseFloat(String str, int ichStart, int ichMax) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (ichStart >= ichMax) {
            return Float.NaN;
        }
        return this.parseFloatChecked(str, ichStart, ichMax);
    }

    float parseFloatChecked(String str, int ichStart, int ichMax) {
        char ch;
        int ich;
        boolean digitSeen = false;
        float value = 0.0f;
        for (ich = ichStart; ich < ichMax && ((ch = str.charAt(ich)) == ' ' || ch == '\t'); ++ich) {
        }
        boolean negative = false;
        if (ich < ichMax && str.charAt(ich) == '-') {
            ++ich;
            negative = true;
        }
        ch = '\u0000';
        while (ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
            value = value * 10.0f + (float)(ch - 48);
            ++ich;
            digitSeen = true;
        }
        if (ch == '.') {
            int iscale = 0;
            while (++ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
                if (iscale < decimalScale.length) {
                    value += (float)(ch - 48) * decimalScale[iscale];
                }
                ++iscale;
                digitSeen = true;
            }
        }
        if (!digitSeen) {
            value = Float.NaN;
        } else if (negative) {
            value = -value;
        }
        if (ich < ichMax && (ch == 'E' || ch == 'e')) {
            if (++ich >= ichMax) {
                return Float.NaN;
            }
            ch = str.charAt(ich);
            if (ch == '+' && ++ich >= ichMax) {
                return Float.NaN;
            }
            int exponent = this.parseIntChecked(str, ich, ichMax);
            if (exponent == Integer.MIN_VALUE) {
                return Float.NaN;
            }
            if (exponent > 0) {
                value = (float)((double)value * (exponent < tensScale.length ? (double)tensScale[exponent - 1] : Math.pow(10.0, exponent)));
            } else if (exponent < 0) {
                value = (float)((double)value * (-exponent < decimalScale.length ? (double)decimalScale[-exponent - 1] : Math.pow(10.0, exponent)));
            }
        } else {
            this.ichNextParse = ich;
        }
        return value;
    }

    int parseInt(String str) {
        return this.parseIntChecked(str, 0, str.length());
    }

    int parseInt(String str, int ich) {
        int cch = str.length();
        if (ich >= cch) {
            return Integer.MIN_VALUE;
        }
        return this.parseIntChecked(str, ich, cch);
    }

    int parseInt(String str, int ichStart, int ichMax) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (ichStart >= ichMax) {
            return Integer.MIN_VALUE;
        }
        return this.parseIntChecked(str, ichStart, ichMax);
    }

    int parseIntChecked(String str, int ichStart, int ichMax) {
        char ch;
        int ich;
        boolean digitSeen = false;
        int value = 0;
        for (ich = ichStart; ich < ichMax && ((ch = str.charAt(ich)) == ' ' || ch == '\t'); ++ich) {
        }
        boolean negative = false;
        if (ich < ichMax && str.charAt(ich) == '-') {
            negative = true;
            ++ich;
        }
        while (ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
            value = value * 10 + (ch - 48);
            digitSeen = true;
            ++ich;
        }
        if (!digitSeen) {
            value = Integer.MIN_VALUE;
        } else if (negative) {
            value = -value;
        }
        this.ichNextParse = ich;
        return value;
    }
}

