/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Mmset;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.Util;

final class Model {
    Mmset mmset;
    int modelIndex;
    String modelTag;
    private int chainCount = 0;
    private Chain[] chains = new Chain[8];
    private int polymerCount = 0;
    private Polymer[] polymers = new Polymer[8];

    Model(Mmset mmset, int modelIndex, String modelTag) {
        this.mmset = mmset;
        this.modelIndex = modelIndex;
        this.modelTag = modelTag;
    }

    void freeze() {
        this.chains = (Chain[])Util.setLength(this.chains, this.chainCount);
        for (int i = 0; i < this.chainCount; ++i) {
            this.chains[i].freeze();
        }
        this.polymers = (Polymer[])Util.setLength(this.polymers, this.polymerCount);
    }

    void addSecondaryStructure(byte type, char startChainID, int startSeqcode, char endChainID, int endSeqcode) {
        int i = this.polymerCount;
        while (--i >= 0) {
            Polymer polymer = this.polymers[i];
            polymer.addSecondaryStructure(type, startChainID, startSeqcode, endChainID, endSeqcode);
        }
    }

    void calculateStructures() {
        int i = this.polymerCount;
        while (--i >= 0) {
            this.polymers[i].calculateStructures();
        }
    }

    int getChainCount() {
        return this.chainCount;
    }

    int getPolymerCount() {
        return this.polymerCount;
    }

    void calcSelectedGroupsCount(BitSet bsSelected) {
        int i = this.chainCount;
        while (--i >= 0) {
            this.chains[i].calcSelectedGroupsCount(bsSelected);
        }
    }

    void calcSelectedMonomersCount(BitSet bsSelected) {
        int i = this.polymerCount;
        while (--i >= 0) {
            this.polymers[i].calcSelectedMonomersCount(bsSelected);
        }
    }

    void selectSeqcodeRange(int seqcodeA, int seqcodeB, BitSet bs) {
        int i = this.chainCount;
        while (--i >= 0) {
            this.chains[i].selectSeqcodeRange(seqcodeA, seqcodeB, bs);
        }
    }

    int getGroupCount() {
        int groupCount = 0;
        int i = this.chainCount;
        while (--i >= 0) {
            groupCount += this.chains[i].getGroupCount();
        }
        return groupCount;
    }

    Chain getChain(char chainID) {
        int i = this.chainCount;
        while (--i >= 0) {
            Chain chain = this.chains[i];
            if (chain.chainID != chainID) continue;
            return chain;
        }
        return null;
    }

    Chain getOrAllocateChain(char chainID) {
        Chain chain = this.getChain(chainID);
        if (chain != null) {
            return chain;
        }
        if (this.chainCount == this.chains.length) {
            this.chains = (Chain[])Util.doubleLength(this.chains);
        }
        Chain chain2 = new Chain(this.mmset.frame, this, chainID);
        this.chains[this.chainCount++] = chain2;
        return chain2;
    }

    void addPolymer(Polymer polymer) {
        if (this.polymerCount == this.polymers.length) {
            this.polymers = (Polymer[])Util.doubleLength(this.polymers);
        }
        this.polymers[this.polymerCount++] = polymer;
    }

    Polymer getPolymer(int polymerIndex) {
        return this.polymers[polymerIndex];
    }

    void calcHydrogenBonds() {
        int i = this.polymerCount;
        while (--i >= 0) {
            this.polymers[i].calcHydrogenBonds();
        }
    }
}

