/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.ui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jmol.api.JmolViewer;
import org.openscience.jmol.ui.JmolPopup;

public class JmolPopupSwing
extends JmolPopup {
    JPopupMenu swingPopup = new JPopupMenu("Jmol");
    CheckboxMenuItemListener cmil = new CheckboxMenuItemListener();
    JMenu elementComputedMenu;

    public JmolPopupSwing(JmolViewer viewer) {
        super(viewer);
        this.build(this.swingPopup);
    }

    public void show(int x, int y) {
        Enumeration keys = this.htCheckbox.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            JCheckBoxMenuItem jcbmi = (JCheckBoxMenuItem)this.htCheckbox.get(key);
            boolean b = this.viewer.getBooleanProperty(key);
            jcbmi.setState(b);
        }
        this.swingPopup.show(this.jmolComponent, x, y);
    }

    void addToMenu(Object menu, JComponent item) {
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(item);
        } else if (menu instanceof JMenu) {
            ((JMenu)menu).add(item);
        } else {
            System.out.println("cannot add object to menu:" + menu);
        }
    }

    void addMenuSeparator(Object menu) {
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).addSeparator();
        } else {
            ((JMenu)menu).addSeparator();
        }
    }

    Object addMenuItem(Object menu, String entry, String script) {
        JMenuItem jmi = new JMenuItem(entry);
        this.updateMenuItem(jmi, entry, script);
        jmi.addActionListener(this.mil);
        this.addToMenu(menu, jmi);
        return jmi;
    }

    void updateMenuItem(Object menuItem, String entry, String script) {
        JMenuItem jmi = (JMenuItem)menuItem;
        jmi.setLabel(entry);
        jmi.setActionCommand(script);
    }

    void addCheckboxMenuItem(Object menu, String entry, String basename) {
        JCheckBoxMenuItem jcmi = new JCheckBoxMenuItem(entry);
        jcmi.addItemListener(this.cmil);
        jcmi.setActionCommand(basename);
        this.addToMenu(menu, jcmi);
        this.rememberCheckbox(basename, jcmi);
    }

    void addMenuSubMenu(Object menu, Object subMenu) {
        this.addToMenu(menu, (JMenu)subMenu);
    }

    Object newMenu(String menuName) {
        return new JMenu(menuName);
    }

    void renameMenu(Object menu, String newMenuName) {
        ((JMenu)menu).setLabel(newMenuName);
    }

    Object newComputedMenu(String key, String word) {
        if ("elementComputedMenu".equals(key)) {
            this.elementComputedMenu = new JMenu(word);
            return this.elementComputedMenu;
        }
        return new JMenu("unrecognized ComputedMenu:" + key);
    }

    void removeAll(Object menu) {
        ((JMenu)menu).removeAll();
    }

    void enableMenu(Object menu, boolean enable) {
        ((JMenu)menu).setEnabled(enable);
    }

    class CheckboxMenuItemListener
    implements ItemListener {
        CheckboxMenuItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            JCheckBoxMenuItem jcmi = (JCheckBoxMenuItem)e.getSource();
            JmolPopupSwing.this.viewer.setBooleanProperty(jcmi.getActionCommand(), jcmi.getState());
        }
    }
}

