/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class MopacReader
extends AtomSetCollectionReader {
    String frameInfo;
    int baseAtomIndex;
    private boolean chargesFound = false;

    MopacReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader input) throws Exception {
        String line;
        this.atomSetCollection = new AtomSetCollection("mopac");
        this.frameInfo = null;
        while ((line = input.readLine()) != null && !line.startsWith(" ---")) {
            if (line.indexOf("MOLECULAR POINT GROUP") >= 0 || !line.trim().equals("CARTESIAN COORDINATES")) continue;
            System.out.println("Found input structure...");
            this.processCoordinates(input);
            this.atomSetCollection.setAtomSetName("Input Structure");
        }
        while ((line = input.readLine()) != null) {
            if (line.indexOf("TOTAL ENERGY") >= 0) {
                this.processTotalEnergy(line);
                continue;
            }
            if (line.indexOf("ATOMIC CHARGES") >= 0) {
                this.processAtomicCharges(input);
                continue;
            }
            if (line.trim().equals("CARTESIAN COORDINATES")) {
                this.processCoordinates(input);
                continue;
            }
            if (line.indexOf("ORIENTATION OF MOLECULE IN FORCE") >= 0) {
                this.processCoordinates(input);
                this.atomSetCollection.setAtomSetName("Orientation in Force Field");
                continue;
            }
            if (line.indexOf("NORMAL COORDINATE ANALYSIS") < 0) continue;
            this.processFrequencies(input);
        }
        return this.atomSetCollection;
    }

    void processTotalEnergy(String line) {
        this.frameInfo = line.trim();
    }

    void processAtomicCharges(BufferedReader input) throws Exception {
        int atomNumber;
        String line;
        this.discardLines(input, 2);
        System.out.println("Reading atomic charges");
        this.atomSetCollection.newAtomSet();
        this.baseAtomIndex = this.atomSetCollection.atomCount;
        int expectedAtomNumber = 0;
        while ((line = input.readLine()) != null && (atomNumber = this.parseInt(line)) != Integer.MIN_VALUE) {
            if (atomNumber != ++expectedAtomNumber) {
                throw new Exception("unexpected atom number in atomic charges");
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = this.parseToken(line, this.ichNextParse);
            atom.partialCharge = this.parseFloat(line, this.ichNextParse);
        }
        System.out.println("#atoms" + this.atomSetCollection.atomCount);
        System.out.println("#models" + this.atomSetCollection.atomSetCount);
        this.chargesFound = true;
    }

    void processCoordinates(BufferedReader input) throws Exception {
        String line;
        System.out.println("processCoordinates()");
        this.discardLines(input, 3);
        int expectedAtomNumber = 0;
        System.out.println("chargesFound: " + this.chargesFound);
        if (!this.chargesFound) {
            System.out.println("No model created yet, so doing so now...");
            this.atomSetCollection.newAtomSet();
            this.baseAtomIndex = this.atomSetCollection.atomCount;
        } else {
            this.chargesFound = false;
        }
        while ((line = input.readLine()) != null) {
            System.out.println("Processing line: " + line);
            int atomNumber = this.parseInt(line);
            if (atomNumber == Integer.MIN_VALUE) break;
            if (atomNumber != ++expectedAtomNumber) {
                throw new Exception("unexpected atom number in coordinates");
            }
            String elementSymbol = this.parseToken(line, this.ichNextParse);
            Atom atom = this.atomSetCollection.atoms[this.baseAtomIndex + atomNumber - 1];
            if (atom == null) {
                System.out.println("No atom defined yet, creating one now...");
                atom = this.atomSetCollection.addNewAtom();
            }
            atom.atomSerial = atomNumber;
            atom.elementSymbol = elementSymbol;
            atom.x = this.parseFloat(line, this.ichNextParse);
            atom.y = this.parseFloat(line, this.ichNextParse);
            atom.z = this.parseFloat(line, this.ichNextParse);
            System.out.println(atom.elementSymbol + " " + atom.x + " " + atom.y + " " + atom.z);
        }
        System.out.println("#atoms" + this.atomSetCollection.atomCount);
        System.out.println("#models" + this.atomSetCollection.atomSetCount);
        System.out.println("chargesFound: " + this.chargesFound);
        System.out.println("processCoordinates(END)");
    }

    void processFrequencies(BufferedReader input) throws Exception {
        this.discardLines(input, 2);
    }
}

