/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jmol.api.JmolViewer;
import org.jmol.applet.Jvm12;

class Console
implements ActionListener,
WindowListener {
    final JTextArea input = new ShiftEnterTextArea();
    final JTextPane output = new JTextPane();
    final Document outputDocument = this.output.getDocument();
    final JFrame jf = new JFrame("Jmol Console");
    final JButton runButton = new JButton("Execute");
    final SimpleAttributeSet attributesCommand = new SimpleAttributeSet();
    final JmolViewer viewer;
    final Jvm12 jvm12;

    Console(Component componentParent, JmolViewer viewer, Jvm12 jvm12) {
        this.viewer = viewer;
        this.jvm12 = jvm12;
        System.out.println("Console constructor");
        this.setupInput();
        this.setupOutput();
        JScrollPane jscrollInput = new JScrollPane(this.input);
        jscrollInput.setMinimumSize(new Dimension(2, 25));
        JScrollPane jscrollOutput = new JScrollPane(this.output);
        jscrollOutput.setMinimumSize(new Dimension(2, 25));
        Container c = this.jf.getContentPane();
        JSplitPane jsp = new JSplitPane(0, jscrollOutput, jscrollInput);
        jsp.setResizeWeight(0.9);
        c.setLayout(new BorderLayout());
        c.add((Component)jsp, "Center");
        c.add((Component)this.runButton, "South");
        this.runButton.addActionListener(this);
        ((Component)this.jf).setSize(400, 400);
        this.jf.addWindowListener(this);
    }

    void setupInput() {
        this.input.setLineWrap(true);
        this.input.setWrapStyleWord(true);
        Keymap map = this.input.getKeymap();
        KeyStroke shiftA = KeyStroke.getKeyStroke(65, 1);
        map.removeKeyStrokeBinding(shiftA);
    }

    void setupOutput() {
        this.output.setEditable(false);
        StyleConstants.setBold(this.attributesCommand, true);
    }

    void setVisible(boolean visible) {
        System.out.println("Console.setVisible(" + visible + ")");
        ((Component)this.jf).setVisible(visible);
        this.input.requestFocus();
    }

    void output(String message) {
        this.output(message, null);
    }

    void output(String message, AttributeSet att) {
        if (message.charAt(message.length() - 1) != '\n') {
            message = message + "\n";
        }
        try {
            this.outputDocument.insertString(this.outputDocument.getLength(), message, att);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.output.setCaretPosition(this.outputDocument.getLength());
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.runButton) {
            this.execute();
        }
    }

    void execute() {
        String strCommand = this.input.getText();
        this.input.setText(null);
        this.output(strCommand, this.attributesCommand);
        String strErrorMessage = this.viewer.evalString(strCommand);
        if (strErrorMessage != null) {
            this.output(strErrorMessage);
        }
        this.input.requestFocus();
    }

    public void windowActivated(WindowEvent we) {
    }

    public void windowClosed(WindowEvent we) {
        this.jvm12.console = null;
    }

    public void windowClosing(WindowEvent we) {
        this.jvm12.console = null;
    }

    public void windowDeactivated(WindowEvent we) {
    }

    public void windowDeiconified(WindowEvent we) {
    }

    public void windowIconified(WindowEvent we) {
    }

    public void windowOpened(WindowEvent we) {
    }

    class ShiftEnterTextArea
    extends JTextArea {
        ShiftEnterTextArea() {
        }

        public void processComponentKeyEvent(KeyEvent ke) {
            switch (ke.getID()) {
                case 401: {
                    if (ke.getKeyCode() != 10 || !ke.isShiftDown()) break;
                    Console.this.execute();
                    return;
                }
                case 402: {
                    if (ke.getKeyCode() != 10 || !ke.isShiftDown()) break;
                    return;
                }
            }
            super.processComponentKeyEvent(ke);
        }
    }
}

