/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import org.jmol.g3d.Platform3D;

final class Awt3D
extends Platform3D
implements ImageProducer {
    Component component;
    ColorModel colorModelRGB;
    ImageConsumer ic;

    Awt3D(Component component) {
        this.component = component;
        this.colorModelRGB = ColorModel.getRGBdefault();
    }

    Image allocateImage() {
        return this.component.createImage(this);
    }

    void notifyEndOfRendering() {
        if (this.ic != null) {
            this.startProduction(this.ic);
        }
    }

    Image allocateOffscreenImage(int width, int height) {
        Image img = this.component.createImage(width, height);
        return img;
    }

    Graphics getGraphics(Image image) {
        return image.getGraphics();
    }

    public synchronized void addConsumer(ImageConsumer ic) {
        this.startProduction(ic);
    }

    public boolean isConsumer(ImageConsumer ic) {
        return this.ic == ic;
    }

    public void removeConsumer(ImageConsumer ic) {
        if (this.ic == ic) {
            this.ic = null;
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    public void startProduction(ImageConsumer ic) {
        if (this.ic != ic) {
            this.ic = ic;
            ic.setDimensions(this.windowWidth, this.windowHeight);
            ic.setHints(14);
        }
        ic.setPixels(0, 0, this.windowWidth, this.windowHeight, this.colorModelRGB, this.pBuffer, 0, this.windowWidth);
        ic.imageComplete(2);
    }
}

