/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class GT {
    private static GT getTextWrapper = new GT();
    private ResourceBundle translationResources;

    private GT() {
        System.out.println("Instantiating gettext wrapper...");
        try {
            this.translationResources = ResourceBundle.getBundle("org.jmol.translation.Jmol.Messages");
        }
        catch (MissingResourceException mre) {
            System.out.println("Translations do not seem to have been installed!");
            System.out.println(mre.getMessage());
            this.translationResources = null;
        }
        catch (Exception exception) {
            System.out.println("Some exception occured!");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            this.translationResources = null;
        }
    }

    public static String _(String string) {
        return getTextWrapper.getString(string);
    }

    public static String _(String string, Object[] objects) {
        return getTextWrapper.getString(string, objects);
    }

    private String getString(String string) {
        if (this.translationResources != null) {
            try {
                String trans = this.translationResources.getString(string);
                return trans;
            }
            catch (MissingResourceException mre) {
                System.out.println("No trans, using default: " + string);
                return string;
            }
        }
        System.out.println("No trans, using default: " + string);
        return string;
    }

    private String getString(String string, Object[] objects) {
        String trans = string;
        if (this.translationResources != null) {
            try {
                trans = MessageFormat.format(this.translationResources.getString(string), objects);
            }
            catch (MissingResourceException mre) {
                trans = MessageFormat.format(string, objects);
                System.out.println("No trans, using default: " + trans);
            }
        } else {
            trans = MessageFormat.format(string, objects);
            System.out.println("No trans, using default: " + trans);
        }
        return trans;
    }
}

