/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedReader;
import java.util.BitSet;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.MeshCollection;
import org.jmol.viewer.Util;

class Isosurface
extends MeshCollection {
    final float ANGSTROMS_PER_BOHR = 0.5291772f;
    final Point3f volumetricOrigin = new Point3f();
    final Vector3f[] volumetricVectors = new Vector3f[3];
    final int[] voxelCounts;
    final Matrix3f volumetricMatrix;
    float[][][] voxelData;
    int edgePointCount;
    Point3f[] edgePoints;
    float cutoff;
    int indexColorPositive;
    int indexColorNegative;
    int atomCount;
    boolean negativeAtomCount;
    final float[] vertexValues;
    final Point3f[] surfacePoints;
    final int[] surfacePointIndexes;
    int voxelCountX;
    int voxelCountY;
    int voxelCountZ;
    final int[] nullNeighbor;
    final Point3f voxelOrigin;
    final Point3f voxelT;
    final Point3f pointA;
    final Point3f pointB;
    final Vector3f edgeVector;
    static final Point3i[] cubeVertexOffsets = new Point3i[]{new Point3i(0, 0, 0), new Point3i(1, 0, 0), new Point3i(1, 0, 1), new Point3i(0, 0, 1), new Point3i(0, 1, 0), new Point3i(1, 1, 0), new Point3i(1, 1, 1), new Point3i(0, 1, 1)};
    static final Vector3f[] cubeVertexVectors = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f)};
    static Vector3f[] voxelVertexVectors = new Vector3f[8];
    static final byte[] edgeVertexes = new byte[]{0, 1, 1, 2, 2, 3, 3, 0, 4, 5, 5, 6, 6, 7, 7, 4, 0, 4, 1, 5, 2, 6, 3, 7};
    static final short[] edgeMaskTable = new short[]{0, 265, 515, 778, 1030, 1295, 1541, 1804, 2060, 2309, 2575, 2822, 3082, 3331, 3593, 3840, 400, 153, 915, 666, 1430, 1183, 1941, 1692, 2460, 2197, 2975, 2710, 3482, 3219, 3993, 3728, 560, 825, 51, 314, 1590, 1855, 1077, 1340, 2620, 2869, 2111, 2358, 3642, 3891, 3129, 3376, 928, 681, 419, 170, 1958, 1711, 1445, 1196, 2988, 2725, 2479, 2214, 4010, 3747, 3497, 3232, 1120, 1385, 1635, 1898, 102, 367, 613, 876, 3180, 3429, 3695, 3942, 2154, 2403, 2665, 2912, 1520, 1273, 2035, 1786, 502, 255, 1013, 764, 3580, 3317, 4095, 3830, 2554, 2291, 3065, 2800, 1616, 1881, 1107, 1370, 598, 863, 85, 348, 3676, 3925, 3167, 3414, 2650, 2899, 2137, 2384, 1984, 1737, 1475, 1226, 966, 719, 453, 204, 4044, 3781, 3535, 3270, 3018, 2755, 2505, 2240, 2240, 2505, 2755, 3018, 3270, 3535, 3781, 4044, 204, 453, 719, 966, 1226, 1475, 1737, 1984, 2384, 2137, 2899, 2650, 3414, 3167, 3925, 3676, 348, 85, 863, 598, 1370, 1107, 1881, 1616, 2800, 3065, 2291, 2554, 3830, 4095, 3317, 3580, 764, 1013, 255, 502, 1786, 2035, 1273, 1520, 2912, 2665, 2403, 2154, 3942, 3695, 3429, 3180, 876, 613, 367, 102, 1898, 1635, 1385, 1120, 3232, 3497, 3747, 4010, 2214, 2479, 2725, 2988, 1196, 1445, 1711, 1958, 170, 419, 681, 928, 3376, 3129, 3891, 3642, 2358, 2111, 2869, 2620, 1340, 1077, 1855, 1590, 314, 51, 825, 560, 3728, 3993, 3219, 3482, 2710, 2975, 2197, 2460, 1692, 1941, 1183, 1430, 666, 915, 153, 400, 3840, 3593, 3331, 3082, 2822, 2575, 2309, 2060, 1804, 1541, 1295, 1030, 778, 515, 265, 0};
    static final byte[][] triangleTable = new byte[][]{null, {0, 8, 3}, {0, 1, 9}, {1, 8, 3, 9, 8, 1}, {1, 2, 10}, {0, 8, 3, 1, 2, 10}, {9, 2, 10, 0, 2, 9}, {2, 8, 3, 2, 10, 8, 10, 9, 8}, {3, 11, 2}, {0, 11, 2, 8, 11, 0}, {1, 9, 0, 2, 3, 11}, {1, 11, 2, 1, 9, 11, 9, 8, 11}, {3, 10, 1, 11, 10, 3}, {0, 10, 1, 0, 8, 10, 8, 11, 10}, {3, 9, 0, 3, 11, 9, 11, 10, 9}, {9, 8, 10, 10, 8, 11}, {4, 7, 8}, {4, 3, 0, 7, 3, 4}, {0, 1, 9, 8, 4, 7}, {4, 1, 9, 4, 7, 1, 7, 3, 1}, {1, 2, 10, 8, 4, 7}, {3, 4, 7, 3, 0, 4, 1, 2, 10}, {9, 2, 10, 9, 0, 2, 8, 4, 7}, {2, 10, 9, 2, 9, 7, 2, 7, 3, 7, 9, 4}, {8, 4, 7, 3, 11, 2}, {11, 4, 7, 11, 2, 4, 2, 0, 4}, {9, 0, 1, 8, 4, 7, 2, 3, 11}, {4, 7, 11, 9, 4, 11, 9, 11, 2, 9, 2, 1}, {3, 10, 1, 3, 11, 10, 7, 8, 4}, {1, 11, 10, 1, 4, 11, 1, 0, 4, 7, 11, 4}, {4, 7, 8, 9, 0, 11, 9, 11, 10, 11, 0, 3}, {4, 7, 11, 4, 11, 9, 9, 11, 10}, {9, 5, 4}, {9, 5, 4, 0, 8, 3}, {0, 5, 4, 1, 5, 0}, {8, 5, 4, 8, 3, 5, 3, 1, 5}, {1, 2, 10, 9, 5, 4}, {3, 0, 8, 1, 2, 10, 4, 9, 5}, {5, 2, 10, 5, 4, 2, 4, 0, 2}, {2, 10, 5, 3, 2, 5, 3, 5, 4, 3, 4, 8}, {9, 5, 4, 2, 3, 11}, {0, 11, 2, 0, 8, 11, 4, 9, 5}, {0, 5, 4, 0, 1, 5, 2, 3, 11}, {2, 1, 5, 2, 5, 8, 2, 8, 11, 4, 8, 5}, {10, 3, 11, 10, 1, 3, 9, 5, 4}, {4, 9, 5, 0, 8, 1, 8, 10, 1, 8, 11, 10}, {5, 4, 0, 5, 0, 11, 5, 11, 10, 11, 0, 3}, {5, 4, 8, 5, 8, 10, 10, 8, 11}, {9, 7, 8, 5, 7, 9}, {9, 3, 0, 9, 5, 3, 5, 7, 3}, {0, 7, 8, 0, 1, 7, 1, 5, 7}, {1, 5, 3, 3, 5, 7}, {9, 7, 8, 9, 5, 7, 10, 1, 2}, {10, 1, 2, 9, 5, 0, 5, 3, 0, 5, 7, 3}, {8, 0, 2, 8, 2, 5, 8, 5, 7, 10, 5, 2}, {2, 10, 5, 2, 5, 3, 3, 5, 7}, {7, 9, 5, 7, 8, 9, 3, 11, 2}, {9, 5, 7, 9, 7, 2, 9, 2, 0, 2, 7, 11}, {2, 3, 11, 0, 1, 8, 1, 7, 8, 1, 5, 7}, {11, 2, 1, 11, 1, 7, 7, 1, 5}, {9, 5, 8, 8, 5, 7, 10, 1, 3, 10, 3, 11}, {5, 7, 0, 5, 0, 9, 7, 11, 0, 1, 0, 10, 11, 10, 0}, {11, 10, 0, 11, 0, 3, 10, 5, 0, 8, 0, 7, 5, 7, 0}, {11, 10, 5, 7, 11, 5}, {10, 6, 5}, {0, 8, 3, 5, 10, 6}, {9, 0, 1, 5, 10, 6}, {1, 8, 3, 1, 9, 8, 5, 10, 6}, {1, 6, 5, 2, 6, 1}, {1, 6, 5, 1, 2, 6, 3, 0, 8}, {9, 6, 5, 9, 0, 6, 0, 2, 6}, {5, 9, 8, 5, 8, 2, 5, 2, 6, 3, 2, 8}, {2, 3, 11, 10, 6, 5}, {11, 0, 8, 11, 2, 0, 10, 6, 5}, {0, 1, 9, 2, 3, 11, 5, 10, 6}, {5, 10, 6, 1, 9, 2, 9, 11, 2, 9, 8, 11}, {6, 3, 11, 6, 5, 3, 5, 1, 3}, {0, 8, 11, 0, 11, 5, 0, 5, 1, 5, 11, 6}, {3, 11, 6, 0, 3, 6, 0, 6, 5, 0, 5, 9}, {6, 5, 9, 6, 9, 11, 11, 9, 8}, {5, 10, 6, 4, 7, 8}, {4, 3, 0, 4, 7, 3, 6, 5, 10}, {1, 9, 0, 5, 10, 6, 8, 4, 7}, {10, 6, 5, 1, 9, 7, 1, 7, 3, 7, 9, 4}, {6, 1, 2, 6, 5, 1, 4, 7, 8}, {1, 2, 5, 5, 2, 6, 3, 0, 4, 3, 4, 7}, {8, 4, 7, 9, 0, 5, 0, 6, 5, 0, 2, 6}, {7, 3, 9, 7, 9, 4, 3, 2, 9, 5, 9, 6, 2, 6, 9}, {3, 11, 2, 7, 8, 4, 10, 6, 5}, {5, 10, 6, 4, 7, 2, 4, 2, 0, 2, 7, 11}, {0, 1, 9, 4, 7, 8, 2, 3, 11, 5, 10, 6}, {9, 2, 1, 9, 11, 2, 9, 4, 11, 7, 11, 4, 5, 10, 6}, {8, 4, 7, 3, 11, 5, 3, 5, 1, 5, 11, 6}, {5, 1, 11, 5, 11, 6, 1, 0, 11, 7, 11, 4, 0, 4, 11}, {0, 5, 9, 0, 6, 5, 0, 3, 6, 11, 6, 3, 8, 4, 7}, {6, 5, 9, 6, 9, 11, 4, 7, 9, 7, 11, 9}, {10, 4, 9, 6, 4, 10}, {4, 10, 6, 4, 9, 10, 0, 8, 3}, {10, 0, 1, 10, 6, 0, 6, 4, 0}, {8, 3, 1, 8, 1, 6, 8, 6, 4, 6, 1, 10}, {1, 4, 9, 1, 2, 4, 2, 6, 4}, {3, 0, 8, 1, 2, 9, 2, 4, 9, 2, 6, 4}, {0, 2, 4, 4, 2, 6}, {8, 3, 2, 8, 2, 4, 4, 2, 6}, {10, 4, 9, 10, 6, 4, 11, 2, 3}, {0, 8, 2, 2, 8, 11, 4, 9, 10, 4, 10, 6}, {3, 11, 2, 0, 1, 6, 0, 6, 4, 6, 1, 10}, {6, 4, 1, 6, 1, 10, 4, 8, 1, 2, 1, 11, 8, 11, 1}, {9, 6, 4, 9, 3, 6, 9, 1, 3, 11, 6, 3}, {8, 11, 1, 8, 1, 0, 11, 6, 1, 9, 1, 4, 6, 4, 1}, {3, 11, 6, 3, 6, 0, 0, 6, 4}, {6, 4, 8, 11, 6, 8}, {7, 10, 6, 7, 8, 10, 8, 9, 10}, {0, 7, 3, 0, 10, 7, 0, 9, 10, 6, 7, 10}, {10, 6, 7, 1, 10, 7, 1, 7, 8, 1, 8, 0}, {10, 6, 7, 10, 7, 1, 1, 7, 3}, {1, 2, 6, 1, 6, 8, 1, 8, 9, 8, 6, 7}, {2, 6, 9, 2, 9, 1, 6, 7, 9, 0, 9, 3, 7, 3, 9}, {7, 8, 0, 7, 0, 6, 6, 0, 2}, {7, 3, 2, 6, 7, 2}, {2, 3, 11, 10, 6, 8, 10, 8, 9, 8, 6, 7}, {2, 0, 7, 2, 7, 11, 0, 9, 7, 6, 7, 10, 9, 10, 7}, {1, 8, 0, 1, 7, 8, 1, 10, 7, 6, 7, 10, 2, 3, 11}, {11, 2, 1, 11, 1, 7, 10, 6, 1, 6, 7, 1}, {8, 9, 6, 8, 6, 7, 9, 1, 6, 11, 6, 3, 1, 3, 6}, {0, 9, 1, 11, 6, 7}, {7, 8, 0, 7, 0, 6, 3, 11, 0, 11, 6, 0}, {7, 11, 6}, {7, 6, 11}, {3, 0, 8, 11, 7, 6}, {0, 1, 9, 11, 7, 6}, {8, 1, 9, 8, 3, 1, 11, 7, 6}, {10, 1, 2, 6, 11, 7}, {1, 2, 10, 3, 0, 8, 6, 11, 7}, {2, 9, 0, 2, 10, 9, 6, 11, 7}, {6, 11, 7, 2, 10, 3, 10, 8, 3, 10, 9, 8}, {7, 2, 3, 6, 2, 7}, {7, 0, 8, 7, 6, 0, 6, 2, 0}, {2, 7, 6, 2, 3, 7, 0, 1, 9}, {1, 6, 2, 1, 8, 6, 1, 9, 8, 8, 7, 6}, {10, 7, 6, 10, 1, 7, 1, 3, 7}, {10, 7, 6, 1, 7, 10, 1, 8, 7, 1, 0, 8}, {0, 3, 7, 0, 7, 10, 0, 10, 9, 6, 10, 7}, {7, 6, 10, 7, 10, 8, 8, 10, 9}, {6, 8, 4, 11, 8, 6}, {3, 6, 11, 3, 0, 6, 0, 4, 6}, {8, 6, 11, 8, 4, 6, 9, 0, 1}, {9, 4, 6, 9, 6, 3, 9, 3, 1, 11, 3, 6}, {6, 8, 4, 6, 11, 8, 2, 10, 1}, {1, 2, 10, 3, 0, 11, 0, 6, 11, 0, 4, 6}, {4, 11, 8, 4, 6, 11, 0, 2, 9, 2, 10, 9}, {10, 9, 3, 10, 3, 2, 9, 4, 3, 11, 3, 6, 4, 6, 3}, {8, 2, 3, 8, 4, 2, 4, 6, 2}, {0, 4, 2, 4, 6, 2}, {1, 9, 0, 2, 3, 4, 2, 4, 6, 4, 3, 8}, {1, 9, 4, 1, 4, 2, 2, 4, 6}, {8, 1, 3, 8, 6, 1, 8, 4, 6, 6, 10, 1}, {10, 1, 0, 10, 0, 6, 6, 0, 4}, {4, 6, 3, 4, 3, 8, 6, 10, 3, 0, 3, 9, 10, 9, 3}, {10, 9, 4, 6, 10, 4}, {4, 9, 5, 7, 6, 11}, {0, 8, 3, 4, 9, 5, 11, 7, 6}, {5, 0, 1, 5, 4, 0, 7, 6, 11}, {11, 7, 6, 8, 3, 4, 3, 5, 4, 3, 1, 5}, {9, 5, 4, 10, 1, 2, 7, 6, 11}, {6, 11, 7, 1, 2, 10, 0, 8, 3, 4, 9, 5}, {7, 6, 11, 5, 4, 10, 4, 2, 10, 4, 0, 2}, {3, 4, 8, 3, 5, 4, 3, 2, 5, 10, 5, 2, 11, 7, 6}, {7, 2, 3, 7, 6, 2, 5, 4, 9}, {9, 5, 4, 0, 8, 6, 0, 6, 2, 6, 8, 7}, {3, 6, 2, 3, 7, 6, 1, 5, 0, 5, 4, 0}, {6, 2, 8, 6, 8, 7, 2, 1, 8, 4, 8, 5, 1, 5, 8}, {9, 5, 4, 10, 1, 6, 1, 7, 6, 1, 3, 7}, {1, 6, 10, 1, 7, 6, 1, 0, 7, 8, 7, 0, 9, 5, 4}, {4, 0, 10, 4, 10, 5, 0, 3, 10, 6, 10, 7, 3, 7, 10}, {7, 6, 10, 7, 10, 8, 5, 4, 10, 4, 8, 10}, {6, 9, 5, 6, 11, 9, 11, 8, 9}, {3, 6, 11, 0, 6, 3, 0, 5, 6, 0, 9, 5}, {0, 11, 8, 0, 5, 11, 0, 1, 5, 5, 6, 11}, {6, 11, 3, 6, 3, 5, 5, 3, 1}, {1, 2, 10, 9, 5, 11, 9, 11, 8, 11, 5, 6}, {0, 11, 3, 0, 6, 11, 0, 9, 6, 5, 6, 9, 1, 2, 10}, {11, 8, 5, 11, 5, 6, 8, 0, 5, 10, 5, 2, 0, 2, 5}, {6, 11, 3, 6, 3, 5, 2, 10, 3, 10, 5, 3}, {5, 8, 9, 5, 2, 8, 5, 6, 2, 3, 8, 2}, {9, 5, 6, 9, 6, 0, 0, 6, 2}, {1, 5, 8, 1, 8, 0, 5, 6, 8, 3, 8, 2, 6, 2, 8}, {1, 5, 6, 2, 1, 6}, {1, 3, 6, 1, 6, 10, 3, 8, 6, 5, 6, 9, 8, 9, 6}, {10, 1, 0, 10, 0, 6, 9, 5, 0, 5, 6, 0}, {0, 3, 8, 5, 6, 10}, {10, 5, 6}, {11, 5, 10, 7, 5, 11}, {11, 5, 10, 11, 7, 5, 8, 3, 0}, {5, 11, 7, 5, 10, 11, 1, 9, 0}, {10, 7, 5, 10, 11, 7, 9, 8, 1, 8, 3, 1}, {11, 1, 2, 11, 7, 1, 7, 5, 1}, {0, 8, 3, 1, 2, 7, 1, 7, 5, 7, 2, 11}, {9, 7, 5, 9, 2, 7, 9, 0, 2, 2, 11, 7}, {7, 5, 2, 7, 2, 11, 5, 9, 2, 3, 2, 8, 9, 8, 2}, {2, 5, 10, 2, 3, 5, 3, 7, 5}, {8, 2, 0, 8, 5, 2, 8, 7, 5, 10, 2, 5}, {9, 0, 1, 5, 10, 3, 5, 3, 7, 3, 10, 2}, {9, 8, 2, 9, 2, 1, 8, 7, 2, 10, 2, 5, 7, 5, 2}, {1, 3, 5, 3, 7, 5}, {0, 8, 7, 0, 7, 1, 1, 7, 5}, {9, 0, 3, 9, 3, 5, 5, 3, 7}, {9, 8, 7, 5, 9, 7}, {5, 8, 4, 5, 10, 8, 10, 11, 8}, {5, 0, 4, 5, 11, 0, 5, 10, 11, 11, 3, 0}, {0, 1, 9, 8, 4, 10, 8, 10, 11, 10, 4, 5}, {10, 11, 4, 10, 4, 5, 11, 3, 4, 9, 4, 1, 3, 1, 4}, {2, 5, 1, 2, 8, 5, 2, 11, 8, 4, 5, 8}, {0, 4, 11, 0, 11, 3, 4, 5, 11, 2, 11, 1, 5, 1, 11}, {0, 2, 5, 0, 5, 9, 2, 11, 5, 4, 5, 8, 11, 8, 5}, {9, 4, 5, 2, 11, 3}, {2, 5, 10, 3, 5, 2, 3, 4, 5, 3, 8, 4}, {5, 10, 2, 5, 2, 4, 4, 2, 0}, {3, 10, 2, 3, 5, 10, 3, 8, 5, 4, 5, 8, 0, 1, 9}, {5, 10, 2, 5, 2, 4, 1, 9, 2, 9, 4, 2}, {8, 4, 5, 8, 5, 3, 3, 5, 1}, {0, 4, 5, 1, 0, 5}, {8, 4, 5, 8, 5, 3, 9, 0, 5, 0, 3, 5}, {9, 4, 5}, {4, 11, 7, 4, 9, 11, 9, 10, 11}, {0, 8, 3, 4, 9, 7, 9, 11, 7, 9, 10, 11}, {1, 10, 11, 1, 11, 4, 1, 4, 0, 7, 4, 11}, {3, 1, 4, 3, 4, 8, 1, 10, 4, 7, 4, 11, 10, 11, 4}, {4, 11, 7, 9, 11, 4, 9, 2, 11, 9, 1, 2}, {9, 7, 4, 9, 11, 7, 9, 1, 11, 2, 11, 1, 0, 8, 3}, {11, 7, 4, 11, 4, 2, 2, 4, 0}, {11, 7, 4, 11, 4, 2, 8, 3, 4, 3, 2, 4}, {2, 9, 10, 2, 7, 9, 2, 3, 7, 7, 4, 9}, {9, 10, 7, 9, 7, 4, 10, 2, 7, 8, 7, 0, 2, 0, 7}, {3, 7, 10, 3, 10, 2, 7, 4, 10, 1, 10, 0, 4, 0, 10}, {1, 10, 2, 8, 7, 4}, {4, 9, 1, 4, 1, 7, 7, 1, 3}, {4, 9, 1, 4, 1, 7, 0, 8, 1, 8, 7, 1}, {4, 0, 3, 7, 4, 3}, {4, 8, 7}, {9, 10, 8, 10, 11, 8}, {3, 0, 9, 3, 9, 11, 11, 9, 10}, {0, 1, 10, 0, 10, 8, 8, 10, 11}, {3, 1, 10, 11, 3, 10}, {1, 2, 11, 1, 11, 9, 9, 11, 8}, {3, 0, 9, 3, 9, 11, 1, 2, 9, 2, 11, 9}, {0, 2, 11, 8, 0, 11}, {3, 2, 11}, {2, 3, 8, 2, 8, 10, 10, 8, 9}, {9, 10, 2, 0, 9, 2}, {2, 3, 8, 2, 8, 10, 0, 1, 8, 1, 10, 8}, {1, 10, 2}, {1, 3, 8, 9, 1, 8}, {0, 9, 1}, {0, 3, 8}, null};

    Isosurface() {
        int i = 3;
        while (--i >= 0) {
            this.volumetricVectors[i] = new Vector3f();
        }
        this.voxelCounts = new int[3];
        this.volumetricMatrix = new Matrix3f();
        this.edgePointCount = 0;
        this.edgePoints = new Point3f[256];
        this.cutoff = 0.02f;
        this.vertexValues = new float[8];
        this.surfacePoints = new Point3f[12];
        i = 12;
        while (--i >= 0) {
            this.surfacePoints[i] = new Point3f();
        }
        this.surfacePointIndexes = new int[12];
        this.nullNeighbor = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        this.voxelOrigin = new Point3f();
        this.voxelT = new Point3f();
        this.pointA = new Point3f();
        this.pointB = new Point3f();
        this.edgeVector = new Vector3f();
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        if ("bufferedreader" == propertyName) {
            BufferedReader br = (BufferedReader)value;
            if (this.currentMesh == null) {
                this.allocMesh(null);
            }
            this.currentMesh.clear();
            this.readVolumetricHeader(br);
            this.calcVolumetricMatrix();
            this.readVolumetricData(br);
            this.calcVoxelVertexVectors();
            this.constructTessellatedSurface();
            this.currentMesh.colix = this.getDefaultColix();
            this.currentMesh.initialize();
            this.currentMesh.checkForDuplicatePoints(0.001f);
            this.currentMesh.visible = true;
            return;
        }
        if ("cutoff" == propertyName) {
            this.cutoff = ((Float)value).floatValue();
        }
        super.setProperty(propertyName, value, bs);
    }

    void calcVolumetricMatrix() {
        int i = 3;
        while (--i >= 0) {
            this.volumetricMatrix.setColumn(i, this.volumetricVectors[i]);
        }
    }

    short getDefaultColix() {
        int argb;
        if (this.cutoff >= 0.0f) {
            this.indexColorPositive %= JmolConstants.argbsIsosurfacePositive.length;
            argb = JmolConstants.argbsIsosurfacePositive[this.indexColorPositive++];
        } else {
            this.indexColorNegative %= JmolConstants.argbsIsosurfaceNegative.length;
            argb = JmolConstants.argbsIsosurfaceNegative[this.indexColorNegative++];
        }
        return Graphics3D.getColix(argb);
    }

    void readVolumetricHeader(BufferedReader br) {
        try {
            this.readTitleLines(br);
            this.readAtomCountAndOrigin(br);
            this.readVoxelVectors(br);
            this.readAtoms(br);
            this.readExtraLine(br);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    void readVolumetricData(BufferedReader br) {
        try {
            this.readVoxelData(br);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    void readTitleLines(BufferedReader br) throws Exception {
        String title = br.readLine().trim() + " - ";
        title = title + br.readLine().trim();
    }

    void readAtomCountAndOrigin(BufferedReader br) throws Exception {
        String line = br.readLine();
        this.atomCount = this.parseInt(line);
        this.volumetricOrigin.x = this.parseFloat(line, this.ichNextParse);
        this.volumetricOrigin.y = this.parseFloat(line, this.ichNextParse);
        this.volumetricOrigin.z = this.parseFloat(line, this.ichNextParse);
        this.volumetricOrigin.scale(0.5291772f);
        if (this.atomCount < 0) {
            this.atomCount = -this.atomCount;
            this.negativeAtomCount = true;
        }
    }

    void readVoxelVectors(BufferedReader br) throws Exception {
        for (int i = 0; i < 3; ++i) {
            this.readVoxelVector(br, i);
        }
    }

    void readVoxelVector(BufferedReader br, int voxelVectorIndex) throws Exception {
        String line = br.readLine();
        Vector3f voxelVector = this.volumetricVectors[voxelVectorIndex];
        this.voxelCounts[voxelVectorIndex] = this.parseInt(line);
        voxelVector.x = this.parseFloat(line, this.ichNextParse);
        voxelVector.y = this.parseFloat(line, this.ichNextParse);
        voxelVector.z = this.parseFloat(line, this.ichNextParse);
        voxelVector.scale(0.5291772f);
    }

    void readAtoms(BufferedReader br) throws Exception {
        for (int i = 0; i < this.atomCount; ++i) {
            String string = br.readLine();
        }
    }

    void readExtraLine(BufferedReader br) throws Exception {
        if (this.negativeAtomCount) {
            br.readLine();
        }
    }

    void readVoxelData(BufferedReader br) throws Exception {
        System.out.println("entering readVoxelData");
        String line = "";
        this.ichNextParse = 0;
        int voxelCountX = this.voxelCounts[0];
        int voxelCountY = this.voxelCounts[1];
        int voxelCountZ = this.voxelCounts[2];
        this.voxelData = new float[voxelCountX][][];
        for (int x = 0; x < voxelCountX; ++x) {
            float[][] plane = new float[voxelCountY][];
            this.voxelData[x] = plane;
            for (int y = 0; y < voxelCountY; ++y) {
                float[] strip = new float[voxelCountZ];
                plane[y] = strip;
                for (int z = 0; z < voxelCountZ; ++z) {
                    float voxelValue = this.parseFloat(line, this.ichNextParse);
                    if (Float.isNaN(voxelValue) && ((line = br.readLine()) == null || Float.isNaN(voxelValue = this.parseFloat(line)))) {
                        System.out.println("end of file in CubeReader?");
                        throw new NullPointerException();
                    }
                    strip[z] = voxelValue;
                }
            }
        }
        System.out.println("Successfully read " + voxelCountX + " x " + voxelCountY + " x " + voxelCountZ + " voxels");
    }

    void constructTessellatedSurface() {
        this.voxelCountX = this.voxelData.length - 1;
        this.voxelCountY = this.voxelData[0].length - 1;
        this.voxelCountZ = this.voxelData[0][0].length - 1;
        int[][] isoPointIndexes = new int[this.voxelCountY * this.voxelCountZ][12];
        int i = this.voxelCountY * this.voxelCountZ;
        while (--i >= 0) {
            isoPointIndexes[i] = new int[12];
        }
        int insideCount = 0;
        int outsideCount = 0;
        int surfaceCount = 0;
        int x = this.voxelCountX;
        while (--x >= 0) {
            int y = this.voxelCountY;
            while (--y >= 0) {
                int z = this.voxelCountZ;
                while (--z >= 0) {
                    int insideMask = 0;
                    int i2 = 8;
                    while (--i2 >= 0) {
                        float vertexValue;
                        Point3i offset = cubeVertexOffsets[i2];
                        this.vertexValues[i2] = vertexValue = this.voxelData[x + offset.x][y + offset.y][z + offset.z];
                        if (!(this.cutoff > 0.0f && vertexValue >= this.cutoff) && (!(this.cutoff < 0.0f) || !(vertexValue <= this.cutoff))) continue;
                        insideMask |= 1 << i2;
                    }
                    if (insideMask == 0) {
                        ++outsideCount;
                        continue;
                    }
                    if (insideMask == 255) {
                        ++insideCount;
                        continue;
                    }
                    ++surfaceCount;
                    this.calcVoxelOrigin(x, y, z);
                    int[] voxelPointIndexes = this.propogateNeighborPointIndexes(x, y, z, isoPointIndexes);
                    this.processOneVoxel(insideMask, this.cutoff, voxelPointIndexes);
                }
            }
        }
        System.out.println("volumetric=" + this.voxelCountX + "," + this.voxelCountY + "," + this.voxelCountZ + "," + " total=" + this.voxelCountX * this.voxelCountY * this.voxelCountZ + "\n" + " insideCount=" + insideCount + " outsideCount=" + outsideCount + " surfaceCount=" + surfaceCount + " total=" + (insideCount + outsideCount + surfaceCount));
    }

    int[] propogateNeighborPointIndexes(int x, int y, int z, int[][] isoPointIndexes) {
        boolean noXNeighbor;
        int cellIndex = y * this.voxelCountZ + z;
        int[] voxelPointIndexes = isoPointIndexes[cellIndex];
        boolean bl = noXNeighbor = x == this.voxelCountX - 1;
        if (noXNeighbor) {
            voxelPointIndexes[1] = -1;
            voxelPointIndexes[9] = -1;
            voxelPointIndexes[5] = -1;
            voxelPointIndexes[10] = -1;
        } else {
            voxelPointIndexes[1] = voxelPointIndexes[3];
            voxelPointIndexes[9] = voxelPointIndexes[8];
            voxelPointIndexes[5] = voxelPointIndexes[7];
            voxelPointIndexes[10] = voxelPointIndexes[11];
        }
        boolean noYNeighbor = y == this.voxelCountY - 1;
        int[] yNeighbor = noYNeighbor ? this.nullNeighbor : isoPointIndexes[cellIndex + this.voxelCountZ];
        voxelPointIndexes[6] = yNeighbor[2];
        voxelPointIndexes[7] = yNeighbor[3];
        voxelPointIndexes[4] = yNeighbor[0];
        if (noXNeighbor) {
            voxelPointIndexes[5] = yNeighbor[1];
        }
        boolean noZNeighbor = z == this.voxelCountZ - 1;
        int[] zNeighbor = noZNeighbor ? this.nullNeighbor : isoPointIndexes[cellIndex + 1];
        voxelPointIndexes[2] = zNeighbor[0];
        voxelPointIndexes[11] = zNeighbor[8];
        if (noYNeighbor) {
            voxelPointIndexes[6] = zNeighbor[4];
        }
        if (noXNeighbor) {
            voxelPointIndexes[10] = zNeighbor[9];
        }
        voxelPointIndexes[0] = -1;
        voxelPointIndexes[3] = -1;
        voxelPointIndexes[8] = -1;
        return voxelPointIndexes;
    }

    void dump(int[] pointIndexes) {
        for (int i = 0; i < 12; ++i) {
            System.out.println(" " + i + ":" + pointIndexes[i]);
        }
    }

    void processOneVoxel(int insideMask, float cutoff, int[] voxelPointIndexes) {
        short edgeMask = edgeMaskTable[insideMask];
        int iEdge = 12;
        while (--iEdge >= 0) {
            if ((edgeMask & 1 << iEdge) == 0 || voxelPointIndexes[iEdge] >= 0) continue;
            byte vertexA = edgeVertexes[2 * iEdge];
            byte vertexB = edgeVertexes[2 * iEdge + 1];
            float valueA = this.vertexValues[vertexA];
            float valueB = this.vertexValues[vertexB];
            this.calcVertexPoints(vertexA, vertexB);
            this.addEdgePoint(this.pointA);
            this.addEdgePoint(this.pointB);
            this.calcSurfacePoint(cutoff, valueA, valueB, this.surfacePoints[iEdge]);
            voxelPointIndexes[iEdge] = this.currentMesh.addVertexCopy(this.surfacePoints[iEdge]);
        }
        byte[] triangles = triangleTable[insideMask];
        int i = triangles.length;
        while ((i -= 3) >= 0) {
            this.currentMesh.addTriangle(voxelPointIndexes[triangles[i]], voxelPointIndexes[triangles[i + 1]], voxelPointIndexes[triangles[i + 2]]);
        }
    }

    void calcSurfacePoint(float cutoff, float valueA, float valueB, Point3f surfacePoint) {
        float diff = valueB - valueA;
        float fraction = (cutoff - valueA) / diff;
        if (Float.isNaN(fraction) || fraction < 0.0f || fraction > 1.0f) {
            System.out.println("fraction=" + fraction + " cutoff=" + cutoff + " A:" + valueA + " B:" + valueB);
            throw new IndexOutOfBoundsException();
        }
        this.edgeVector.sub(this.pointB, this.pointA);
        surfacePoint.scaleAdd(fraction, this.edgeVector, this.pointA);
    }

    void calcVertexPoints(int vertexA, int vertexB) {
        this.pointA.add(this.voxelOrigin, voxelVertexVectors[vertexA]);
        this.pointB.add(this.voxelOrigin, voxelVertexVectors[vertexB]);
    }

    void calcVoxelOrigin(int x, int y, int z) {
        this.voxelOrigin.scaleAdd(x, this.volumetricVectors[0], this.volumetricOrigin);
        this.voxelOrigin.scaleAdd(y, this.volumetricVectors[1], this.voxelOrigin);
        this.voxelOrigin.scaleAdd(z, this.volumetricVectors[2], this.voxelOrigin);
    }

    void addEdgePoint(Point3f point) {
        if (this.edgePointCount == this.edgePoints.length) {
            this.edgePoints = (Point3f[])Util.doubleLength(this.edgePoints);
        }
        this.edgePoints[this.edgePointCount++] = new Point3f(point);
    }

    void calcVoxelVertexVectors() {
        int i = 8;
        while (--i >= 0) {
            Isosurface.voxelVertexVectors[i] = this.calcVoxelVertexVector(cubeVertexVectors[i]);
        }
        for (i = 0; i < 8; ++i) {
            System.out.println("voxelVertexVectors[" + i + "]=" + voxelVertexVectors[i]);
        }
    }

    Vector3f calcVoxelVertexVector(Vector3f cubeVectors) {
        Vector3f v = new Vector3f();
        this.volumetricMatrix.transform(cubeVectors, v);
        return v;
    }
}

