/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.g3d.Xyzd;
import org.jmol.viewer.Atom;
import org.jmol.viewer.ShapeRenderer;

class BallsRenderer
extends ShapeRenderer {
    int minX;
    int maxX;
    int minY;
    int maxY;
    boolean wireframeRotating;
    boolean showHydrogens;
    short colixSelection;

    BallsRenderer() {
    }

    void render() {
        this.minX = this.rectClip.x;
        this.maxX = this.minX + this.rectClip.width;
        this.minY = this.rectClip.y;
        this.maxY = this.minY + this.rectClip.height;
        this.wireframeRotating = this.viewer.getWireframeRotating();
        this.colixSelection = this.viewer.getColixSelection();
        this.showHydrogens = this.viewer.getShowHydrogens();
        Atom[] atoms = this.frame.atoms;
        int displayModelIndex = this.displayModelIndex;
        if (displayModelIndex < 0) {
            int i = this.frame.atomCount;
            while (--i >= 0) {
                Atom atom = atoms[i];
                atom.transform(this.viewer);
                this.render(atom);
            }
        } else {
            int i = this.frame.atomCount;
            while (--i >= 0) {
                Atom atom = atoms[i];
                if (atom.modelIndex != displayModelIndex) {
                    atom.formalChargeAndFlags = (byte)(atom.formalChargeAndFlags & 0xFFFFFFFE);
                    continue;
                }
                atom.transform(this.viewer);
                this.render(atom);
            }
        }
    }

    void render(Atom atom) {
        if (!this.showHydrogens && atom.elementNumber == 1) {
            return;
        }
        long xyzd = atom.xyzd;
        int diameter = Xyzd.getD((long)xyzd);
        boolean hasHalo = this.viewer.hasSelectionHalo(atom.atomIndex);
        if (diameter == 0 && !hasHalo) {
            atom.formalChargeAndFlags = (byte)(atom.formalChargeAndFlags & 0xFFFFFFFE);
            return;
        }
        atom.formalChargeAndFlags = (byte)(atom.formalChargeAndFlags | 1);
        if (!this.wireframeRotating) {
            this.g3d.fillSphereCentered(atom.colixAtom, xyzd);
        } else {
            this.g3d.drawCircleCentered(atom.colixAtom, xyzd);
        }
        if (hasHalo) {
            int halowidth = diameter / 4;
            if (halowidth < 4) {
                halowidth = 4;
            }
            if (halowidth > 10) {
                halowidth = 10;
            }
            int haloDiameter = diameter + 2 * halowidth;
            this.g3d.fillScreenedCircleCentered(this.colixSelection, haloDiameter, Xyzd.getX((long)xyzd), Xyzd.getY((long)xyzd), Xyzd.getZ((long)xyzd));
        }
    }
}

