/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Viewer;

class Bond {
    Atom atom1;
    Atom atom2;
    short order;
    short mad;
    short colix;

    Bond(Atom atom1, Atom atom2, int order, short mad, short colix) {
        if (atom1 == null) {
            throw new NullPointerException();
        }
        if (atom2 == null) {
            throw new NullPointerException();
        }
        this.atom1 = atom1;
        this.atom2 = atom2;
        if (atom1.elementNumber == 16 && atom2.elementNumber == 16) {
            order |= 0x20;
        }
        if (order == 4) {
            order = 5;
        }
        this.order = (short)order;
        this.mad = mad;
        this.colix = colix;
    }

    Bond(Atom atom1, Atom atom2, int order, Viewer viewer) {
        this(atom1, atom2, order, (order & 0x3C0) != 0 ? (short)0 : viewer.getMadBond(), viewer.getColixBond(order));
    }

    boolean isCovalent() {
        return (this.order & 3) != 0;
    }

    boolean isStereo() {
        return (this.order & 0x18) != 0;
    }

    boolean isAromatic() {
        return (this.order & 4) != 0;
    }

    void deleteAtomReferences() {
        if (this.atom1 != null) {
            this.atom1.deleteBond(this);
        }
        if (this.atom2 != null) {
            this.atom2.deleteBond(this);
        }
        this.atom2 = null;
        this.atom1 = null;
    }

    void setMad(short mad) {
        this.mad = mad;
    }

    void setColix(short colix) {
        this.colix = colix;
    }

    void setTranslucent(boolean isTranslucent) {
        this.colix = Graphics3D.setTranslucent((short)this.colix, (boolean)isTranslucent);
    }

    void setOrder(short order) {
        this.order = order;
    }

    Atom getAtom1() {
        return this.atom1;
    }

    Atom getAtom2() {
        return this.atom2;
    }

    float getRadius() {
        return (float)this.mad / 2000.0f;
    }

    short getOrder() {
        return this.order;
    }

    short getColix1() {
        return Graphics3D.inheritColix((short)this.colix, (short)this.atom1.colixAtom);
    }

    short getColix2() {
        return Graphics3D.inheritColix((short)this.colix, (short)this.atom2.colixAtom);
    }
}

