/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.FontMetrics;
import org.jmol.g3d.Font3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Hover;
import org.jmol.viewer.ShapeRenderer;

class HoverRenderer
extends ShapeRenderer {
    HoverRenderer() {
    }

    void render() {
        int y;
        Hover hover = (Hover)this.shape;
        if (hover.atomIndex == -1 || hover.labelFormat == null) {
            return;
        }
        Atom atom = this.frame.getAtomAt(hover.atomIndex);
        String msg = atom.formatLabel(hover.labelFormat);
        Font3D font3d = hover.font3d;
        FontMetrics fontMetrics = font3d.fontMetrics;
        int ascent = fontMetrics.getAscent();
        int descent = fontMetrics.getDescent();
        int msgHeight = ascent + descent;
        int msgWidth = fontMetrics.stringWidth(msg);
        short colixBackground = hover.colixBackground;
        short colixForeground = hover.colixForeground;
        int windowWidth = this.g3d.getWindowWidth();
        int windowHeight = this.g3d.getWindowHeight();
        int width = msgWidth + 8;
        int height = msgHeight + 8;
        int x = atom.getScreenX() + 4;
        if (x + width > windowWidth) {
            x = windowWidth - width;
        }
        if (x < 0) {
            x = 0;
        }
        if ((y = atom.getScreenY() - height - 4) + height > windowHeight) {
            y = windowHeight - height;
        }
        if (y < 0) {
            y = 0;
        }
        int msgX = x + 4;
        int msgYBaseline = y + 4 + ascent;
        if (colixBackground != 0) {
            this.g3d.fillRect(colixBackground, x, y, 2, width, height);
            this.g3d.drawRectNoSlab(colixForeground, x + 1, y + 1, 1, width - 2, height - 2);
        }
        this.g3d.drawStringNoSlab(msg, font3d, colixForeground, (short)0, msgX, msgYBaseline, 0);
    }
}

