/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Properties;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Group;
import org.jmol.viewer.Model;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.Util;

final class Mmset {
    Frame frame;
    Properties modelSetProperties;
    private int modelCount = 0;
    private String[] modelNames = new String[1];
    private int[] modelNumbers = new int[1];
    private Properties[] modelProperties = new Properties[1];
    private Model[] models = new Model[1];
    private int structureCount = 0;
    private Structure[] structures = new Structure[10];

    Mmset(Frame frame) {
        this.frame = frame;
    }

    void defineStructure(String structureType, char startChainID, int startSequenceNumber, char startInsertionCode, char endChainID, int endSequenceNumber, char endInsertionCode) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])Util.setLength(this.structures, this.structureCount + 10);
        }
        this.structures[this.structureCount++] = new Structure(structureType, startChainID, Group.getSeqcode(startSequenceNumber, startInsertionCode), endChainID, Group.getSeqcode(endSequenceNumber, endInsertionCode));
    }

    void calculateStructures() {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].calculateStructures();
        }
    }

    void freeze() {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].freeze();
        }
        this.propogateSecondaryStructure();
    }

    void setModelSetProperties(Properties modelSetProperties) {
        this.modelSetProperties = modelSetProperties;
    }

    Properties getModelSetProperties() {
        return this.modelSetProperties;
    }

    String getModelSetProperty(String propertyName) {
        return this.modelSetProperties == null ? null : this.modelSetProperties.getProperty(propertyName);
    }

    void setModelCount(int modelCount) {
        if (this.modelCount != 0) {
            throw new NullPointerException();
        }
        this.modelCount = modelCount;
        this.models = (Model[])Util.setLength(this.models, modelCount);
        this.modelNames = Util.setLength(this.modelNames, modelCount);
        this.modelNumbers = Util.setLength(this.modelNumbers, modelCount);
        this.modelProperties = (Properties[])Util.setLength(this.modelProperties, modelCount);
    }

    String getModelName(int modelIndex) {
        return this.modelNames[modelIndex];
    }

    int getModelNumber(int modelIndex) {
        return this.modelNumbers[modelIndex];
    }

    Properties getModelProperties(int modelIndex) {
        return this.modelProperties[modelIndex];
    }

    String getModelProperty(int modelIndex, String property) {
        Properties props = this.modelProperties[modelIndex];
        return props == null ? null : props.getProperty(property);
    }

    Model getModel(int modelIndex) {
        return this.models[modelIndex];
    }

    int getModelNumberIndex(int modelNumber) {
        int i = this.modelCount;
        while (--i >= 0 && this.modelNumbers[i] != modelNumber) {
        }
        return i;
    }

    void setModelNameNumberProperties(int modelIndex, String modelName, int modelNumber, Properties modelProperties) {
        this.modelNames[modelIndex] = modelName;
        this.modelNumbers[modelIndex] = modelNumber;
        this.modelProperties[modelIndex] = modelProperties;
        this.models[modelIndex] = new Model(this, modelIndex, modelName);
    }

    private void propogateSecondaryStructure() {
        int i = this.structureCount;
        while (--i >= 0) {
            Structure structure = this.structures[i];
            int j = this.modelCount;
            while (--j >= 0) {
                this.models[j].addSecondaryStructure(structure.type, structure.startChainID, structure.startSeqcode, structure.endChainID, structure.endSeqcode);
            }
        }
    }

    int getModelCount() {
        return this.modelCount;
    }

    Model[] getModels() {
        return this.models;
    }

    int getChainCount() {
        int chainCount = 0;
        int i = this.modelCount;
        while (--i >= 0) {
            chainCount += this.models[i].getChainCount();
        }
        return chainCount;
    }

    int getPolymerCount() {
        int polymerCount = 0;
        int i = this.modelCount;
        while (--i >= 0) {
            polymerCount += this.models[i].getPolymerCount();
        }
        return polymerCount;
    }

    int getPolymerCountInModel(int modelIndex) {
        return this.models[modelIndex].getPolymerCount();
    }

    Polymer getPolymerAt(int modelIndex, int polymerIndex) {
        return this.models[modelIndex].getPolymer(polymerIndex);
    }

    int getGroupCount() {
        int groupCount = 0;
        int i = this.modelCount;
        while (--i >= 0) {
            groupCount += this.models[i].getGroupCount();
        }
        return groupCount;
    }

    void calcSelectedGroupsCount(BitSet bsSelected) {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].calcSelectedGroupsCount(bsSelected);
        }
    }

    void calcSelectedMonomersCount(BitSet bsSelected) {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].calcSelectedMonomersCount(bsSelected);
        }
    }

    void calcHydrogenBonds() {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].calcHydrogenBonds();
        }
    }

    void selectSeqcodeRange(int seqcodeA, int seqcodeB, BitSet bs) {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].selectSeqcodeRange(seqcodeA, seqcodeB, bs);
        }
    }

    static class Structure {
        String typeName;
        byte type;
        char startChainID;
        int startSeqcode;
        char endChainID;
        int endSeqcode;

        Structure(String typeName, char startChainID, int startSeqcode, char endChainID, int endSeqcode) {
            this.typeName = typeName;
            this.startChainID = startChainID;
            this.startSeqcode = startSeqcode;
            this.endChainID = endChainID;
            this.endSeqcode = endSeqcode;
            this.type = "helix".equals(typeName) ? (byte)3 : ("sheet".equals(typeName) ? (byte)2 : ("turn".equals(typeName) ? (byte)1 : 0));
        }
    }
}

