/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Event;
import java.awt.Rectangle;
import org.jmol.viewer.Viewer;

abstract class MouseManager {
    static final int HOVER_TIME = 1000;
    Component component;
    Viewer viewer;
    Thread hoverWatcherThread;
    int previousDragX;
    int previousDragY;
    int xCurrent;
    int yCurrent;
    long timeCurrent;
    int modifiersWhenPressed;
    boolean wasDragged;
    boolean measurementMode = false;
    boolean hoverActive = false;
    boolean rubberbandSelectionMode = false;
    int xAnchor;
    int yAnchor;
    static final Rectangle rectRubber = new Rectangle();
    private static final boolean logMouseEvents = false;
    static final long MAX_DOUBLE_CLICK_MILLIS = 700L;
    static final int LEFT = 16;
    static final int MIDDLE = 8;
    static final int ALT = 8;
    static final int RIGHT = 4;
    static final int CTRL = 2;
    static final int SHIFT = 1;
    static final int MIDDLE_RIGHT = 12;
    static final int LEFT_MIDDLE_RIGHT = 28;
    static final int CTRL_SHIFT = 3;
    static final int CTRL_LEFT = 18;
    static final int CTRL_RIGHT = 6;
    static final int CTRL_MIDDLE = 10;
    static final int CTRL_ALT_LEFT = 26;
    static final int ALT_LEFT = 24;
    static final int ALT_SHIFT_LEFT = 25;
    static final int SHIFT_LEFT = 17;
    static final int CTRL_SHIFT_LEFT = 19;
    static final int CTRL_ALT_SHIFT_LEFT = 27;
    static final int SHIFT_MIDDLE = 9;
    static final int CTRL_SHIFT_MIDDLE = 11;
    static final int SHIFT_RIGHT = 5;
    static final int CTRL_SHIFT_RIGHT = 7;
    static final int CTRL_ALT_SHIFT_RIGHT = 15;
    static final int BUTTON_MODIFIER_MASK = 31;
    int previousPressedX;
    int previousPressedY;
    int previousPressedModifiers;
    int previousPressedCount;
    long previousPressedTime;
    int pressedCount;
    int previousClickX;
    int previousClickY;
    int previousClickModifiers;
    int previousClickCount;
    long previousClickTime;
    int mouseMovedX;
    int mouseMovedY;
    long mouseMovedTime;
    static final float wheelClickFractionUp = 1.25f;
    static final float wheelClickFractionDown = 0.8f;
    int measurementCount = 0;
    int[] measurementCountPlusIndices = new int[5];

    MouseManager(Component component, Viewer viewer) {
        this.component = component;
        this.viewer = viewer;
        this.hoverWatcherThread = new Thread(new HoverWatcher());
        this.hoverWatcherThread.start();
    }

    Rectangle getRubberBand() {
        if (!this.rubberbandSelectionMode) {
            return null;
        }
        return rectRubber;
    }

    void calcRectRubberBand() {
        if (this.xCurrent < this.xAnchor) {
            MouseManager.rectRubber.x = this.xCurrent;
            MouseManager.rectRubber.width = this.xAnchor - this.xCurrent;
        } else {
            MouseManager.rectRubber.x = this.xAnchor;
            MouseManager.rectRubber.width = this.xCurrent - this.xAnchor;
        }
        if (this.yCurrent < this.yAnchor) {
            MouseManager.rectRubber.y = this.yCurrent;
            MouseManager.rectRubber.height = this.yAnchor - this.yCurrent;
        } else {
            MouseManager.rectRubber.y = this.yAnchor;
            MouseManager.rectRubber.height = this.yCurrent - this.yAnchor;
        }
    }

    void mousePressed(long time, int x, int y, int modifiers, boolean isPopupTrigger) {
        this.pressedCount = this.previousPressedX == x && this.previousPressedY == y && this.previousPressedModifiers == modifiers && time - this.previousPressedTime < 700L ? ++this.pressedCount : 1;
        this.hoverOff();
        this.previousDragX = this.xCurrent = x;
        this.previousPressedX = this.xCurrent;
        this.previousDragY = this.yCurrent = y;
        this.previousPressedY = this.yCurrent;
        this.previousPressedModifiers = modifiers;
        this.previousPressedTime = this.timeCurrent = time;
        this.modifiersWhenPressed = modifiers;
        this.wasDragged = false;
        switch (modifiers & 0x1F) {
            case 4: 
            case 18: {
                this.viewer.popupMenu(x, y);
                return;
            }
        }
    }

    void mouseEntered(long time, int x, int y) {
        this.hoverOff();
        this.timeCurrent = time;
        this.xCurrent = x;
        this.yCurrent = y;
    }

    void mouseExited(long time, int x, int y) {
        this.hoverOff();
        this.timeCurrent = time;
        this.xCurrent = x;
        this.yCurrent = y;
        this.exitMeasurementMode();
    }

    void mouseReleased(long time, int x, int y, int modifiers) {
        this.hoverOff();
        this.timeCurrent = time;
        this.xCurrent = x;
        this.yCurrent = y;
        this.viewer.setInMotion(false);
    }

    void clearClickCount() {
        this.previousClickX = -1;
    }

    void mouseClicked(long time, int x, int y, int modifiers, int clickCount) {
        clickCount = 1;
        if (this.previousClickX == x && this.previousClickY == y && this.previousClickModifiers == modifiers && time - this.previousClickTime < 700L) {
            clickCount = this.previousClickCount + 1;
        }
        this.hoverOff();
        this.xCurrent = this.previousClickX = x;
        this.yCurrent = this.previousClickY = y;
        this.previousClickModifiers = modifiers;
        this.previousClickCount = clickCount;
        this.timeCurrent = this.previousClickTime = time;
        if (!this.viewer.haveFrame()) {
            return;
        }
        int nearestAtomIndex = this.viewer.findNearestAtomIndex(x, y);
        if (clickCount == 1) {
            this.mouseSingleClick(x, y, modifiers, nearestAtomIndex);
        } else if (clickCount == 2) {
            this.mouseDoubleClick(x, y, modifiers, nearestAtomIndex);
        }
    }

    void mouseSingleClick(int x, int y, int modifiers, int nearestAtomIndex) {
        switch (modifiers & 0x1F) {
            case 16: {
                if (this.viewer.frankClicked(x, y)) {
                    this.viewer.popupMenu(x, y);
                    return;
                }
                if (this.measurementMode) {
                    this.addToMeasurement(nearestAtomIndex, false);
                    break;
                }
                this.viewer.atomPicked(nearestAtomIndex, false);
                break;
            }
            case 17: {
                this.viewer.atomPicked(nearestAtomIndex, true);
            }
        }
    }

    void mouseDoubleClick(int x, int y, int modifiers, int nearestAtomIndex) {
        switch (modifiers & 0x1F) {
            case 16: {
                if (this.measurementMode) {
                    this.addToMeasurement(nearestAtomIndex, true);
                    this.toggleMeasurement();
                    break;
                }
                this.enterMeasurementMode();
                this.addToMeasurement(nearestAtomIndex, true);
                break;
            }
            case 8: 
            case 17: 
            case 24: {
                if (nearestAtomIndex >= 0) break;
                this.viewer.homePosition();
            }
        }
    }

    void mouseDragged(long time, int x, int y, int modifiers) {
        int deltaX = x - this.previousDragX;
        int deltaY = y - this.previousDragY;
        this.hoverOff();
        this.timeCurrent = time;
        this.xCurrent = this.previousDragX = x;
        this.yCurrent = this.previousDragY = y;
        this.wasDragged = true;
        this.viewer.setInMotion(true);
        if (this.pressedCount == 1) {
            this.mouseSinglePressDrag(deltaX, deltaY, modifiers);
        } else if (this.pressedCount == 2) {
            this.mouseDoublePressDrag(deltaX, deltaY, modifiers);
        }
    }

    void mouseSinglePressDrag(int deltaX, int deltaY, int modifiers) {
        switch (modifiers & 0x1F) {
            case 16: {
                this.viewer.rotateXYBy(deltaX, deltaY);
                break;
            }
            case 8: 
            case 17: 
            case 24: {
                this.viewer.zoomBy(deltaY);
            }
            case 5: {
                this.viewer.rotateZBy(-deltaX);
                break;
            }
            case 6: 
            case 26: {
                this.viewer.translateXYBy(deltaX, deltaY);
                break;
            }
            case 19: {
                if (!this.viewer.getSlabEnabled()) break;
                this.viewer.slabByPixels(deltaY);
                break;
            }
            case 27: {
                if (!this.viewer.getSlabEnabled()) break;
                this.viewer.slabDepthByPixels(deltaY);
            }
        }
    }

    void mouseDoublePressDrag(int deltaX, int deltaY, int modifiers) {
        switch (modifiers & 0x1F) {
            case 8: 
            case 17: 
            case 24: {
                this.viewer.translateXYBy(deltaX, deltaY);
                break;
            }
            case 19: {
                if (!this.viewer.getSlabEnabled()) break;
                this.viewer.depthByPixels(deltaY);
            }
        }
    }

    void mouseMoved(long time, int x, int y, int modifiers) {
        this.hoverOff();
        this.timeCurrent = this.mouseMovedTime = time;
        this.mouseMovedX = this.xCurrent = x;
        this.mouseMovedY = this.yCurrent = y;
        if (this.measurementMode | this.hoverActive) {
            int atomIndex = this.viewer.findNearestAtomIndex(x, y);
            if (this.measurementMode) {
                this.setAttractiveMeasurementTarget(atomIndex);
            }
        }
    }

    void mouseWheel(long time, int rotation, int modifiers) {
        this.hoverOff();
        this.timeCurrent = time;
        if (rotation == 0) {
            return;
        }
        if ((modifiers & 0x1F) == 0) {
            float zoomLevel = (float)this.viewer.getZoomPercentSetting() / 100.0f;
            if (rotation > 0) {
                while (--rotation >= 0) {
                    zoomLevel *= 1.25f;
                }
            } else {
                while (++rotation <= 0) {
                    zoomLevel *= 0.8f;
                }
            }
            this.viewer.zoomToPercent((int)(zoomLevel * 100.0f + 0.5f));
        }
    }

    abstract boolean handleOldJvm10Event(Event var1);

    void setAttractiveMeasurementTarget(int atomIndex) {
        int attractiveCount;
        if (this.measurementCountPlusIndices[0] == this.measurementCount + 1 && this.measurementCountPlusIndices[this.measurementCount + 1] == atomIndex) {
            this.viewer.refresh();
            return;
        }
        for (int i = this.measurementCount; i > 0; --i) {
            if (this.measurementCountPlusIndices[i] != atomIndex) continue;
            this.viewer.refresh();
            return;
        }
        this.measurementCountPlusIndices[0] = attractiveCount = this.measurementCount + 1;
        this.measurementCountPlusIndices[attractiveCount] = atomIndex;
        this.viewer.setPendingMeasurement(this.measurementCountPlusIndices);
    }

    void addToMeasurement(int atomIndex, boolean dblClick) {
        if (atomIndex == -1) {
            this.exitMeasurementMode();
            return;
        }
        int i = this.measurementCount;
        while (--i >= 0) {
            if (this.measurementCountPlusIndices[i + 1] != atomIndex) continue;
            return;
        }
        if (this.measurementCount == 3 && !dblClick) {
            return;
        }
        this.measurementCountPlusIndices[++this.measurementCount] = atomIndex;
        this.measurementCountPlusIndices[0] = this.measurementCount;
        if (this.measurementCount == 4) {
            this.toggleMeasurement();
        } else {
            this.viewer.setPendingMeasurement(this.measurementCountPlusIndices);
        }
    }

    void exitMeasurementMode() {
        if (this.measurementMode) {
            this.viewer.setPendingMeasurement(null);
            this.measurementMode = false;
            this.measurementCount = 0;
            this.viewer.getAwtComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    void enterMeasurementMode() {
        this.viewer.getAwtComponent().setCursor(Cursor.getPredefinedCursor(1));
        this.measurementCount = 0;
        this.measurementMode = true;
    }

    void toggleMeasurement() {
        if (this.measurementCount >= 2 && this.measurementCount <= 4) {
            this.measurementCountPlusIndices[0] = this.measurementCount;
            this.viewer.toggleMeasurement(this.measurementCountPlusIndices);
        }
        this.exitMeasurementMode();
    }

    void hoverOn(int atomIndex) {
        this.viewer.hoverOn(atomIndex);
    }

    void hoverOff() {
        this.viewer.hoverOff();
    }

    class HoverWatcher
    implements Runnable {
        HoverWatcher() {
        }

        public void run() {
            Thread.currentThread().setPriority(1);
            try {
                while (true) {
                    int atomIndex;
                    long currentTime;
                    int howLong;
                    Thread.sleep(1000L);
                    if (MouseManager.this.xCurrent != MouseManager.this.mouseMovedX || MouseManager.this.yCurrent != MouseManager.this.mouseMovedY || MouseManager.this.timeCurrent != MouseManager.this.mouseMovedTime || (howLong = (int)((currentTime = System.currentTimeMillis()) - MouseManager.this.mouseMovedTime)) <= 1000 || (atomIndex = MouseManager.this.viewer.findNearestAtomIndex(MouseManager.this.xCurrent, MouseManager.this.yCurrent)) == -1) continue;
                    MouseManager.this.hoverOn(atomIndex);
                }
            }
            catch (InterruptedException ie) {
                System.out.println("InterruptedException!");
                return;
            }
        }
    }
}

