/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.viewer.Atom;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.NucleicMonomer;
import org.jmol.viewer.Polymer;

class NucleicPolymer
extends Polymer {
    NucleicPolymer(Monomer[] monomers) {
        super(monomers);
    }

    Atom getNucleicPhosphorusAtom(int monomerIndex) {
        return this.monomers[monomerIndex].getLeadAtom();
    }

    boolean hasWingPoints() {
        return true;
    }

    void calcHydrogenBonds() {
        int i = this.model.getPolymerCount();
        while (--i >= 0) {
            Polymer otherPolymer = this.model.getPolymer(i);
            if (otherPolymer == this || otherPolymer == null || !(otherPolymer instanceof NucleicPolymer)) continue;
            this.lookForHbonds((NucleicPolymer)otherPolymer);
        }
    }

    void lookForHbonds(NucleicPolymer other) {
        int i = this.monomerCount;
        while (--i >= 0) {
            NucleicMonomer myNucleotide = (NucleicMonomer)this.monomers[i];
            if (!myNucleotide.isPurine()) continue;
            Atom myN1 = myNucleotide.getN1();
            Atom bestN3 = null;
            float minDist2 = 25.0f;
            NucleicMonomer bestNucleotide = null;
            int j = other.monomerCount;
            while (--j >= 0) {
                NucleicMonomer otherNucleotide = (NucleicMonomer)other.monomers[j];
                if (!otherNucleotide.isPyrimidine()) continue;
                Atom otherN3 = otherNucleotide.getN3();
                float dist2 = myN1.point3f.distanceSquared(otherN3.point3f);
                if (!(dist2 < minDist2)) continue;
                bestNucleotide = otherNucleotide;
                bestN3 = otherN3;
                minDist2 = dist2;
            }
            if (bestN3 == null) continue;
            this.createHydrogenBond(myN1, bestN3);
            if (myNucleotide.isGuanine()) {
                this.createHydrogenBond(myNucleotide.getN2(), bestNucleotide.getO2());
                this.createHydrogenBond(myNucleotide.getO6(), bestNucleotide.getN4());
                continue;
            }
            this.createHydrogenBond(myNucleotide.getN6(), bestNucleotide.getO4());
        }
    }

    void createHydrogenBond(Atom atom1, Atom atom2) {
        if (atom1 != null && atom2 != null) {
            Frame frame = this.model.mmset.frame;
            frame.bondAtoms(atom1, atom2, 512);
        }
    }
}

