/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Bmp;
import org.jmol.util.IntIntHash;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Util;
import org.jmol.viewer.Viewer;

class Sasurface1 {
    String surfaceID;
    Graphics3D g3d;
    Viewer viewer;
    short colix;
    Frame frame;
    short mad;
    boolean hide;
    private static final int GEODESIC_CALC_LEVEL = 2;
    int geodesicRenderingLevel = 2;
    int surfaceConvexMax;
    int[][] convexVertexMaps;
    int[][] convexFaceMaps;
    short[] colixesConvex;
    Vector3f[] geodesicVertexVectors;
    int geodesicVertexCount;
    int geodesicFaceCount;
    short[] geodesicFaceVertexes;
    short[] geodesicNeighborVertexes;
    int[] tempVertexMap;
    int[] tempFaceMap;
    int cavityCount;
    Cavity[] cavities;
    int torusCount;
    Torus[] toruses;
    IntIntHash htToruses;
    private static final boolean LOG = false;
    private static final short[] torusStepCounts = new short[]{20, 40, 40, 80};
    final Point3f pointT = new Point3f();
    final Point3f pointT1 = new Point3f();
    private static final float PI = (float)Math.PI;
    static final int segmentsPerFullCircle = 50;
    static final float radiansPerSegment = 0.12566371f;
    final Point3f[] pointStripT = new Point3f[50];
    final Vector3f stripSurfaceVector = new Vector3f();
    final Vector3f outerSurfaceVector = new Vector3f();
    final Point3f outerCenterPoint = new Point3f();
    final Point3f outerSurfacePoint = new Point3f();
    final Vector3f torusCavityAngleVector = new Vector3f();
    Vector3f[] probeVertexVectors;
    float radiusP;
    float diameterP;
    int indexI;
    int indexJ;
    int indexK;
    Atom atomI;
    Atom atomJ;
    Atom atomK;
    Point3f centerI;
    Point3f centerJ;
    Point3f centerK;
    private float radiusI;
    private float radiusJ;
    private float radiusK;
    private float radiiIP;
    private float radiiJP;
    private float radiiKP;
    private float radiiIP2;
    private float radiiJP2;
    private float radiiKP2;
    private float distanceIJ;
    private float distanceIK;
    private float distanceJK;
    private float distanceIJ2;
    private float distanceIK2;
    private float distanceJK2;
    int neighborCount;
    Atom[] neighborAtoms = new Atom[16];
    int[] neighborIndexes = new int[16];
    Point3f[] neighborCenters = new Point3f[16];
    float[] neighborPlusProbeRadii = new float[16];
    float[] neighborPlusProbeRadii2 = new float[16];
    int[] sortedNeighborIndexes = new int[16];
    final Matrix3f matrixT = new Matrix3f();
    final Matrix3f matrixT1 = new Matrix3f();
    final AxisAngle4f aaT = new AxisAngle4f();
    final AxisAngle4f aaT1 = new AxisAngle4f();
    final AxisAngle4f aaAxis = new AxisAngle4f();
    final Matrix3f matrixAxis = new Matrix3f();
    final AxisAngle4f aaOuterTangent = new AxisAngle4f();
    final Matrix3f matrixOuterTangent = new Matrix3f();
    static final Vector3f vectorNull = new Vector3f();
    static final Vector3f vectorX = new Vector3f(1.0f, 0.0f, 0.0f);
    static final Vector3f vectorY = new Vector3f(0.0f, 1.0f, 0.0f);
    static final Vector3f vectorZ = new Vector3f(0.0f, 0.0f, 1.0f);
    final Vector3f vectorT = new Vector3f();
    final Vector3f vectorT1 = new Vector3f();
    final Vector3f vectorTorusT = new Vector3f();
    final Vector3f vectorTorusTangentT = new Vector3f();
    final Vector3f vectorPI = new Vector3f();
    final Vector3f vectorPJ = new Vector3f();
    final Vector3f unitRadialVectorT = new Vector3f();
    final Vector3f radialVector90T = new Vector3f();
    final AxisAngle4f aaRotate = new AxisAngle4f();
    Point3f pointAtomI;
    Point3f pointAtomJ;
    final Vector3f vectorIP = new Vector3f();
    final Vector3f vectorJP = new Vector3f();
    float[] cavityAngles = new float[32];
    static final int INNER_TORUS_STEP_COUNT = 12;
    static final float INNER_TORUS_STEP_ANGLE = 0.5235988f;
    static final int OUTER_TORUS_STEP_COUNT = 11;
    final Vector3f[] outerRadials = new Vector3f[11];
    static final int ALL_PROBE_BITS_ON = -1048576;
    static final int FIRST_AND_LAST_BITS = 0x108000;
    static final int MAX_SEGMENT_COUNT = 6;
    final Point3f[] torusPoints;
    final Point3f[] torusEdgePointsT;
    Point3f[] convexEdgePoints;
    short[] edgeVertexes;
    private final Vector3f vectorIJ;
    private final Vector3f vectorIK;
    private final Vector3f normalIJK;
    private final Point3f torusCenterIJ;
    private final Point3f torusCenterIK;
    private final Point3f torusCenterJK;
    private final Point3f probeBaseIJK;
    private final Point3f cavityProbe;
    final Vector3f v2v3;
    final Vector3f v3v1;
    final Vector3f v1v2;
    final Vector3f uIJK;
    final Vector3f p1;
    final Vector3f p2;
    final Vector3f p3;
    final Vector3f vectorPK;
    final Vector3f vectorCrossIJ;
    final Vector3f vectorCrossIK;
    final Vector3f vectorCrossJK;

    Sasurface1(String surfaceID, Viewer viewer, Graphics3D g3d, short colix, BitSet bs) {
        int i = this.outerRadials.length;
        while (--i >= 0) {
            this.outerRadials[i] = new Vector3f();
        }
        this.torusPoints = new Point3f[132];
        i = this.torusPoints.length;
        while (--i >= 0) {
            this.torusPoints[i] = new Point3f();
        }
        this.torusEdgePointsT = new Point3f[12];
        i = this.torusEdgePointsT.length;
        while (--i >= 0) {
            this.torusEdgePointsT[i] = new Point3f();
        }
        this.vectorIJ = new Vector3f();
        this.vectorIK = new Vector3f();
        this.normalIJK = new Vector3f();
        this.torusCenterIJ = new Point3f();
        this.torusCenterIK = new Point3f();
        this.torusCenterJK = new Point3f();
        this.probeBaseIJK = new Point3f();
        this.cavityProbe = new Point3f();
        this.v2v3 = new Vector3f();
        this.v3v1 = new Vector3f();
        this.v1v2 = new Vector3f();
        this.uIJK = new Vector3f();
        this.p1 = new Vector3f();
        this.p2 = new Vector3f();
        this.p3 = new Vector3f();
        this.vectorPK = new Vector3f();
        this.vectorCrossIJ = new Vector3f();
        this.vectorCrossIK = new Vector3f();
        this.vectorCrossJK = new Vector3f();
        this.surfaceID = surfaceID;
        this.viewer = viewer;
        this.g3d = g3d;
        this.colix = colix;
        this.frame = viewer.getFrame();
        this.initShape();
        this.generate(bs);
    }

    void initShape() {
        this.geodesicVertexVectors = this.g3d.getGeodesicVertexVectors();
        this.geodesicVertexCount = this.g3d.getGeodesicVertexCount(2);
        this.tempVertexMap = Bmp.allocateBitmap((int)this.geodesicVertexCount);
        this.geodesicFaceCount = this.g3d.getGeodesicFaceCount(this.geodesicRenderingLevel);
        this.tempFaceMap = Bmp.allocateBitmap((int)this.geodesicFaceCount);
        this.geodesicFaceVertexes = this.g3d.getGeodesicFaceVertexes(this.geodesicRenderingLevel);
        this.geodesicNeighborVertexes = this.g3d.getGeodesicNeighborVertexes(this.geodesicRenderingLevel);
    }

    void clearAll() {
        this.surfaceConvexMax = 0;
        this.convexVertexMaps = null;
        this.convexFaceMaps = null;
        this.torusCount = 0;
        this.toruses = null;
        this.cavityCount = 0;
        this.cavities = null;
        this.htToruses = null;
        this.radiusP = this.viewer.getCurrentSolventProbeRadius();
        this.diameterP = 2.0f * this.radiusP;
        this.calcProbeVectors();
    }

    void generate(BitSet bsSelected) {
        int i;
        this.viewer.setSolventOn(true);
        this.clearAll();
        int atomCount = this.frame.atomCount;
        this.convexVertexMaps = new int[atomCount][];
        this.convexFaceMaps = new int[atomCount][];
        this.colixesConvex = new short[atomCount];
        this.htToruses = new IntIntHash();
        long timeBegin = System.currentTimeMillis();
        int surfaceAtomCount = 0;
        for (i = 0; i < atomCount; ++i) {
            if (!bsSelected.get(i)) continue;
            ++surfaceAtomCount;
            this.setAtomI(i);
            this.getNeighbors(bsSelected);
            this.sortNeighborIndexes();
            this.calcCavitiesI();
            if (this.convexVertexMaps[i] == null) continue;
            this.calcVertexBitmapI();
        }
        i = atomCount;
        while (--i >= 0) {
            int[] vertexMap = this.convexVertexMaps[i];
            if (vertexMap == null) continue;
            this.convexFaceMaps[i] = this.calcFaceBitmap(vertexMap);
        }
        i = this.torusCount;
        while (--i >= 0) {
            Torus torus = this.toruses[i];
            torus.checkCavityCorrectness0();
            torus.checkCavityCorrectness1();
            torus.electReferenceCavity();
            torus.calcVectors();
            torus.calcCavityAnglesAndSort();
            torus.checkCavityCorrectness2();
            torus.buildTorusSegments();
            torus.calcPointCounts();
            torus.calcNormixes();
            torus.connectWithGeodesics();
        }
        long timeElapsed = System.currentTimeMillis() - timeBegin;
        System.out.println("surface atom count=" + surfaceAtomCount);
        System.out.println("Surface construction time = " + timeElapsed + " ms");
        this.htToruses = null;
        int i2 = atomCount;
        while (--i2 >= 0 && this.convexVertexMaps[i2] == null) {
        }
        this.surfaceConvexMax = i2 + 1;
    }

    void setSize(int size, BitSet bsSelected) {
        short mad;
        this.mad = mad = (short)size;
        this.viewer.setSolventOn(true);
        if (this.radiusP != this.viewer.getCurrentSolventProbeRadius()) {
            this.surfaceConvexMax = 0;
            this.convexVertexMaps = null;
            this.convexFaceMaps = null;
            this.torusCount = 0;
            this.toruses = null;
            this.cavityCount = 0;
            this.cavities = null;
            this.radiusP = this.viewer.getCurrentSolventProbeRadius();
            this.diameterP = 2.0f * this.radiusP;
            this.calcProbeVectors();
        }
        int atomCount = this.frame.atomCount;
        if (this.convexVertexMaps == null) {
            this.convexVertexMaps = new int[atomCount][];
            this.convexFaceMaps = new int[atomCount][];
            this.colixesConvex = new short[atomCount];
        }
        int i = atomCount;
        while (--i >= 0) {
            if (!bsSelected.get(i)) continue;
            this.convexVertexMaps[i] = null;
            this.convexFaceMaps[i] = null;
        }
        this.deleteUnusedToruses();
        this.htToruses = new IntIntHash();
        if (mad != 0) {
            int i2;
            long timeBegin = System.currentTimeMillis();
            for (i2 = 0; i2 < atomCount; ++i2) {
                if (!bsSelected.get(i2)) continue;
                this.setAtomI(i2);
                this.getNeighbors(bsSelected);
                this.sortNeighborIndexes();
                this.calcCavitiesI();
                if (this.convexVertexMaps[i2] == null) continue;
                this.calcVertexBitmapI();
            }
            i2 = atomCount;
            while (--i2 >= 0) {
                int[] vertexMap = this.convexVertexMaps[i2];
                if (vertexMap == null) continue;
                this.convexFaceMaps[i2] = this.calcFaceBitmap(vertexMap);
            }
            long timeElapsed = System.currentTimeMillis() - timeBegin;
            System.out.println("atomCount=" + atomCount);
            System.out.println("Surface construction time = " + timeElapsed + " ms");
        }
        this.htToruses = null;
        if (this.convexVertexMaps == null) {
            this.surfaceConvexMax = 0;
        } else {
            i = atomCount;
            while (--i >= 0 && this.convexVertexMaps[i] == null) {
            }
            this.surfaceConvexMax = i + 1;
        }
    }

    void calcProbeVectors() {
        this.probeVertexVectors = new Vector3f[this.geodesicVertexCount];
        int i = this.geodesicVertexCount;
        while (--i >= 0) {
            this.probeVertexVectors[i] = new Vector3f();
            this.probeVertexVectors[i].scale(this.radiusP, (Tuple3f)this.geodesicVertexVectors[i]);
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        int atomCount = this.frame.atomCount;
        Atom[] atoms = this.frame.atoms;
        if ("color" == propertyName) {
            System.out.println("I am surfaceID:" + this.surfaceID + " Surface.setProperty(color," + value + ")");
            this.setProperty("colorConvex", value, bs);
            this.setProperty("colorConcave", value, bs);
            this.setProperty("colorSaddle", value, bs);
        }
        if ("translucency" == propertyName) {
            this.setProperty("translucencyConvex", value, bs);
            this.setProperty("translucencyConcave", value, bs);
            this.setProperty("translucencySaddle", value, bs);
        }
        if ("colorConvex" == propertyName) {
            System.out.println("Surface.setProperty('colorConvex')");
            short colix = Graphics3D.getColix((Object)value);
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                this.colixesConvex[i] = colix != 3 ? colix : this.viewer.getColixAtomPalette(atoms[i], (String)value);
            }
            return;
        }
        if ("translucencyConvex" == propertyName) {
            boolean isTranslucent = "translucent" == value;
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                this.colixesConvex[i] = Graphics3D.setTranslucent((short)this.colixesConvex[i], (boolean)isTranslucent);
            }
            return;
        }
        if ("colorSaddle" == propertyName) {
            short colix = Graphics3D.getColix((Object)value);
            int i = this.torusCount;
            while (--i >= 0) {
                Torus torus = this.toruses[i];
                if (bs.get(torus.ixA)) {
                    torus.colixA = colix;
                }
                if (!bs.get(torus.ixB)) continue;
                torus.colixB = colix;
            }
            return;
        }
        if ("translucencySaddle" == propertyName) {
            boolean isTranslucent = "translucent" == value;
            int i = this.torusCount;
            while (--i >= 0) {
                Torus torus = this.toruses[i];
                if (bs.get(torus.ixA)) {
                    torus.colixA = Graphics3D.setTranslucent((short)torus.colixA, (boolean)isTranslucent);
                }
                if (!bs.get(torus.ixB)) continue;
                torus.colixB = Graphics3D.setTranslucent((short)torus.colixB, (boolean)isTranslucent);
            }
            return;
        }
        if ("colorConcave" == propertyName) {
            short colix = Graphics3D.getColix((Object)value);
            return;
        }
        if ("translucencyConcave" == propertyName) {
            boolean isTranslucent = "translucent" == value;
            return;
        }
        if ("off" == propertyName) {
            this.hide = true;
            return;
        }
        if ("on" == propertyName) {
            this.hide = false;
            return;
        }
    }

    void setAtomI(int indexI) {
        this.indexI = indexI;
        this.atomI = this.frame.atoms[indexI];
        this.centerI = this.atomI.point3f;
        this.radiusI = this.atomI.getVanderwaalsRadiusFloat();
        this.radiiIP = this.radiusI + this.radiusP;
        this.radiiIP2 = this.radiiIP * this.radiiIP;
    }

    void setNeighborJ(int sortedNeighborIndex) {
        this.indexJ = this.neighborIndexes[sortedNeighborIndex];
        this.atomJ = this.neighborAtoms[sortedNeighborIndex];
        this.radiusJ = this.atomJ.getVanderwaalsRadiusFloat();
        this.radiiJP = this.neighborPlusProbeRadii[sortedNeighborIndex];
        this.radiiJP2 = this.neighborPlusProbeRadii2[sortedNeighborIndex];
        this.centerJ = this.neighborCenters[sortedNeighborIndex];
        this.distanceIJ2 = this.centerJ.distanceSquared(this.centerI);
        this.distanceIJ = (float)Math.sqrt(this.distanceIJ2);
    }

    void setNeighborK(int sortedNeighborIndex) {
        this.indexK = this.neighborIndexes[sortedNeighborIndex];
        this.atomK = this.neighborAtoms[sortedNeighborIndex];
        this.radiusK = this.atomK.getVanderwaalsRadiusFloat();
        this.radiiKP = this.neighborPlusProbeRadii[sortedNeighborIndex];
        this.radiiKP2 = this.neighborPlusProbeRadii2[sortedNeighborIndex];
        this.centerK = this.neighborCenters[sortedNeighborIndex];
        this.distanceIK2 = this.centerK.distanceSquared(this.centerI);
        this.distanceIK = (float)Math.sqrt(this.distanceIK2);
        this.distanceJK2 = this.centerK.distanceSquared(this.centerJ);
        this.distanceJK = (float)Math.sqrt(this.distanceJK2);
    }

    void calcVertexBitmapI() {
        Bmp.setAllBits((int[])this.tempVertexMap, (int)this.geodesicVertexCount);
        if (this.neighborCount > 0) {
            int iLastUsed = 0;
            int iDot = this.geodesicVertexCount;
            block0: while (--iDot >= 0) {
                this.pointT.set((Tuple3f)this.geodesicVertexVectors[iDot]);
                this.pointT.scaleAdd(this.radiiIP, (Tuple3f)this.centerI);
                int iStart = iLastUsed;
                do {
                    if (this.pointT.distanceSquared(this.neighborCenters[iLastUsed]) < this.neighborPlusProbeRadii2[iLastUsed]) {
                        Bmp.clearBit((int[])this.tempVertexMap, (int)iDot);
                        continue block0;
                    }
                    if (++iLastUsed != this.neighborCount) continue;
                    iLastUsed = 0;
                } while (iLastUsed != iStart);
            }
        }
        Bmp.orInto((int[])this.convexVertexMaps[this.indexI], (int[])this.tempVertexMap);
    }

    int[] calcFaceBitmap(int[] vertexMap) {
        Bmp.clearBitmap((int[])this.tempFaceMap);
        int i = this.geodesicFaceCount;
        int j = 3 * (i - 1);
        while (--i >= 0) {
            if (Bmp.getBit((int[])vertexMap, (int)this.geodesicFaceVertexes[j]) && Bmp.getBit((int[])vertexMap, (int)this.geodesicFaceVertexes[j + 1]) && Bmp.getBit((int[])vertexMap, (int)this.geodesicFaceVertexes[j + 2])) {
                Bmp.setBit((int[])this.tempFaceMap, (int)i);
            }
            j -= 3;
        }
        return Bmp.copyMinimalBitmap((int[])this.tempFaceMap);
    }

    void getNeighbors(BitSet bsSelected) {
        AtomIterator iter = this.frame.getWithinModelIterator(this.atomI, this.radiusI + this.diameterP + this.frame.getMaxVanderwaalsRadius());
        this.neighborCount = 0;
        while (iter.hasNext()) {
            float radii;
            Atom neighbor = iter.next();
            if (neighbor == this.atomI || !bsSelected.get(neighbor.atomIndex)) continue;
            float neighborRadius = neighbor.getVanderwaalsRadiusFloat();
            if (this.centerI.distance(neighbor.point3f) > this.radiusI + this.radiusP + this.radiusP + neighborRadius) continue;
            if (this.neighborCount == this.neighborAtoms.length) {
                this.neighborAtoms = (Atom[])Util.doubleLength(this.neighborAtoms);
                this.neighborIndexes = Util.doubleLength(this.neighborIndexes);
                this.neighborCenters = (Point3f[])Util.doubleLength(this.neighborCenters);
                this.neighborPlusProbeRadii = Util.doubleLength(this.neighborPlusProbeRadii);
                this.neighborPlusProbeRadii2 = Util.doubleLength(this.neighborPlusProbeRadii2);
            }
            this.neighborAtoms[this.neighborCount] = neighbor;
            this.neighborCenters[this.neighborCount] = neighbor.point3f;
            this.neighborIndexes[this.neighborCount] = neighbor.atomIndex;
            this.neighborPlusProbeRadii[this.neighborCount] = radii = neighborRadius + this.radiusP;
            this.neighborPlusProbeRadii2[this.neighborCount] = radii * radii;
            ++this.neighborCount;
        }
    }

    void sortNeighborIndexes() {
        this.sortedNeighborIndexes = Util.ensureLength(this.sortedNeighborIndexes, this.neighborCount);
        int i = this.neighborCount;
        while (--i >= 0) {
            this.sortedNeighborIndexes[i] = i;
        }
        i = this.neighborCount;
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                if (this.neighborIndexes[this.sortedNeighborIndexes[i]] <= this.neighborIndexes[this.sortedNeighborIndexes[j]]) continue;
                int t = this.sortedNeighborIndexes[i];
                this.sortedNeighborIndexes[i] = this.sortedNeighborIndexes[j];
                this.sortedNeighborIndexes[j] = t;
            }
        }
    }

    void deleteUnusedToruses() {
        boolean torusDeleted = false;
        int i = this.torusCount;
        while (--i >= 0) {
            Torus torus = this.toruses[i];
            if (this.convexVertexMaps[torus.ixA] != null || this.convexVertexMaps[torus.ixB] != null) continue;
            torusDeleted = true;
            this.toruses[i] = null;
        }
        if (torusDeleted) {
            int iDestination = 0;
            for (int iSource = 0; iSource < this.torusCount; ++iSource) {
                if (this.toruses[iSource] == null) continue;
                this.toruses[iDestination++] = this.toruses[iSource];
            }
            int i2 = this.torusCount;
            while (--i2 >= iDestination) {
                this.toruses[i2] = null;
            }
            this.torusCount = iDestination;
        }
    }

    void allocateConvexVertexBitmap(int atomIndex) {
        if (this.convexVertexMaps[atomIndex] == null) {
            this.convexVertexMaps[atomIndex] = Bmp.allocateBitmap((int)this.geodesicVertexCount);
        }
    }

    Torus createTorus(int indexI, int indexJ, Point3f torusCenterIJ, float torusRadius, boolean fullTorus) {
        if (indexI >= indexJ) {
            throw new NullPointerException();
        }
        if (this.htToruses.get(indexI, indexJ) != null) {
            throw new NullPointerException();
        }
        this.allocateConvexVertexBitmap(indexI);
        this.allocateConvexVertexBitmap(indexJ);
        Torus torus = new Torus(indexI, indexJ, torusCenterIJ, torusRadius, fullTorus);
        this.htToruses.put(indexI, indexJ, (Object)torus);
        this.saveTorus(torus);
        return torus;
    }

    void saveTorus(Torus torus) {
        if (this.toruses == null) {
            this.toruses = new Torus[128];
        } else if (this.torusCount == this.toruses.length) {
            this.toruses = (Torus[])Util.doubleLength(this.toruses);
        }
        this.toruses[this.torusCount++] = torus;
    }

    Torus getTorus(int atomIndexA, int atomIndexB) {
        if (atomIndexA >= atomIndexB) {
            throw new NullPointerException();
        }
        return (Torus)this.htToruses.get(atomIndexA, atomIndexB);
    }

    float calcTorusRadius(float radiusA, float radiusB, float distanceAB2) {
        float t1 = radiusA + radiusB + this.diameterP;
        float t2 = t1 * t1 - distanceAB2;
        float diff = radiusA - radiusB;
        float t3 = distanceAB2 - diff * diff;
        if (t2 <= 0.0f || t3 <= 0.0f || distanceAB2 == 0.0f) {
            System.out.println("calcTorusRadius\n radiusA=" + radiusA + " radiusB=" + radiusB + " distanceAB2=" + distanceAB2);
            System.out.println("distanceAB=" + Math.sqrt(distanceAB2) + " t1=" + t1 + " t2=" + t2 + " diff=" + diff + " t3=" + t3);
            throw new NullPointerException();
        }
        return (float)(0.5 * Math.sqrt(t2) * Math.sqrt(t3) / Math.sqrt(distanceAB2));
    }

    void calcCavitiesI() {
        if (this.radiusP == 0.0f) {
            return;
        }
        if (this.cavities == null) {
            this.cavities = new Cavity[32];
            this.cavityCount = 0;
        }
        int iJ = this.neighborCount;
        while (--iJ >= 0) {
            int sortedIndexJ = this.sortedNeighborIndexes[iJ];
            if (this.neighborIndexes[sortedIndexJ] <= this.indexI) continue;
            this.setNeighborJ(sortedIndexJ);
            if ((double)this.distanceIJ < 0.2) continue;
            this.vectorIJ.sub((Tuple3f)this.centerJ, (Tuple3f)this.centerI);
            this.calcTorusCenter(this.centerI, this.radiiIP2, this.centerJ, this.radiiJP2, this.distanceIJ2, this.torusCenterIJ);
            int iK = this.neighborCount;
            while (--iK >= 0) {
                int sortedIndexK = this.sortedNeighborIndexes[iK];
                if (this.neighborIndexes[sortedIndexK] <= this.indexJ) continue;
                this.setNeighborK(sortedIndexK);
                if ((double)this.distanceIK < 0.1 || (double)this.distanceJK < 0.1 || this.distanceJK >= this.radiiJP + this.radiiKP) continue;
                this.getCavitiesIJK();
            }
            this.checkFullTorusIJ();
        }
        if (this.neighborCount == 0) {
            this.allocateConvexVertexBitmap(this.indexI);
        }
    }

    void checkFullTorusIJ() {
        if (this.getTorus(this.indexI, this.indexJ) == null) {
            if (this.vectorIJ.z == 0.0f) {
                this.unitRadialVectorT.set((Tuple3f)vectorZ);
            } else {
                this.unitRadialVectorT.set(-this.vectorIJ.y, this.vectorIJ.x, 0.0f);
                this.unitRadialVectorT.normalize();
            }
            float torusRadiusIJ = this.calcTorusRadius(this.radiusI, this.radiusJ, this.distanceIJ2);
            this.pointT.scaleAdd(torusRadiusIJ, (Tuple3f)this.unitRadialVectorT, (Tuple3f)this.torusCenterIJ);
            if (this.checkProbeNotIJ(this.pointT)) {
                this.createTorus(this.indexI, this.indexJ, this.torusCenterIJ, torusRadiusIJ, true);
            }
        }
    }

    void getCavitiesIJK() {
        this.vectorIK.sub((Tuple3f)this.centerK, (Tuple3f)this.centerI);
        this.normalIJK.cross(this.vectorIJ, this.vectorIK);
        if (Float.isNaN(this.normalIJK.x)) {
            return;
        }
        this.normalIJK.normalize();
        this.calcTorusCenter(this.centerI, this.radiiIP2, this.centerK, this.radiiKP2, this.distanceIK2, this.torusCenterIK);
        if (!this.intersectPlanes(this.vectorIJ, this.torusCenterIJ, this.vectorIK, this.torusCenterIK, this.normalIJK, this.centerI, this.probeBaseIJK)) {
            return;
        }
        float probeHeight = this.calcProbeHeightIJK(this.probeBaseIJK);
        if (probeHeight <= 0.0f) {
            return;
        }
        Torus torusIJ = null;
        Torus torusIK = null;
        Torus torusJK = null;
        for (int i = -1; i <= 1; i += 2) {
            this.cavityProbe.scaleAdd((float)i * probeHeight, (Tuple3f)this.normalIJK, (Tuple3f)this.probeBaseIJK);
            if (!this.checkProbeAgainstNeighborsIJK(this.cavityProbe)) continue;
            boolean rightHanded = i == 1;
            this.allocateConvexVertexBitmap(this.indexI);
            this.allocateConvexVertexBitmap(this.indexJ);
            this.allocateConvexVertexBitmap(this.indexK);
            Cavity cavity = new Cavity(this.cavityProbe, this.probeBaseIJK);
            this.addCavity(cavity);
            if (torusIJ == null && (torusIJ = this.getTorus(this.indexI, this.indexJ)) == null) {
                torusIJ = this.createTorus(this.indexI, this.indexJ, this.torusCenterIJ, this.calcTorusRadius(this.radiusI, this.radiusJ, this.distanceIJ2), false);
            }
            torusIJ.addCavity(cavity, rightHanded);
            if (torusIK == null && (torusIK = this.getTorus(this.indexI, this.indexK)) == null) {
                torusIK = this.createTorus(this.indexI, this.indexK, this.torusCenterIK, this.calcTorusRadius(this.radiusI, this.radiusK, this.distanceIK2), false);
            }
            torusIK.addCavity(cavity, !rightHanded);
            if (torusJK == null && (torusJK = this.getTorus(this.indexJ, this.indexK)) == null) {
                this.calcTorusCenter(this.centerJ, this.radiiJP2, this.centerK, this.radiiKP2, this.distanceJK2, this.torusCenterJK);
                torusJK = this.createTorus(this.indexJ, this.indexK, this.torusCenterJK, this.calcTorusRadius(this.radiusJ, this.radiusK, this.distanceJK2), false);
            }
            torusJK.addCavity(cavity, rightHanded);
        }
    }

    void calcTorusCenter(Point3f centerA, float radiiAP2, Point3f centerB, float radiiBP2, float distanceAB2, Point3f torusCenter) {
        torusCenter.sub((Tuple3f)centerB, (Tuple3f)centerA);
        torusCenter.scale((radiiAP2 - radiiBP2) / distanceAB2);
        torusCenter.add((Tuple3f)centerA);
        torusCenter.add((Tuple3f)centerB);
        torusCenter.scale(0.5f);
    }

    boolean checkProbeNotIJ(Point3f probeCenter) {
        int i = this.neighborCount;
        while (--i >= 0) {
            int neighborIndex = this.neighborIndexes[i];
            if (neighborIndex == this.indexI || neighborIndex == this.indexJ || !(probeCenter.distanceSquared(this.neighborCenters[i]) < this.neighborPlusProbeRadii2[i])) continue;
            return false;
        }
        return true;
    }

    boolean checkProbeAgainstNeighborsIJK(Point3f cavityProbe) {
        int i = this.neighborCount;
        while (--i >= 0) {
            int neighborIndex = this.neighborIndexes[i];
            if (neighborIndex == this.indexI || neighborIndex == this.indexJ || neighborIndex == this.indexK || !(cavityProbe.distanceSquared(this.neighborCenters[i]) < this.neighborPlusProbeRadii2[i])) continue;
            return false;
        }
        return true;
    }

    boolean intersectPlanes(Vector3f v1, Point3f p1, Vector3f v2, Point3f p2, Vector3f v3, Point3f p3, Point3f intersection) {
        this.v2v3.cross(v2, v3);
        if (Float.isNaN(this.v2v3.x)) {
            return false;
        }
        this.v3v1.cross(v3, v1);
        if (Float.isNaN(this.v3v1.x)) {
            return false;
        }
        this.v1v2.cross(v1, v2);
        if (Float.isNaN(this.v1v2.x)) {
            return false;
        }
        float denominator = v1.dot(this.v2v3);
        if (denominator == 0.0f) {
            return false;
        }
        this.vectorT.set((Tuple3f)p1);
        intersection.scale(v1.dot(this.vectorT), (Tuple3f)this.v2v3);
        this.vectorT.set((Tuple3f)p2);
        intersection.scaleAdd(v2.dot(this.vectorT), (Tuple3f)this.v3v1, (Tuple3f)intersection);
        this.vectorT.set((Tuple3f)p3);
        intersection.scaleAdd(v3.dot(this.vectorT), (Tuple3f)this.v1v2, (Tuple3f)intersection);
        intersection.scale(1.0f / denominator);
        return !Float.isNaN(intersection.x);
    }

    float calcProbeHeightIJK(Point3f probeBaseIJK) {
        float hypotenuse2 = this.radiiIP2;
        this.vectorT.sub((Tuple3f)probeBaseIJK, (Tuple3f)this.centerI);
        float baseLength2 = this.vectorT.lengthSquared();
        float height2 = hypotenuse2 - baseLength2;
        if (height2 <= 0.0f) {
            return 0.0f;
        }
        return (float)Math.sqrt(height2);
    }

    void addCavity(Cavity cavity) {
        if (this.cavityCount == this.cavities.length) {
            this.cavities = (Cavity[])Util.doubleLength(this.cavities);
        }
        this.cavities[this.cavityCount++] = cavity;
    }

    class Cavity {
        final Point3f probeCenter;
        final Point3f pointBottom = new Point3f();
        final short normixBottom;

        Cavity(Point3f probeCenter, Point3f probeBase) {
            this.probeCenter = new Point3f(probeCenter);
            Sasurface1.this.vectorPI.sub((Tuple3f)Sasurface1.this.centerI, (Tuple3f)probeCenter);
            Sasurface1.this.vectorPI.normalize();
            Sasurface1.this.vectorPI.scale(Sasurface1.this.radiusP);
            Sasurface1.this.vectorPJ.sub((Tuple3f)Sasurface1.this.centerJ, (Tuple3f)probeCenter);
            Sasurface1.this.vectorPJ.normalize();
            Sasurface1.this.vectorPJ.scale(Sasurface1.this.radiusP);
            Sasurface1.this.vectorPK.sub((Tuple3f)Sasurface1.this.centerK, (Tuple3f)probeCenter);
            Sasurface1.this.vectorPK.normalize();
            Sasurface1.this.vectorPK.scale(Sasurface1.this.radiusP);
            Sasurface1.this.vectorT.add((Tuple3f)Sasurface1.this.vectorPI, (Tuple3f)Sasurface1.this.vectorPJ);
            Sasurface1.this.vectorT.add((Tuple3f)Sasurface1.this.vectorPK);
            Sasurface1.this.vectorT.normalize();
            this.pointBottom.scaleAdd(Sasurface1.this.radiusP, (Tuple3f)Sasurface1.this.vectorT, (Tuple3f)probeCenter);
            this.normixBottom = Sasurface1.this.g3d.getInverseNormix(Sasurface1.this.vectorT);
        }
    }

    class Torus {
        final int ixA;
        final int ixB;
        final Point3f center;
        final float radius;
        final boolean fullTorus;
        final Vector3f radialVector = new Vector3f();
        final Vector3f axisVector = new Vector3f();
        final Vector3f tangentVector = new Vector3f();
        final Vector3f outerRadial = new Vector3f();
        float outerAngle;
        short colixA;
        short colixB;
        byte outerPointCount;
        byte segmentStripCount;
        short totalPointCount;
        short[] normixes;
        short[] connectAConvex;
        int torusCavityCount;
        TorusCavity[] torusCavities;
        int torusSegmentCount;
        TorusSegment[] torusSegments;

        Torus(int indexA, int indexB, Point3f center, float radius, boolean fullTorus) {
            this.ixA = indexA;
            this.ixB = indexB;
            this.center = new Point3f(center);
            this.radius = radius;
            this.fullTorus = fullTorus;
        }

        void electReferenceCavity() {
            if (this.torusCavities == null) {
                return;
            }
            if (this.torusCavities[0].rightHanded) {
                return;
            }
            int i = this.torusCavityCount;
            while (--i > 0) {
                TorusCavity torusCavity = this.torusCavities[i];
                if (!torusCavity.rightHanded) continue;
                this.torusCavities[i] = this.torusCavities[0];
                this.torusCavities[0] = torusCavity;
                break;
            }
            if (!this.torusCavities[0].rightHanded) {
                throw new NullPointerException();
            }
        }

        void calcVectors() {
            Point3f centerA = Sasurface1.this.frame.atoms[this.ixA].point3f;
            Point3f centerB = Sasurface1.this.frame.atoms[this.ixB].point3f;
            this.axisVector.sub((Tuple3f)centerB, (Tuple3f)centerA);
            Point3f referenceProbePoint = null;
            if (this.torusCavities != null) {
                referenceProbePoint = this.torusCavities[0].cavity.probeCenter;
            } else {
                if (this.axisVector.x == 0.0f) {
                    Sasurface1.this.unitRadialVectorT.set((Tuple3f)vectorX);
                } else if (this.axisVector.y == 0.0f) {
                    Sasurface1.this.unitRadialVectorT.set((Tuple3f)vectorY);
                } else if (this.axisVector.z == 0.0f) {
                    Sasurface1.this.unitRadialVectorT.set((Tuple3f)vectorZ);
                } else {
                    Sasurface1.this.unitRadialVectorT.set(-this.axisVector.y, this.axisVector.x, 0.0f);
                    Sasurface1.this.unitRadialVectorT.normalize();
                }
                referenceProbePoint = Sasurface1.this.pointT;
                Sasurface1.this.pointT.scaleAdd(this.radius, (Tuple3f)Sasurface1.this.unitRadialVectorT, (Tuple3f)this.center);
            }
            this.radialVector.sub((Tuple3f)referenceProbePoint, (Tuple3f)this.center);
            Sasurface1.this.aaRotate.set(this.axisVector, 1.5707964f);
            Sasurface1.this.matrixT.set(Sasurface1.this.aaRotate);
            Sasurface1.this.matrixT.transform((Tuple3f)this.radialVector, (Tuple3f)Sasurface1.this.radialVector90T);
            this.tangentVector.cross(this.axisVector, this.radialVector);
            this.tangentVector.normalize();
            this.outerRadial.sub((Tuple3f)centerA, (Tuple3f)referenceProbePoint);
            this.outerRadial.normalize();
            this.outerRadial.scale(Sasurface1.this.radiusP);
            Sasurface1.this.vectorT.sub((Tuple3f)centerB, (Tuple3f)referenceProbePoint);
            this.outerAngle = this.outerRadial.angle(Sasurface1.this.vectorT);
        }

        void calcPointCounts() {
            int c = (int)((double)(11.0f * this.outerAngle) / Math.PI);
            if ((c = c + 1 & 0xFE) > 11) {
                c = 11;
            }
            int t = 0;
            int i = this.torusSegmentCount;
            while (--i >= 0) {
                t += this.torusSegments[i].stepCount;
            }
            System.out.println("segmentStripCount t=" + t);
            this.segmentStripCount = (byte)t;
            this.outerPointCount = (byte)c;
            this.totalPointCount = (short)(t * c);
            System.out.println("calcPointCounts:  segmentStripCount=" + this.segmentStripCount + " outerPointCount=" + this.outerPointCount + " totalPointCount=" + this.totalPointCount);
        }

        void transformOuterRadials() {
            float stepAngle1 = this.outerPointCount <= 1 ? 0.0f : this.outerAngle / (float)(this.outerPointCount - 1);
            Sasurface1.this.aaT1.set(this.tangentVector, stepAngle1 * (float)this.outerPointCount);
            int i = this.outerPointCount;
            while (--i > 0) {
                Sasurface1.this.aaT1.angle -= stepAngle1;
                Sasurface1.this.matrixT1.set(Sasurface1.this.aaT1);
                Sasurface1.this.matrixT1.transform((Tuple3f)this.outerRadial, (Tuple3f)Sasurface1.this.outerRadials[i]);
            }
            Sasurface1.this.outerRadials[0].set((Tuple3f)this.outerRadial);
        }

        void addCavity(Cavity cavity, boolean rightHanded) {
            if (this.torusCavities == null) {
                this.torusCavities = new TorusCavity[4];
            } else if (this.torusCavityCount == this.torusCavities.length) {
                this.torusCavities = (TorusCavity[])Util.doubleLength(this.torusCavities);
            }
            this.torusCavities[this.torusCavityCount] = new TorusCavity(cavity, rightHanded);
            ++this.torusCavityCount;
        }

        void checkCavityCorrectness0() {
            if (this.fullTorus ^ this.torusCavityCount == 0) {
                throw new NullPointerException();
            }
        }

        void checkCavityCorrectness1() {
            if ((this.torusCavityCount & 1) != 0) {
                throw new NullPointerException();
            }
            int rightCount = 0;
            int i = this.torusCavityCount;
            while (--i >= 0) {
                if (!this.torusCavities[i].rightHanded) continue;
                ++rightCount;
            }
            if (rightCount != this.torusCavityCount / 2) {
                throw new NullPointerException();
            }
        }

        void calcCavityAnglesAndSort() {
            if (this.torusCavities == null) {
                return;
            }
            int i = this.torusCavityCount;
            while (--i > 0) {
                this.torusCavities[i].calcAngle(this.center, this.radialVector, Sasurface1.this.radialVector90T);
            }
            this.sortCavitiesByAngle();
        }

        void sortCavitiesByAngle() {
            int i = this.torusCavityCount;
            while (--i >= 2) {
                TorusCavity champion = this.torusCavities[i];
                int j = i;
                while (--j > 0) {
                    TorusCavity challenger = this.torusCavities[j];
                    if (!(challenger.angle > champion.angle)) continue;
                    this.torusCavities[j] = champion;
                    this.torusCavities[i] = champion = challenger;
                }
            }
        }

        void checkCavityCorrectness2() {
            if (this.torusCavities == null) {
                return;
            }
            if ((this.torusCavityCount & 1) != 0) {
                throw new NullPointerException();
            }
            if (this.torusCavities[0].angle != 0.0f) {
                throw new NullPointerException();
            }
            int i = this.torusCavityCount;
            while (--i > 0) {
                if (this.torusCavities[i].angle <= this.torusCavities[i - 1].angle && i != this.torusCavityCount - 1) {
                    System.out.println("oops! <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                    for (int j = 0; j < this.torusCavityCount; ++j) {
                        System.out.println("cavity:" + j + " " + this.torusCavities[j].angle + " " + this.torusCavities[j].rightHanded);
                    }
                    throw new NullPointerException();
                }
                if (!((i & 1) == 0 ^ this.torusCavities[i].rightHanded)) continue;
                throw new NullPointerException();
            }
        }

        void buildTorusSegments() {
            if (this.torusCavityCount == 0) {
                this.addTorusSegment(new TorusSegment(0.0f, (float)Math.PI * 2));
            } else {
                for (int i = 0; i < this.torusCavityCount; i += 2) {
                    this.addTorusSegment(new TorusSegment(this.torusCavities[i].angle, this.torusCavities[i + 1].angle));
                }
            }
        }

        void addTorusSegment(TorusSegment torusSegment) {
            if (this.torusSegments == null) {
                this.torusSegments = new TorusSegment[4];
            }
            if (this.torusSegmentCount == this.torusSegments.length) {
                this.torusSegments = (TorusSegment[])Util.doubleLength(this.torusSegments);
            }
            this.torusSegments[this.torusSegmentCount++] = torusSegment;
        }

        void calcNormixes() {
            this.transformOuterRadials();
            this.normixes = new short[this.totalPointCount];
            short[] normixes = this.normixes;
            int ix = 0;
            for (int i = 0; i < this.torusSegmentCount; ++i) {
                ix = this.torusSegments[i].calcNormixes(normixes, ix);
            }
        }

        void calcPoints(Point3f[] points) {
            int indexStart = 0;
            this.transformOuterRadials();
            for (int i = 0; i < this.torusSegmentCount; ++i) {
                indexStart = this.torusSegments[i].calcPoints(points, indexStart);
            }
        }

        void calcScreens(Point3f[] points, Point3i[] screens) {
            int i = this.totalPointCount;
            while (--i >= 0) {
                Sasurface1.this.viewer.transformPoint(points[i], screens[i]);
            }
        }

        void connectWithGeodesics() {
            this.transformOuterRadials();
            for (int i = 0; i < this.torusSegmentCount; ++i) {
                this.torusSegments[i].connectWithGeodesic(true);
            }
        }

        class TorusSegment {
            float startAngle;
            float stepAngle;
            int stepCount;
            short[] geodesicConnections;

            TorusSegment(float startAngle, float endAngle) {
                this.startAngle = startAngle;
                float totalSegmentAngle = endAngle - startAngle;
                if (totalSegmentAngle < 0.0f) {
                    totalSegmentAngle += (float)Math.PI * 2;
                }
                this.stepCount = (int)(totalSegmentAngle / 0.5235988f);
                this.stepAngle = totalSegmentAngle / (float)this.stepCount;
                ++this.stepCount;
            }

            int calcPoints(Point3f[] points, int ixPoint) {
                ((Torus)Torus.this).Sasurface1.this.aaT.set(Torus.this.axisVector, this.startAngle);
                int i = this.stepCount;
                while (--i >= 0) {
                    ((Torus)Torus.this).Sasurface1.this.matrixT.set(((Torus)Torus.this).Sasurface1.this.aaT);
                    ((Torus)Torus.this).Sasurface1.this.matrixT.transform((Tuple3f)Torus.this.radialVector, (Tuple3f)((Torus)Torus.this).Sasurface1.this.pointT);
                    ((Torus)Torus.this).Sasurface1.this.pointT.add((Tuple3f)Torus.this.center);
                    int j = 0;
                    while (j < Torus.this.outerPointCount) {
                        ((Torus)Torus.this).Sasurface1.this.matrixT.transform((Tuple3f)((Torus)Torus.this).Sasurface1.this.outerRadials[j], (Tuple3f)((Torus)Torus.this).Sasurface1.this.vectorT);
                        points[ixPoint].add((Tuple3f)((Torus)Torus.this).Sasurface1.this.pointT, (Tuple3f)((Torus)Torus.this).Sasurface1.this.vectorT);
                        ++j;
                        ++ixPoint;
                    }
                    ((Torus)Torus.this).Sasurface1.this.aaT.angle += this.stepAngle;
                }
                return ixPoint;
            }

            int calcNormixes(short[] normixes, int ix) {
                ((Torus)Torus.this).Sasurface1.this.aaT.set(Torus.this.axisVector, this.startAngle);
                int i = this.stepCount;
                while (--i >= 0) {
                    ((Torus)Torus.this).Sasurface1.this.matrixT.set(((Torus)Torus.this).Sasurface1.this.aaT);
                    int j = 0;
                    while (j < Torus.this.outerPointCount) {
                        ((Torus)Torus.this).Sasurface1.this.matrixT.transform((Tuple3f)((Torus)Torus.this).Sasurface1.this.outerRadials[j], (Tuple3f)((Torus)Torus.this).Sasurface1.this.vectorT);
                        normixes[ix] = ((Torus)Torus.this).Sasurface1.this.g3d.get2SidedNormix(((Torus)Torus.this).Sasurface1.this.vectorT);
                        ++j;
                        ++ix;
                    }
                    ((Torus)Torus.this).Sasurface1.this.aaT.angle += this.stepAngle;
                }
                return ix;
            }

            void calcEdgePoints(Point3f[] edgePoints, boolean edgeA) {
                int outerRadialIndex;
                if (edgeA) {
                    Torus.this.transformOuterRadials();
                    outerRadialIndex = 0;
                } else {
                    outerRadialIndex = Torus.this.outerPointCount - 1;
                }
                ((Torus)Torus.this).Sasurface1.this.aaT.set(Torus.this.axisVector, this.startAngle);
                for (int i = 0; i < this.stepCount; ++i) {
                    ((Torus)Torus.this).Sasurface1.this.matrixT.set(((Torus)Torus.this).Sasurface1.this.aaT);
                    ((Torus)Torus.this).Sasurface1.this.matrixT.transform((Tuple3f)Torus.this.radialVector, (Tuple3f)((Torus)Torus.this).Sasurface1.this.pointT);
                    ((Torus)Torus.this).Sasurface1.this.pointT.add((Tuple3f)Torus.this.center);
                    ((Torus)Torus.this).Sasurface1.this.matrixT.transform((Tuple3f)((Torus)Torus.this).Sasurface1.this.outerRadials[outerRadialIndex], (Tuple3f)((Torus)Torus.this).Sasurface1.this.vectorT);
                    edgePoints[i].add((Tuple3f)((Torus)Torus.this).Sasurface1.this.pointT, (Tuple3f)((Torus)Torus.this).Sasurface1.this.vectorT);
                    ((Torus)Torus.this).Sasurface1.this.aaT.angle += this.stepAngle;
                }
            }

            void connectWithGeodesic(boolean edgeA) {
                int connectionIndex;
                if (edgeA) {
                    this.geodesicConnections = new short[2 * this.stepCount];
                    connectionIndex = 0;
                } else {
                    connectionIndex = this.stepCount;
                }
                this.calcEdgePoints(((Torus)Torus.this).Sasurface1.this.torusEdgePointsT, edgeA);
                Point3f atomCenter = ((Torus)Torus.this).Sasurface1.this.frame.atoms[edgeA ? Torus.this.ixA : Torus.this.ixB].point3f;
                for (int i = 0; i < this.stepCount; ++i) {
                    Point3f edgePoint = ((Torus)Torus.this).Sasurface1.this.torusEdgePointsT[i];
                    ((Torus)Torus.this).Sasurface1.this.vectorT.sub((Tuple3f)edgePoint, (Tuple3f)atomCenter);
                    short normix = ((Torus)Torus.this).Sasurface1.this.g3d.getNormix(((Torus)Torus.this).Sasurface1.this.vectorT, 2);
                    System.out.println("connected!");
                    this.geodesicConnections[connectionIndex++] = normix;
                }
            }
        }

        class TorusCavity {
            final Cavity cavity;
            final boolean rightHanded;
            float angle = 0.0f;

            TorusCavity(Cavity cavity, boolean rightHanded) {
                this.cavity = cavity;
                this.rightHanded = rightHanded;
            }

            void calcAngle(Point3f center, Vector3f radialVector, Vector3f radialVector90) {
                ((Torus)Torus.this).Sasurface1.this.torusCavityAngleVector.sub((Tuple3f)this.cavity.probeCenter, (Tuple3f)center);
                this.angle = ((Torus)Torus.this).Sasurface1.this.torusCavityAngleVector.angle(radialVector);
                float angleCavity90 = ((Torus)Torus.this).Sasurface1.this.torusCavityAngleVector.angle(radialVector90);
                if (angleCavity90 <= 1.5707964f) {
                    return;
                }
                this.angle = (float)Math.PI * 2 - this.angle;
            }
        }
    }
}

